/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetFindingRequest
extends AccessAnalyzerRequest
implements ToCopyableBuilder<Builder, GetFindingRequest> {
    private static final SdkField<String> ANALYZER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("analyzerArn").getter(GetFindingRequest.getter(GetFindingRequest::analyzerArn)).setter(GetFindingRequest.setter(Builder::analyzerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("analyzerArn").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetFindingRequest.getter(GetFindingRequest::id)).setter(GetFindingRequest.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("id").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_ARN_FIELD, ID_FIELD));
    private final String analyzerArn;
    private final String id;

    private GetFindingRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerArn = builder.analyzerArn;
        this.id = builder.id;
    }

    public final String analyzerArn() {
        return this.analyzerArn;
    }

    public final String id() {
        return this.id;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetFindingRequest)) {
            return false;
        }
        GetFindingRequest other = (GetFindingRequest)((Object)obj);
        return Objects.equals(this.analyzerArn(), other.analyzerArn()) && Objects.equals(this.id(), other.id());
    }

    public final String toString() {
        return ToString.builder((String)"GetFindingRequest").add("AnalyzerArn", (Object)this.analyzerArn()).add("Id", (Object)this.id()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzerArn": {
                return Optional.ofNullable(clazz.cast(this.analyzerArn()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetFindingRequest, T> g) {
        return obj -> g.apply((GetFindingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerRequest.BuilderImpl
    implements Builder {
        private String analyzerArn;
        private String id;

        private BuilderImpl() {
        }

        private BuilderImpl(GetFindingRequest model) {
            super(model);
            this.analyzerArn(model.analyzerArn);
            this.id(model.id);
        }

        public final String getAnalyzerArn() {
            return this.analyzerArn;
        }

        public final void setAnalyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
        }

        @Override
        @Transient
        public final Builder analyzerArn(String analyzerArn) {
            this.analyzerArn = analyzerArn;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        @Transient
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetFindingRequest build() {
            return new GetFindingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetFindingRequest> {
        public Builder analyzerArn(String var1);

        public Builder id(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

