/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.accessanalyzer.model.JobStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PolicyGeneration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PolicyGeneration> {
    private static final SdkField<Instant> COMPLETED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("completedOn").getter(PolicyGeneration.getter(PolicyGeneration::completedOn)).setter(PolicyGeneration.setter(Builder::completedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("completedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(PolicyGeneration.getter(PolicyGeneration::jobId)).setter(PolicyGeneration.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()}).build();
    private static final SdkField<String> PRINCIPAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("principalArn").getter(PolicyGeneration.getter(PolicyGeneration::principalArn)).setter(PolicyGeneration.setter(Builder::principalArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalArn").build()}).build();
    private static final SdkField<Instant> STARTED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("startedOn").getter(PolicyGeneration.getter(PolicyGeneration::startedOn)).setter(PolicyGeneration.setter(Builder::startedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedOn").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(PolicyGeneration.getter(PolicyGeneration::statusAsString)).setter(PolicyGeneration.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPLETED_ON_FIELD, JOB_ID_FIELD, PRINCIPAL_ARN_FIELD, STARTED_ON_FIELD, STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant completedOn;
    private final String jobId;
    private final String principalArn;
    private final Instant startedOn;
    private final String status;

    private PolicyGeneration(BuilderImpl builder) {
        this.completedOn = builder.completedOn;
        this.jobId = builder.jobId;
        this.principalArn = builder.principalArn;
        this.startedOn = builder.startedOn;
        this.status = builder.status;
    }

    public final Instant completedOn() {
        return this.completedOn;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String principalArn() {
        return this.principalArn;
    }

    public final Instant startedOn() {
        return this.startedOn;
    }

    public final JobStatus status() {
        return JobStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.completedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.principalArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.startedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PolicyGeneration)) {
            return false;
        }
        PolicyGeneration other = (PolicyGeneration)obj;
        return Objects.equals(this.completedOn(), other.completedOn()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.principalArn(), other.principalArn()) && Objects.equals(this.startedOn(), other.startedOn()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"PolicyGeneration").add("CompletedOn", (Object)this.completedOn()).add("JobId", (Object)this.jobId()).add("PrincipalArn", (Object)this.principalArn()).add("StartedOn", (Object)this.startedOn()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "completedOn": {
                return Optional.ofNullable(clazz.cast(this.completedOn()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "principalArn": {
                return Optional.ofNullable(clazz.cast(this.principalArn()));
            }
            case "startedOn": {
                return Optional.ofNullable(clazz.cast(this.startedOn()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PolicyGeneration, T> g) {
        return obj -> g.apply((PolicyGeneration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant completedOn;
        private String jobId;
        private String principalArn;
        private Instant startedOn;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(PolicyGeneration model) {
            this.completedOn(model.completedOn);
            this.jobId(model.jobId);
            this.principalArn(model.principalArn);
            this.startedOn(model.startedOn);
            this.status(model.status);
        }

        public final Instant getCompletedOn() {
            return this.completedOn;
        }

        @Override
        public final Builder completedOn(Instant completedOn) {
            this.completedOn = completedOn;
            return this;
        }

        public final void setCompletedOn(Instant completedOn) {
            this.completedOn = completedOn;
        }

        public final String getJobId() {
            return this.jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        public final String getPrincipalArn() {
            return this.principalArn;
        }

        @Override
        public final Builder principalArn(String principalArn) {
            this.principalArn = principalArn;
            return this;
        }

        public final void setPrincipalArn(String principalArn) {
            this.principalArn = principalArn;
        }

        public final Instant getStartedOn() {
            return this.startedOn;
        }

        @Override
        public final Builder startedOn(Instant startedOn) {
            this.startedOn = startedOn;
            return this;
        }

        public final void setStartedOn(Instant startedOn) {
            this.startedOn = startedOn;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(JobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public PolicyGeneration build() {
            return new PolicyGeneration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PolicyGeneration> {
        public Builder completedOn(Instant var1);

        public Builder jobId(String var1);

        public Builder principalArn(String var1);

        public Builder startedOn(Instant var1);

        public Builder status(String var1);

        public Builder status(JobStatus var1);
    }
}

