/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AclPermission {
    READ("READ"),
    WRITE("WRITE"),
    READ_ACP("READ_ACP"),
    WRITE_ACP("WRITE_ACP"),
    FULL_CONTROL("FULL_CONTROL"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AclPermission(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AclPermission fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AclPermission.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AclPermission> knownValues() {
        return Stream.of(AclPermission.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

