/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.accessanalyzer.model.Criterion;
import software.amazon.awssdk.services.accessanalyzer.model.FilterCriteriaMapCopier;
import software.amazon.awssdk.utils.CollectionUtils;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InlineArchiveRule
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InlineArchiveRule> {
    private static final SdkField<Map<String, Criterion>> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("filter").getter(InlineArchiveRule.getter(InlineArchiveRule::filter)).setter(InlineArchiveRule.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Criterion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleName").getter(InlineArchiveRule.getter(InlineArchiveRule::ruleName)).setter(InlineArchiveRule.setter(Builder::ruleName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD, RULE_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final Map<String, Criterion> filter;
    private final String ruleName;

    private InlineArchiveRule(BuilderImpl builder) {
        this.filter = builder.filter;
        this.ruleName = builder.ruleName;
    }

    public final boolean hasFilter() {
        return this.filter != null && !(this.filter instanceof SdkAutoConstructMap);
    }

    public final Map<String, Criterion> filter() {
        return this.filter;
    }

    public final String ruleName() {
        return this.ruleName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFilter() ? this.filter() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InlineArchiveRule)) {
            return false;
        }
        InlineArchiveRule other = (InlineArchiveRule)obj;
        return this.hasFilter() == other.hasFilter() && Objects.equals(this.filter(), other.filter()) && Objects.equals(this.ruleName(), other.ruleName());
    }

    public final String toString() {
        return ToString.builder((String)"InlineArchiveRule").add("Filter", this.hasFilter() ? this.filter() : null).add("RuleName", (Object)this.ruleName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
            case "ruleName": {
                return Optional.ofNullable(clazz.cast(this.ruleName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InlineArchiveRule, T> g) {
        return obj -> g.apply((InlineArchiveRule)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, Criterion> filter = DefaultSdkAutoConstructMap.getInstance();
        private String ruleName;

        private BuilderImpl() {
        }

        private BuilderImpl(InlineArchiveRule model) {
            this.filter(model.filter);
            this.ruleName(model.ruleName);
        }

        public final Map<String, Criterion.Builder> getFilter() {
            if (this.filter instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.filter != null ? CollectionUtils.mapValues(this.filter, Criterion::toBuilder) : null;
        }

        @Override
        public final Builder filter(Map<String, Criterion> filter) {
            this.filter = FilterCriteriaMapCopier.copy(filter);
            return this;
        }

        public final void setFilter(Map<String, Criterion.BuilderImpl> filter) {
            this.filter = FilterCriteriaMapCopier.copyFromBuilder(filter);
        }

        public final String getRuleName() {
            return this.ruleName;
        }

        @Override
        public final Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            return this;
        }

        public final void setRuleName(String ruleName) {
            this.ruleName = ruleName;
        }

        public InlineArchiveRule build() {
            return new InlineArchiveRule(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InlineArchiveRule> {
        public Builder filter(Map<String, Criterion> var1);

        public Builder ruleName(String var1);
    }
}

