/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Validation exception error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends AccessAnalyzerException implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final SdkField<List<ValidationExceptionField>> FIELD_LIST_FIELD = SdkField
            .<List<ValidationExceptionField>> builder(MarshallingType.LIST)
            .memberName("fieldList")
            .getter(getter(ValidationException::fieldList))
            .setter(setter(Builder::fieldList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationExceptionField> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationExceptionField::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ValidationException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FIELD_LIST_FIELD, REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<ValidationExceptionField> fieldList;

    private final String reason;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.fieldList = builder.fieldList;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * Returns true if the FieldList property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFieldList() {
        return fieldList != null && !(fieldList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of fields that didn't validate.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFieldList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of fields that didn't validate.
     */
    public List<ValidationExceptionField> fieldList() {
        return fieldList;
    }

    /**
     * <p>
     * The reason for the exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the exception.
     * @see ValidationExceptionReason
     */
    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * The reason for the exception.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The reason for the exception.
     * @see ValidationExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>, AccessAnalyzerException.Builder {
        /**
         * <p>
         * A list of fields that didn't validate.
         * </p>
         * 
         * @param fieldList
         *        A list of fields that didn't validate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldList(Collection<ValidationExceptionField> fieldList);

        /**
         * <p>
         * A list of fields that didn't validate.
         * </p>
         * 
         * @param fieldList
         *        A list of fields that didn't validate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldList(ValidationExceptionField... fieldList);

        /**
         * <p>
         * A list of fields that didn't validate.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ValidationExceptionField>.Builder} avoiding
         * the need to create one manually via {@link List<ValidationExceptionField>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ValidationExceptionField>.Builder#build()} is called
         * immediately and its result is passed to {@link #fieldList(List<ValidationExceptionField>)}.
         * 
         * @param fieldList
         *        a consumer that will call methods on {@link List<ValidationExceptionField>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fieldList(List<ValidationExceptionField>)
         */
        Builder fieldList(Consumer<ValidationExceptionField.Builder>... fieldList);

        /**
         * <p>
         * The reason for the exception.
         * </p>
         * 
         * @param reason
         *        The reason for the exception.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The reason for the exception.
         * </p>
         * 
         * @param reason
         *        The reason for the exception.
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(ValidationExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);
    }

    static final class BuilderImpl extends AccessAnalyzerException.BuilderImpl implements Builder {
        private List<ValidationExceptionField> fieldList = DefaultSdkAutoConstructList.getInstance();

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            fieldList(model.fieldList);
            reason(model.reason);
        }

        public final Collection<ValidationExceptionField.Builder> getFieldList() {
            if (fieldList instanceof SdkAutoConstructList) {
                return null;
            }
            return fieldList != null ? fieldList.stream().map(ValidationExceptionField::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder fieldList(Collection<ValidationExceptionField> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copy(fieldList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(ValidationExceptionField... fieldList) {
            fieldList(Arrays.asList(fieldList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fieldList(Consumer<ValidationExceptionField.Builder>... fieldList) {
            fieldList(Stream.of(fieldList).map(c -> ValidationExceptionField.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFieldList(Collection<ValidationExceptionField.BuilderImpl> fieldList) {
            this.fieldList = ValidationExceptionFieldListCopier.copyFromBuilder(fieldList);
        }

        public final String getReason() {
            return reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
