/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a finding.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Finding implements SdkPojo, Serializable, ToCopyableBuilder<Finding.Builder, Finding> {
    private static final SdkField<List<String>> ACTION_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("action")
            .getter(getter(Finding::action))
            .setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("analyzedAt")
            .getter(getter(Finding::analyzedAt))
            .setter(setter(Builder::analyzedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Map<String, String>> CONDITION_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("condition")
            .getter(getter(Finding::condition))
            .setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(Finding::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(Finding::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(Finding::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPublic").getter(getter(Finding::isPublic)).setter(setter(Builder::isPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()).build();

    private static final SdkField<Map<String, String>> PRINCIPAL_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("principal")
            .getter(getter(Finding::principal))
            .setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principal").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(Finding::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwnerAccount").getter(getter(Finding::resourceOwnerAccount))
            .setter(setter(Builder::resourceOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(Finding::resourceTypeAsString)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<FindingSource>> SOURCES_FIELD = SdkField
            .<List<FindingSource>> builder(MarshallingType.LIST)
            .memberName("sources")
            .getter(getter(Finding::sources))
            .setter(setter(Builder::sources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FindingSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(FindingSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(Finding::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(Finding::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            ANALYZED_AT_FIELD, CONDITION_FIELD, CREATED_AT_FIELD, ERROR_FIELD, ID_FIELD, IS_PUBLIC_FIELD, PRINCIPAL_FIELD,
            RESOURCE_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD, RESOURCE_TYPE_FIELD, SOURCES_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> action;

    private final Instant analyzedAt;

    private final Map<String, String> condition;

    private final Instant createdAt;

    private final String error;

    private final String id;

    private final Boolean isPublic;

    private final Map<String, String> principal;

    private final String resource;

    private final String resourceOwnerAccount;

    private final String resourceType;

    private final List<FindingSource> sources;

    private final String status;

    private final Instant updatedAt;

    private Finding(BuilderImpl builder) {
        this.action = builder.action;
        this.analyzedAt = builder.analyzedAt;
        this.condition = builder.condition;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.id = builder.id;
        this.isPublic = builder.isPublic;
        this.principal = builder.principal;
        this.resource = builder.resource;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceType = builder.resourceType;
        this.sources = builder.sources;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * Returns true if the Action property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasAction() {
        return action != null && !(action instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The action in the analyzed policy statement that an external principal has permission to use.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAction()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The action in the analyzed policy statement that an external principal has permission to use.
     */
    public final List<String> action() {
        return action;
    }

    /**
     * <p>
     * The time at which the resource was analyzed.
     * </p>
     * 
     * @return The time at which the resource was analyzed.
     */
    public final Instant analyzedAt() {
        return analyzedAt;
    }

    /**
     * Returns true if the Condition property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasCondition() {
        return condition != null && !(condition instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The condition in the analyzed policy statement that resulted in a finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasCondition()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The condition in the analyzed policy statement that resulted in a finding.
     */
    public final Map<String, String> condition() {
        return condition;
    }

    /**
     * <p>
     * The time at which the finding was generated.
     * </p>
     * 
     * @return The time at which the finding was generated.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An error.
     * </p>
     * 
     * @return An error.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The ID of the finding.
     * </p>
     * 
     * @return The ID of the finding.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * Indicates whether the policy that generated the finding allows public access to the resource.
     * </p>
     * 
     * @return Indicates whether the policy that generated the finding allows public access to the resource.
     */
    public final Boolean isPublic() {
        return isPublic;
    }

    /**
     * Returns true if the Principal property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPrincipal() {
        return principal != null && !(principal instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The external principal that access to a resource within the zone of trust.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPrincipal()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The external principal that access to a resource within the zone of trust.
     */
    public final Map<String, String> principal() {
        return principal;
    }

    /**
     * <p>
     * The resource that an external principal has access to.
     * </p>
     * 
     * @return The resource that an external principal has access to.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The AWS account ID that owns the resource.
     * </p>
     * 
     * @return The AWS account ID that owns the resource.
     */
    public final String resourceOwnerAccount() {
        return resourceOwnerAccount;
    }

    /**
     * <p>
     * The type of the resource reported in the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource reported in the finding.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource reported in the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource reported in the finding.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns true if the Sources property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSources() {
        return sources != null && !(sources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sources of the finding. This indicates how the access that generated the finding is granted. It is populated
     * for Amazon S3 bucket findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSources()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The sources of the finding. This indicates how the access that generated the finding is granted. It is
     *         populated for Amazon S3 bucket findings.
     */
    public final List<FindingSource> sources() {
        return sources;
    }

    /**
     * <p>
     * The current status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the finding.
     * @see FindingStatus
     */
    public final FindingStatus status() {
        return FindingStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the finding.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the finding.
     * @see FindingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the finding was updated.
     * </p>
     * 
     * @return The time at which the finding was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAction() ? action() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(hasCondition() ? condition() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrincipal() ? principal() : null);
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSources() ? sources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Finding)) {
            return false;
        }
        Finding other = (Finding) obj;
        return hasAction() == other.hasAction() && Objects.equals(action(), other.action())
                && Objects.equals(analyzedAt(), other.analyzedAt()) && hasCondition() == other.hasCondition()
                && Objects.equals(condition(), other.condition()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(error(), other.error()) && Objects.equals(id(), other.id())
                && Objects.equals(isPublic(), other.isPublic()) && hasPrincipal() == other.hasPrincipal()
                && Objects.equals(principal(), other.principal()) && Objects.equals(resource(), other.resource())
                && Objects.equals(resourceOwnerAccount(), other.resourceOwnerAccount())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasSources() == other.hasSources()
                && Objects.equals(sources(), other.sources()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Finding").add("Action", hasAction() ? action() : null).add("AnalyzedAt", analyzedAt())
                .add("Condition", hasCondition() ? condition() : null).add("CreatedAt", createdAt()).add("Error", error())
                .add("Id", id()).add("IsPublic", isPublic()).add("Principal", hasPrincipal() ? principal() : null)
                .add("Resource", resource()).add("ResourceOwnerAccount", resourceOwnerAccount())
                .add("ResourceType", resourceTypeAsString()).add("Sources", hasSources() ? sources() : null)
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "action":
            return Optional.ofNullable(clazz.cast(action()));
        case "analyzedAt":
            return Optional.ofNullable(clazz.cast(analyzedAt()));
        case "condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "isPublic":
            return Optional.ofNullable(clazz.cast(isPublic()));
        case "principal":
            return Optional.ofNullable(clazz.cast(principal()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "resourceOwnerAccount":
            return Optional.ofNullable(clazz.cast(resourceOwnerAccount()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "sources":
            return Optional.ofNullable(clazz.cast(sources()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Finding, T> g) {
        return obj -> g.apply((Finding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Finding> {
        /**
         * <p>
         * The action in the analyzed policy statement that an external principal has permission to use.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that an external principal has permission to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(Collection<String> action);

        /**
         * <p>
         * The action in the analyzed policy statement that an external principal has permission to use.
         * </p>
         * 
         * @param action
         *        The action in the analyzed policy statement that an external principal has permission to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder action(String... action);

        /**
         * <p>
         * The time at which the resource was analyzed.
         * </p>
         * 
         * @param analyzedAt
         *        The time at which the resource was analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedAt(Instant analyzedAt);

        /**
         * <p>
         * The condition in the analyzed policy statement that resulted in a finding.
         * </p>
         * 
         * @param condition
         *        The condition in the analyzed policy statement that resulted in a finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(Map<String, String> condition);

        /**
         * <p>
         * The time at which the finding was generated.
         * </p>
         * 
         * @param createdAt
         *        The time at which the finding was generated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An error.
         * </p>
         * 
         * @param error
         *        An error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The ID of the finding.
         * </p>
         * 
         * @param id
         *        The ID of the finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * Indicates whether the policy that generated the finding allows public access to the resource.
         * </p>
         * 
         * @param isPublic
         *        Indicates whether the policy that generated the finding allows public access to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPublic(Boolean isPublic);

        /**
         * <p>
         * The external principal that access to a resource within the zone of trust.
         * </p>
         * 
         * @param principal
         *        The external principal that access to a resource within the zone of trust.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(Map<String, String> principal);

        /**
         * <p>
         * The resource that an external principal has access to.
         * </p>
         * 
         * @param resource
         *        The resource that an external principal has access to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The AWS account ID that owns the resource.
         * </p>
         * 
         * @param resourceOwnerAccount
         *        The AWS account ID that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerAccount(String resourceOwnerAccount);

        /**
         * <p>
         * The type of the resource reported in the finding.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource reported in the finding.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource reported in the finding.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource reported in the finding.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is
         * populated for Amazon S3 bucket findings.
         * </p>
         * 
         * @param sources
         *        The sources of the finding. This indicates how the access that generated the finding is granted. It is
         *        populated for Amazon S3 bucket findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(Collection<FindingSource> sources);

        /**
         * <p>
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is
         * populated for Amazon S3 bucket findings.
         * </p>
         * 
         * @param sources
         *        The sources of the finding. This indicates how the access that generated the finding is granted. It is
         *        populated for Amazon S3 bucket findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sources(FindingSource... sources);

        /**
         * <p>
         * The sources of the finding. This indicates how the access that generated the finding is granted. It is
         * populated for Amazon S3 bucket findings.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FindingSource>.Builder} avoiding the need
         * to create one manually via {@link List<FindingSource>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FindingSource>.Builder#build()} is called immediately and
         * its result is passed to {@link #sources(List<FindingSource>)}.
         * 
         * @param sources
         *        a consumer that will call methods on {@link List<FindingSource>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sources(List<FindingSource>)
         */
        Builder sources(Consumer<FindingSource.Builder>... sources);

        /**
         * <p>
         * The current status of the finding.
         * </p>
         * 
         * @param status
         *        The current status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the finding.
         * </p>
         * 
         * @param status
         *        The current status of the finding.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(FindingStatus status);

        /**
         * <p>
         * The time at which the finding was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the finding was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private List<String> action = DefaultSdkAutoConstructList.getInstance();

        private Instant analyzedAt;

        private Map<String, String> condition = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private String error;

        private String id;

        private Boolean isPublic;

        private Map<String, String> principal = DefaultSdkAutoConstructMap.getInstance();

        private String resource;

        private String resourceOwnerAccount;

        private String resourceType;

        private List<FindingSource> sources = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(Finding model) {
            action(model.action);
            analyzedAt(model.analyzedAt);
            condition(model.condition);
            createdAt(model.createdAt);
            error(model.error);
            id(model.id);
            isPublic(model.isPublic);
            principal(model.principal);
            resource(model.resource);
            resourceOwnerAccount(model.resourceOwnerAccount);
            resourceType(model.resourceType);
            sources(model.sources);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final Collection<String> getAction() {
            if (action instanceof SdkAutoConstructList) {
                return null;
            }
            return action;
        }

        @Override
        public final Builder action(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder action(String... action) {
            action(Arrays.asList(action));
            return this;
        }

        public final void setAction(Collection<String> action) {
            this.action = ActionListCopier.copy(action);
        }

        public final Instant getAnalyzedAt() {
            return analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        public final Map<String, String> getCondition() {
            if (condition instanceof SdkAutoConstructMap) {
                return null;
            }
            return condition;
        }

        @Override
        public final Builder condition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
            return this;
        }

        public final void setCondition(Map<String, String> condition) {
            this.condition = ConditionKeyMapCopier.copy(condition);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getError() {
            return error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final Boolean getIsPublic() {
            return isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        public final Map<String, String> getPrincipal() {
            if (principal instanceof SdkAutoConstructMap) {
                return null;
            }
            return principal;
        }

        @Override
        public final Builder principal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
            return this;
        }

        public final void setPrincipal(Map<String, String> principal) {
            this.principal = PrincipalMapCopier.copy(principal);
        }

        public final String getResource() {
            return resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        public final String getResourceOwnerAccount() {
            return resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<FindingSource.Builder> getSources() {
            if (sources instanceof SdkAutoConstructList) {
                return null;
            }
            return sources != null ? sources.stream().map(FindingSource::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder sources(Collection<FindingSource> sources) {
            this.sources = FindingSourceListCopier.copy(sources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(FindingSource... sources) {
            sources(Arrays.asList(sources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sources(Consumer<FindingSource.Builder>... sources) {
            sources(Stream.of(sources).map(c -> FindingSource.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSources(Collection<FindingSource.BuilderImpl> sources) {
            this.sources = FindingSourceListCopier.copyFromBuilder(sources);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public Finding build() {
            return new Finding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
