/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains details about the analyzed resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzedResource implements SdkPojo, Serializable,
        ToCopyableBuilder<AnalyzedResource.Builder, AnalyzedResource> {
    private static final SdkField<List<String>> ACTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("actions")
            .getter(getter(AnalyzedResource::actions))
            .setter(setter(Builder::actions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> ANALYZED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("analyzedAt")
            .getter(getter(AnalyzedResource::analyzedAt))
            .setter(setter(Builder::analyzedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(AnalyzedResource::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(AnalyzedResource::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<Boolean> IS_PUBLIC_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isPublic").getter(getter(AnalyzedResource::isPublic)).setter(setter(Builder::isPublic))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isPublic").build()).build();

    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceArn").getter(getter(AnalyzedResource::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()).build();

    private static final SdkField<String> RESOURCE_OWNER_ACCOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceOwnerAccount").getter(getter(AnalyzedResource::resourceOwnerAccount))
            .setter(setter(Builder::resourceOwnerAccount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwnerAccount").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(AnalyzedResource::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<List<String>> SHARED_VIA_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("sharedVia")
            .getter(getter(AnalyzedResource::sharedVia))
            .setter(setter(Builder::sharedVia))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sharedVia").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(AnalyzedResource::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(AnalyzedResource::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIONS_FIELD,
            ANALYZED_AT_FIELD, CREATED_AT_FIELD, ERROR_FIELD, IS_PUBLIC_FIELD, RESOURCE_ARN_FIELD, RESOURCE_OWNER_ACCOUNT_FIELD,
            RESOURCE_TYPE_FIELD, SHARED_VIA_FIELD, STATUS_FIELD, UPDATED_AT_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> actions;

    private final Instant analyzedAt;

    private final Instant createdAt;

    private final String error;

    private final Boolean isPublic;

    private final String resourceArn;

    private final String resourceOwnerAccount;

    private final String resourceType;

    private final List<String> sharedVia;

    private final String status;

    private final Instant updatedAt;

    private AnalyzedResource(BuilderImpl builder) {
        this.actions = builder.actions;
        this.analyzedAt = builder.analyzedAt;
        this.createdAt = builder.createdAt;
        this.error = builder.error;
        this.isPublic = builder.isPublic;
        this.resourceArn = builder.resourceArn;
        this.resourceOwnerAccount = builder.resourceOwnerAccount;
        this.resourceType = builder.resourceType;
        this.sharedVia = builder.sharedVia;
        this.status = builder.status;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * Returns true if the Actions property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasActions() {
        return actions != null && !(actions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions that an external principal is granted permission to use by the policy that generated the finding.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasActions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The actions that an external principal is granted permission to use by the policy that generated the
     *         finding.
     */
    public final List<String> actions() {
        return actions;
    }

    /**
     * <p>
     * The time at which the resource was analyzed.
     * </p>
     * 
     * @return The time at which the resource was analyzed.
     */
    public final Instant analyzedAt() {
        return analyzedAt;
    }

    /**
     * <p>
     * The time at which the finding was created.
     * </p>
     * 
     * @return The time at which the finding was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * An error message.
     * </p>
     * 
     * @return An error message.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * Indicates whether the policy that generated the finding grants public access to the resource.
     * </p>
     * 
     * @return Indicates whether the policy that generated the finding grants public access to the resource.
     */
    public final Boolean isPublic() {
        return isPublic;
    }

    /**
     * <p>
     * The ARN of the resource that was analyzed.
     * </p>
     * 
     * @return The ARN of the resource that was analyzed.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The AWS account ID that owns the resource.
     * </p>
     * 
     * @return The AWS account ID that owns the resource.
     */
    public final String resourceOwnerAccount() {
        return resourceOwnerAccount;
    }

    /**
     * <p>
     * The type of the resource that was analyzed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that was analyzed.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of the resource that was analyzed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of the resource that was analyzed.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * Returns true if the SharedVia property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasSharedVia() {
        return sharedVia != null && !(sharedVia instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket findings.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSharedVia()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket
     *         findings.
     */
    public final List<String> sharedVia() {
        return sharedVia;
    }

    /**
     * <p>
     * The current status of the finding generated from the analyzed resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the finding generated from the analyzed resource.
     * @see FindingStatus
     */
    public final FindingStatus status() {
        return FindingStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the finding generated from the analyzed resource.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link FindingStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the finding generated from the analyzed resource.
     * @see FindingStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The time at which the finding was updated.
     * </p>
     * 
     * @return The time at which the finding was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasActions() ? actions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(analyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(isPublic());
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceOwnerAccount());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasSharedVia() ? sharedVia() : null);
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzedResource)) {
            return false;
        }
        AnalyzedResource other = (AnalyzedResource) obj;
        return hasActions() == other.hasActions() && Objects.equals(actions(), other.actions())
                && Objects.equals(analyzedAt(), other.analyzedAt()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(error(), other.error()) && Objects.equals(isPublic(), other.isPublic())
                && Objects.equals(resourceArn(), other.resourceArn())
                && Objects.equals(resourceOwnerAccount(), other.resourceOwnerAccount())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString()) && hasSharedVia() == other.hasSharedVia()
                && Objects.equals(sharedVia(), other.sharedVia()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnalyzedResource").add("Actions", hasActions() ? actions() : null)
                .add("AnalyzedAt", analyzedAt()).add("CreatedAt", createdAt()).add("Error", error()).add("IsPublic", isPublic())
                .add("ResourceArn", resourceArn()).add("ResourceOwnerAccount", resourceOwnerAccount())
                .add("ResourceType", resourceTypeAsString()).add("SharedVia", hasSharedVia() ? sharedVia() : null)
                .add("Status", statusAsString()).add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "actions":
            return Optional.ofNullable(clazz.cast(actions()));
        case "analyzedAt":
            return Optional.ofNullable(clazz.cast(analyzedAt()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "isPublic":
            return Optional.ofNullable(clazz.cast(isPublic()));
        case "resourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "resourceOwnerAccount":
            return Optional.ofNullable(clazz.cast(resourceOwnerAccount()));
        case "resourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "sharedVia":
            return Optional.ofNullable(clazz.cast(sharedVia()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzedResource, T> g) {
        return obj -> g.apply((AnalyzedResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyzedResource> {
        /**
         * <p>
         * The actions that an external principal is granted permission to use by the policy that generated the finding.
         * </p>
         * 
         * @param actions
         *        The actions that an external principal is granted permission to use by the policy that generated the
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(Collection<String> actions);

        /**
         * <p>
         * The actions that an external principal is granted permission to use by the policy that generated the finding.
         * </p>
         * 
         * @param actions
         *        The actions that an external principal is granted permission to use by the policy that generated the
         *        finding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actions(String... actions);

        /**
         * <p>
         * The time at which the resource was analyzed.
         * </p>
         * 
         * @param analyzedAt
         *        The time at which the resource was analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzedAt(Instant analyzedAt);

        /**
         * <p>
         * The time at which the finding was created.
         * </p>
         * 
         * @param createdAt
         *        The time at which the finding was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * An error message.
         * </p>
         * 
         * @param error
         *        An error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * Indicates whether the policy that generated the finding grants public access to the resource.
         * </p>
         * 
         * @param isPublic
         *        Indicates whether the policy that generated the finding grants public access to the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPublic(Boolean isPublic);

        /**
         * <p>
         * The ARN of the resource that was analyzed.
         * </p>
         * 
         * @param resourceArn
         *        The ARN of the resource that was analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The AWS account ID that owns the resource.
         * </p>
         * 
         * @param resourceOwnerAccount
         *        The AWS account ID that owns the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceOwnerAccount(String resourceOwnerAccount);

        /**
         * <p>
         * The type of the resource that was analyzed.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that was analyzed.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of the resource that was analyzed.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource that was analyzed.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket
         * findings.
         * </p>
         * 
         * @param sharedVia
         *        Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedVia(Collection<String> sharedVia);

        /**
         * <p>
         * Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket
         * findings.
         * </p>
         * 
         * @param sharedVia
         *        Indicates how the access that generated the finding is granted. This is populated for Amazon S3 bucket
         *        findings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sharedVia(String... sharedVia);

        /**
         * <p>
         * The current status of the finding generated from the analyzed resource.
         * </p>
         * 
         * @param status
         *        The current status of the finding generated from the analyzed resource.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the finding generated from the analyzed resource.
         * </p>
         * 
         * @param status
         *        The current status of the finding generated from the analyzed resource.
         * @see FindingStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FindingStatus
         */
        Builder status(FindingStatus status);

        /**
         * <p>
         * The time at which the finding was updated.
         * </p>
         * 
         * @param updatedAt
         *        The time at which the finding was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private List<String> actions = DefaultSdkAutoConstructList.getInstance();

        private Instant analyzedAt;

        private Instant createdAt;

        private String error;

        private Boolean isPublic;

        private String resourceArn;

        private String resourceOwnerAccount;

        private String resourceType;

        private List<String> sharedVia = DefaultSdkAutoConstructList.getInstance();

        private String status;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzedResource model) {
            actions(model.actions);
            analyzedAt(model.analyzedAt);
            createdAt(model.createdAt);
            error(model.error);
            isPublic(model.isPublic);
            resourceArn(model.resourceArn);
            resourceOwnerAccount(model.resourceOwnerAccount);
            resourceType(model.resourceType);
            sharedVia(model.sharedVia);
            status(model.status);
            updatedAt(model.updatedAt);
        }

        public final Collection<String> getActions() {
            if (actions instanceof SdkAutoConstructList) {
                return null;
            }
            return actions;
        }

        @Override
        public final Builder actions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actions(String... actions) {
            actions(Arrays.asList(actions));
            return this;
        }

        public final void setActions(Collection<String> actions) {
            this.actions = ActionListCopier.copy(actions);
        }

        public final Instant getAnalyzedAt() {
            return analyzedAt;
        }

        @Override
        public final Builder analyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
            return this;
        }

        public final void setAnalyzedAt(Instant analyzedAt) {
            this.analyzedAt = analyzedAt;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getError() {
            return error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final void setError(String error) {
            this.error = error;
        }

        public final Boolean getIsPublic() {
            return isPublic;
        }

        @Override
        public final Builder isPublic(Boolean isPublic) {
            this.isPublic = isPublic;
            return this;
        }

        public final void setIsPublic(Boolean isPublic) {
            this.isPublic = isPublic;
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        public final String getResourceOwnerAccount() {
            return resourceOwnerAccount;
        }

        @Override
        public final Builder resourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
            return this;
        }

        public final void setResourceOwnerAccount(String resourceOwnerAccount) {
            this.resourceOwnerAccount = resourceOwnerAccount;
        }

        public final String getResourceType() {
            return resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        public final Collection<String> getSharedVia() {
            if (sharedVia instanceof SdkAutoConstructList) {
                return null;
            }
            return sharedVia;
        }

        @Override
        public final Builder sharedVia(Collection<String> sharedVia) {
            this.sharedVia = SharedViaListCopier.copy(sharedVia);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sharedVia(String... sharedVia) {
            sharedVia(Arrays.asList(sharedVia));
            return this;
        }

        public final void setSharedVia(Collection<String> sharedVia) {
            this.sharedVia = SharedViaListCopier.copy(sharedVia);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(FindingStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public AnalyzedResource build() {
            return new AnalyzedResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
