/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum FindingStatus {
    ACTIVE("ACTIVE"),
    ARCHIVED("ARCHIVED"),
    RESOLVED("RESOLVED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private FindingStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FindingStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(FindingStatus.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FindingStatus> knownValues() {
        return Stream.of(FindingStatus.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

