/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.accessanalyzer.AccessAnalyzerClient;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerException;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.AccessDeniedException;
import software.amazon.awssdk.services.accessanalyzer.model.ConflictException;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.CreateArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.DeleteArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzedResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingRequest;
import software.amazon.awssdk.services.accessanalyzer.model.GetFindingResponse;
import software.amazon.awssdk.services.accessanalyzer.model.InternalServerException;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzedResourcesResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListAnalyzersResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListArchiveRulesResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ResourceNotFoundException;
import software.amazon.awssdk.services.accessanalyzer.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanRequest;
import software.amazon.awssdk.services.accessanalyzer.model.StartResourceScanResponse;
import software.amazon.awssdk.services.accessanalyzer.model.TagResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.TagResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ThrottlingException;
import software.amazon.awssdk.services.accessanalyzer.model.UntagResourceRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UntagResourceResponse;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateArchiveRuleResponse;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsRequest;
import software.amazon.awssdk.services.accessanalyzer.model.UpdateFindingsResponse;
import software.amazon.awssdk.services.accessanalyzer.model.ValidationException;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzedResourcesIterable;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListAnalyzersIterable;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListArchiveRulesIterable;
import software.amazon.awssdk.services.accessanalyzer.paginators.ListFindingsIterable;
import software.amazon.awssdk.services.accessanalyzer.transform.CreateAnalyzerRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.CreateArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.DeleteAnalyzerRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.DeleteArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetAnalyzedResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetAnalyzerRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.GetFindingRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListAnalyzedResourcesRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListAnalyzersRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListArchiveRulesRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListFindingsRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.StartResourceScanRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.UpdateArchiveRuleRequestMarshaller;
import software.amazon.awssdk.services.accessanalyzer.transform.UpdateFindingsRequestMarshaller;

@SdkInternalApi
final class DefaultAccessAnalyzerClient
implements AccessAnalyzerClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAccessAnalyzerClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "access-analyzer";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateAnalyzerResponse createAnalyzer(CreateAnalyzerRequest createAnalyzerRequest) throws ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateAnalyzerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateAnalyzer");
            CreateAnalyzerResponse createAnalyzerResponse = (CreateAnalyzerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateAnalyzer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createAnalyzerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateAnalyzerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createAnalyzerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, createAnalyzerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateArchiveRuleResponse createArchiveRule(CreateArchiveRuleRequest createArchiveRuleRequest) throws ResourceNotFoundException, ConflictException, ValidationException, InternalServerException, ServiceQuotaExceededException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateArchiveRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateArchiveRule");
            CreateArchiveRuleResponse createArchiveRuleResponse = (CreateArchiveRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateArchiveRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createArchiveRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new CreateArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createArchiveRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, createArchiveRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteAnalyzerResponse deleteAnalyzer(DeleteAnalyzerRequest deleteAnalyzerRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteAnalyzerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnalyzer");
            DeleteAnalyzerResponse deleteAnalyzerResponse = (DeleteAnalyzerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnalyzer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteAnalyzerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteAnalyzerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteAnalyzerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, deleteAnalyzerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteArchiveRuleResponse deleteArchiveRule(DeleteArchiveRuleRequest deleteArchiveRuleRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteArchiveRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteArchiveRule");
            DeleteArchiveRuleResponse deleteArchiveRuleResponse = (DeleteArchiveRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteArchiveRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteArchiveRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new DeleteArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteArchiveRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, deleteArchiveRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnalyzedResourceResponse getAnalyzedResource(GetAnalyzedResourceRequest getAnalyzedResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnalyzedResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnalyzedResource");
            GetAnalyzedResourceResponse getAnalyzedResourceResponse = (GetAnalyzedResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnalyzedResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnalyzedResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAnalyzedResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnalyzedResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, getAnalyzedResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAnalyzerResponse getAnalyzer(GetAnalyzerRequest getAnalyzerRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetAnalyzerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetAnalyzer");
            GetAnalyzerResponse getAnalyzerResponse = (GetAnalyzerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetAnalyzer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getAnalyzerRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetAnalyzerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getAnalyzerResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, getAnalyzerRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetArchiveRuleResponse getArchiveRule(GetArchiveRuleRequest getArchiveRuleRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetArchiveRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetArchiveRule");
            GetArchiveRuleResponse getArchiveRuleResponse = (GetArchiveRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetArchiveRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getArchiveRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getArchiveRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, getArchiveRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetFindingResponse getFinding(GetFindingRequest getFindingRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetFindingResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetFinding");
            GetFindingResponse getFindingResponse = (GetFindingResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetFinding").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getFindingRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new GetFindingRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getFindingResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, getFindingRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnalyzedResourcesResponse listAnalyzedResources(ListAnalyzedResourcesRequest listAnalyzedResourcesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnalyzedResourcesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnalyzedResources");
            ListAnalyzedResourcesResponse listAnalyzedResourcesResponse = (ListAnalyzedResourcesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnalyzedResources").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnalyzedResourcesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAnalyzedResourcesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnalyzedResourcesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, listAnalyzedResourcesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListAnalyzedResourcesIterable listAnalyzedResourcesPaginator(ListAnalyzedResourcesRequest listAnalyzedResourcesRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        return new ListAnalyzedResourcesIterable(this, this.applyPaginatorUserAgent(listAnalyzedResourcesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListAnalyzersResponse listAnalyzers(ListAnalyzersRequest listAnalyzersRequest) throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListAnalyzersResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListAnalyzers");
            ListAnalyzersResponse listAnalyzersResponse = (ListAnalyzersResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListAnalyzers").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listAnalyzersRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListAnalyzersRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listAnalyzersResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, listAnalyzersRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListAnalyzersIterable listAnalyzersPaginator(ListAnalyzersRequest listAnalyzersRequest) throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        return new ListAnalyzersIterable(this, this.applyPaginatorUserAgent(listAnalyzersRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListArchiveRulesResponse listArchiveRules(ListArchiveRulesRequest listArchiveRulesRequest) throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListArchiveRulesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListArchiveRules");
            ListArchiveRulesResponse listArchiveRulesResponse = (ListArchiveRulesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListArchiveRules").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listArchiveRulesRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListArchiveRulesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listArchiveRulesResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, listArchiveRulesRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListArchiveRulesIterable listArchiveRulesPaginator(ListArchiveRulesRequest listArchiveRulesRequest) throws ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        return new ListArchiveRulesIterable(this, this.applyPaginatorUserAgent(listArchiveRulesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListFindingsResponse listFindings(ListFindingsRequest listFindingsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListFindings");
            ListFindingsResponse listFindingsResponse = (ListFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listFindingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listFindingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, listFindingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public ListFindingsIterable listFindingsPaginator(ListFindingsRequest listFindingsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        return new ListFindingsIterable(this, this.applyPaginatorUserAgent(listFindingsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartResourceScanResponse startResourceScan(StartResourceScanRequest startResourceScanRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartResourceScanResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartResourceScan");
            StartResourceScanResponse startResourceScanResponse = (StartResourceScanResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartResourceScan").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startResourceScanRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new StartResourceScanRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startResourceScanResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, startResourceScanRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateArchiveRuleResponse updateArchiveRule(UpdateArchiveRuleRequest updateArchiveRuleRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateArchiveRuleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateArchiveRule");
            UpdateArchiveRuleResponse updateArchiveRuleResponse = (UpdateArchiveRuleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateArchiveRule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateArchiveRuleRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateArchiveRuleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateArchiveRuleResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, updateArchiveRuleRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateFindingsResponse updateFindings(UpdateFindingsRequest updateFindingsRequest) throws ResourceNotFoundException, ValidationException, InternalServerException, ThrottlingException, AccessDeniedException, AwsServiceException, SdkClientException, AccessAnalyzerException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateFindingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"AccessAnalyzer");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateFindings");
            UpdateFindingsResponse updateFindingsResponse = (UpdateFindingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateFindings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateFindingsRequest).withMetricCollector(apiCallMetricCollector).withMarshaller((Marshaller)new UpdateFindingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateFindingsResponse;
        }
        finally {
            List<MetricPublisher> metricPublishers = DefaultAccessAnalyzerClient.resolveMetricPublishers(this.clientConfiguration, updateFindingsRequest.overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(AccessAnalyzerException::builder).protocol(AwsJsonProtocol.REST_JSON).protocolVersion("1.1").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(403)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(409)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").exceptionBuilderSupplier(ServiceQuotaExceededException::builder).httpStatusCode(Integer.valueOf(402)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends AccessAnalyzerRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.13.59").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AccessAnalyzerRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }
}

