/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The response to the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListArchiveRulesResponse extends AccessAnalyzerResponse implements
        ToCopyableBuilder<ListArchiveRulesResponse.Builder, ListArchiveRulesResponse> {
    private static final SdkField<List<ArchiveRuleSummary>> ARCHIVE_RULES_FIELD = SdkField
            .<List<ArchiveRuleSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListArchiveRulesResponse::archiveRules))
            .setter(setter(Builder::archiveRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("archiveRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ArchiveRuleSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ArchiveRuleSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListArchiveRulesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_RULES_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ArchiveRuleSummary> archiveRules;

    private final String nextToken;

    private ListArchiveRulesResponse(BuilderImpl builder) {
        super(builder);
        this.archiveRules = builder.archiveRules;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the ArchiveRules property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasArchiveRules() {
        return archiveRules != null && !(archiveRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of archive rules created for the specified analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasArchiveRules()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of archive rules created for the specified analyzer.
     */
    public List<ArchiveRuleSummary> archiveRules() {
        return archiveRules;
    }

    /**
     * <p>
     * A token used for pagination of results returned.
     * </p>
     * 
     * @return A token used for pagination of results returned.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveRules());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArchiveRulesResponse)) {
            return false;
        }
        ListArchiveRulesResponse other = (ListArchiveRulesResponse) obj;
        return Objects.equals(archiveRules(), other.archiveRules()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListArchiveRulesResponse").add("ArchiveRules", archiveRules()).add("NextToken", nextToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "archiveRules":
            return Optional.ofNullable(clazz.cast(archiveRules()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListArchiveRulesResponse, T> g) {
        return obj -> g.apply((ListArchiveRulesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListArchiveRulesResponse> {
        /**
         * <p>
         * A list of archive rules created for the specified analyzer.
         * </p>
         * 
         * @param archiveRules
         *        A list of archive rules created for the specified analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(Collection<ArchiveRuleSummary> archiveRules);

        /**
         * <p>
         * A list of archive rules created for the specified analyzer.
         * </p>
         * 
         * @param archiveRules
         *        A list of archive rules created for the specified analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveRules(ArchiveRuleSummary... archiveRules);

        /**
         * <p>
         * A list of archive rules created for the specified analyzer.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ArchiveRuleSummary>.Builder} avoiding the
         * need to create one manually via {@link List<ArchiveRuleSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ArchiveRuleSummary>.Builder#build()} is called immediately
         * and its result is passed to {@link #archiveRules(List<ArchiveRuleSummary>)}.
         * 
         * @param archiveRules
         *        a consumer that will call methods on {@link List<ArchiveRuleSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #archiveRules(List<ArchiveRuleSummary>)
         */
        Builder archiveRules(Consumer<ArchiveRuleSummary.Builder>... archiveRules);

        /**
         * <p>
         * A token used for pagination of results returned.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination of results returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AccessAnalyzerResponse.BuilderImpl implements Builder {
        private List<ArchiveRuleSummary> archiveRules = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArchiveRulesResponse model) {
            super(model);
            archiveRules(model.archiveRules);
            nextToken(model.nextToken);
        }

        public final Collection<ArchiveRuleSummary.Builder> getArchiveRules() {
            return archiveRules != null ? archiveRules.stream().map(ArchiveRuleSummary::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder archiveRules(Collection<ArchiveRuleSummary> archiveRules) {
            this.archiveRules = ArchiveRulesListCopier.copy(archiveRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(ArchiveRuleSummary... archiveRules) {
            archiveRules(Arrays.asList(archiveRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder archiveRules(Consumer<ArchiveRuleSummary.Builder>... archiveRules) {
            archiveRules(Stream.of(archiveRules).map(c -> ArchiveRuleSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setArchiveRules(Collection<ArchiveRuleSummary.BuilderImpl> archiveRules) {
            this.archiveRules = ArchiveRulesListCopier.copyFromBuilder(archiveRules);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListArchiveRulesResponse build() {
            return new ListArchiveRulesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
