/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Deletes an analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteAnalyzerRequest extends AccessAnalyzerRequest implements
        ToCopyableBuilder<DeleteAnalyzerRequest.Builder, DeleteAnalyzerRequest> {
    private static final SdkField<String> ANALYZER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteAnalyzerRequest::analyzerName)).setter(setter(Builder::analyzerName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("analyzerName").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(DeleteAnalyzerRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZER_NAME_FIELD,
            CLIENT_TOKEN_FIELD));

    private final String analyzerName;

    private final String clientToken;

    private DeleteAnalyzerRequest(BuilderImpl builder) {
        super(builder);
        this.analyzerName = builder.analyzerName;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The name of the analyzer to delete.
     * </p>
     * 
     * @return The name of the analyzer to delete.
     */
    public String analyzerName() {
        return analyzerName;
    }

    /**
     * <p>
     * A client token.
     * </p>
     * 
     * @return A client token.
     */
    public String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analyzerName());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteAnalyzerRequest)) {
            return false;
        }
        DeleteAnalyzerRequest other = (DeleteAnalyzerRequest) obj;
        return Objects.equals(analyzerName(), other.analyzerName()) && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DeleteAnalyzerRequest").add("AnalyzerName", analyzerName()).add("ClientToken", clientToken())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "analyzerName":
            return Optional.ofNullable(clazz.cast(analyzerName()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteAnalyzerRequest, T> g) {
        return obj -> g.apply((DeleteAnalyzerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AccessAnalyzerRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteAnalyzerRequest> {
        /**
         * <p>
         * The name of the analyzer to delete.
         * </p>
         * 
         * @param analyzerName
         *        The name of the analyzer to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analyzerName(String analyzerName);

        /**
         * <p>
         * A client token.
         * </p>
         * 
         * @param clientToken
         *        A client token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AccessAnalyzerRequest.BuilderImpl implements Builder {
        private String analyzerName;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteAnalyzerRequest model) {
            super(model);
            analyzerName(model.analyzerName);
            clientToken(model.clientToken);
        }

        public final String getAnalyzerName() {
            return analyzerName;
        }

        @Override
        public final Builder analyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
            return this;
        }

        public final void setAnalyzerName(String analyzerName) {
            this.analyzerName = analyzerName;
        }

        public final String getClientToken() {
            return clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteAnalyzerRequest build() {
            return new DeleteAnalyzerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
