/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.accessanalyzer.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the analyzer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalyzerSummary implements SdkPojo, Serializable, ToCopyableBuilder<AnalyzerSummary.Builder, AnalyzerSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyzerSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AnalyzerSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LAST_RESOURCE_ANALYZED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyzerSummary::lastResourceAnalyzed)).setter(setter(Builder::lastResourceAnalyzed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastResourceAnalyzed").build())
            .build();

    private static final SdkField<Instant> LAST_RESOURCE_ANALYZED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(AnalyzerSummary::lastResourceAnalyzedAt))
            .setter(setter(Builder::lastResourceAnalyzedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastResourceAnalyzedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyzerSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(AnalyzerSummary::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalyzerSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_AT_FIELD,
            LAST_RESOURCE_ANALYZED_FIELD, LAST_RESOURCE_ANALYZED_AT_FIELD, NAME_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Instant createdAt;

    private final String lastResourceAnalyzed;

    private final Instant lastResourceAnalyzedAt;

    private final String name;

    private final Map<String, String> tags;

    private final String type;

    private AnalyzerSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdAt = builder.createdAt;
        this.lastResourceAnalyzed = builder.lastResourceAnalyzed;
        this.lastResourceAnalyzedAt = builder.lastResourceAnalyzedAt;
        this.name = builder.name;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * The ARN of the analyzer.
     * </p>
     * 
     * @return The ARN of the analyzer.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * A timestamp for the time at which the analyzer was created.
     * </p>
     * 
     * @return A timestamp for the time at which the analyzer was created.
     */
    public Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The resource that was most recently analyzed by the analyzer.
     * </p>
     * 
     * @return The resource that was most recently analyzed by the analyzer.
     */
    public String lastResourceAnalyzed() {
        return lastResourceAnalyzed;
    }

    /**
     * <p>
     * The time at which the most recently analyzed resource was analyzed.
     * </p>
     * 
     * @return The time at which the most recently analyzed resource was analyzed.
     */
    public Instant lastResourceAnalyzedAt() {
        return lastResourceAnalyzedAt;
    }

    /**
     * <p>
     * The name of the analyzer.
     * </p>
     * 
     * @return The name of the analyzer.
     */
    public String name() {
        return name;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags added to the analyzer.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The tags added to the analyzer.
     */
    public Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
     * @see Type
     */
    public Type type() {
        return Type.fromValue(type);
    }

    /**
     * <p>
     * The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link Type#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
     * @see Type
     */
    public String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastResourceAnalyzed());
        hashCode = 31 * hashCode + Objects.hashCode(lastResourceAnalyzedAt());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalyzerSummary)) {
            return false;
        }
        AnalyzerSummary other = (AnalyzerSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(lastResourceAnalyzed(), other.lastResourceAnalyzed())
                && Objects.equals(lastResourceAnalyzedAt(), other.lastResourceAnalyzedAt())
                && Objects.equals(name(), other.name()) && Objects.equals(tags(), other.tags())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AnalyzerSummary").add("Arn", arn()).add("CreatedAt", createdAt())
                .add("LastResourceAnalyzed", lastResourceAnalyzed()).add("LastResourceAnalyzedAt", lastResourceAnalyzedAt())
                .add("Name", name()).add("Tags", tags()).add("Type", typeAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "lastResourceAnalyzed":
            return Optional.ofNullable(clazz.cast(lastResourceAnalyzed()));
        case "lastResourceAnalyzedAt":
            return Optional.ofNullable(clazz.cast(lastResourceAnalyzedAt()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalyzerSummary, T> g) {
        return obj -> g.apply((AnalyzerSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalyzerSummary> {
        /**
         * <p>
         * The ARN of the analyzer.
         * </p>
         * 
         * @param arn
         *        The ARN of the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A timestamp for the time at which the analyzer was created.
         * </p>
         * 
         * @param createdAt
         *        A timestamp for the time at which the analyzer was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The resource that was most recently analyzed by the analyzer.
         * </p>
         * 
         * @param lastResourceAnalyzed
         *        The resource that was most recently analyzed by the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastResourceAnalyzed(String lastResourceAnalyzed);

        /**
         * <p>
         * The time at which the most recently analyzed resource was analyzed.
         * </p>
         * 
         * @param lastResourceAnalyzedAt
         *        The time at which the most recently analyzed resource was analyzed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastResourceAnalyzedAt(Instant lastResourceAnalyzedAt);

        /**
         * <p>
         * The name of the analyzer.
         * </p>
         * 
         * @param name
         *        The name of the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The tags added to the analyzer.
         * </p>
         * 
         * @param tags
         *        The tags added to the analyzer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
         * </p>
         * 
         * @param type
         *        The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(String type);

        /**
         * <p>
         * The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
         * </p>
         * 
         * @param type
         *        The type of analyzer, which corresponds to the zone of trust chosen for the analyzer.
         * @see Type
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Type
         */
        Builder type(Type type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Instant createdAt;

        private String lastResourceAnalyzed;

        private Instant lastResourceAnalyzedAt;

        private String name;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalyzerSummary model) {
            arn(model.arn);
            createdAt(model.createdAt);
            lastResourceAnalyzed(model.lastResourceAnalyzed);
            lastResourceAnalyzedAt(model.lastResourceAnalyzedAt);
            name(model.name);
            tags(model.tags);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        public final String getLastResourceAnalyzed() {
            return lastResourceAnalyzed;
        }

        @Override
        public final Builder lastResourceAnalyzed(String lastResourceAnalyzed) {
            this.lastResourceAnalyzed = lastResourceAnalyzed;
            return this;
        }

        public final void setLastResourceAnalyzed(String lastResourceAnalyzed) {
            this.lastResourceAnalyzed = lastResourceAnalyzed;
        }

        public final Instant getLastResourceAnalyzedAt() {
            return lastResourceAnalyzedAt;
        }

        @Override
        public final Builder lastResourceAnalyzedAt(Instant lastResourceAnalyzedAt) {
            this.lastResourceAnalyzedAt = lastResourceAnalyzedAt;
            return this;
        }

        public final void setLastResourceAnalyzedAt(Instant lastResourceAnalyzedAt) {
            this.lastResourceAnalyzedAt = lastResourceAnalyzedAt;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final String getTypeAsString() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(Type type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public AnalyzerSummary build() {
            return new AnalyzerSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
