/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.accessanalyzer.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.accessanalyzer.model.AccessAnalyzerResponse;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzerSummary;
import software.amazon.awssdk.services.accessanalyzer.model.AnalyzersListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAnalyzersResponse
extends AccessAnalyzerResponse
implements ToCopyableBuilder<Builder, ListAnalyzersResponse> {
    private static final SdkField<List<AnalyzerSummary>> ANALYZERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ListAnalyzersResponse.getter(ListAnalyzersResponse::analyzers)).setter(ListAnalyzersResponse.setter(Builder::analyzers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("analyzers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AnalyzerSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ListAnalyzersResponse.getter(ListAnalyzersResponse::nextToken)).setter(ListAnalyzersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYZERS_FIELD, NEXT_TOKEN_FIELD));
    private final List<AnalyzerSummary> analyzers;
    private final String nextToken;

    private ListAnalyzersResponse(BuilderImpl builder) {
        super(builder);
        this.analyzers = builder.analyzers;
        this.nextToken = builder.nextToken;
    }

    public List<AnalyzerSummary> analyzers() {
        return this.analyzers;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.analyzers());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAnalyzersResponse)) {
            return false;
        }
        ListAnalyzersResponse other = (ListAnalyzersResponse)((Object)obj);
        return Objects.equals(this.analyzers(), other.analyzers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListAnalyzersResponse").add("Analyzers", this.analyzers()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "analyzers": {
                return Optional.ofNullable(clazz.cast(this.analyzers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListAnalyzersResponse, T> g) {
        return obj -> g.apply((ListAnalyzersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AccessAnalyzerResponse.BuilderImpl
    implements Builder {
        private List<AnalyzerSummary> analyzers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAnalyzersResponse model) {
            super(model);
            this.analyzers(model.analyzers);
            this.nextToken(model.nextToken);
        }

        public final Collection<AnalyzerSummary.Builder> getAnalyzers() {
            return this.analyzers != null ? (Collection)this.analyzers.stream().map(AnalyzerSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder analyzers(Collection<AnalyzerSummary> analyzers) {
            this.analyzers = AnalyzersListCopier.copy(analyzers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzers(AnalyzerSummary ... analyzers) {
            this.analyzers(Arrays.asList(analyzers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analyzers(Consumer<AnalyzerSummary.Builder> ... analyzers) {
            this.analyzers(Stream.of(analyzers).map(c -> (AnalyzerSummary)((AnalyzerSummary.Builder)AnalyzerSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAnalyzers(Collection<AnalyzerSummary.BuilderImpl> analyzers) {
            this.analyzers = AnalyzersListCopier.copyFromBuilder(analyzers);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListAnalyzersResponse build() {
            return new ListAnalyzersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AccessAnalyzerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAnalyzersResponse> {
        public Builder analyzers(Collection<AnalyzerSummary> var1);

        public Builder analyzers(AnalyzerSummary ... var1);

        public Builder analyzers(Consumer<AnalyzerSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

