package software.amazon.awscdk.services.stepfunctions;

/**
 * Metrics on the rate limiting performed on state machine execution.
 * <p>
 * These rate limits are shared across all state machines.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.492Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.StateTransitionMetric")
public class StateTransitionMetric extends software.amazon.jsii.JsiiObject {

    protected StateTransitionMetric(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StateTransitionMetric(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StateTransitionMetric() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Return the given named metric for the service's state transition metrics.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required"), props });
    }

    /**
     * Return the given named metric for the service's state transition metrics.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param metricName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metric(final @org.jetbrains.annotations.NotNull java.lang.String metricName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metric", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { java.util.Objects.requireNonNull(metricName, "metricName is required") });
    }

    /**
     * Metric for the number of available state transitions per second.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedCapacity(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricConsumedCapacity", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of available state transitions per second.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricConsumedCapacity() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricConsumedCapacity", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of available state transitions.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProvisionedBucketSize(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricProvisionedBucketSize", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of available state transitions.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProvisionedBucketSize() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricProvisionedBucketSize", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the provisioned steady-state execution rate.
     * <p>
     * Default: average over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProvisionedRefillRate(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricProvisionedRefillRate", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the provisioned steady-state execution rate.
     * <p>
     * Default: average over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricProvisionedRefillRate() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricProvisionedRefillRate", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }

    /**
     * Metric for the number of throttled state transitions.
     * <p>
     * Default: sum over 5 minutes
     * <p>
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottledEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudwatch.MetricOptions props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricThrottledEvents", software.amazon.awscdk.services.cloudwatch.Metric.class, new Object[] { props });
    }

    /**
     * Metric for the number of throttled state transitions.
     * <p>
     * Default: sum over 5 minutes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.Metric metricThrottledEvents() {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.StateTransitionMetric.class, "metricThrottledEvents", software.amazon.awscdk.services.cloudwatch.Metric.class);
    }
}
