package software.amazon.awscdk.services.stepfunctions;

/**
 * Options for creating a single state.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.488Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.SingleStateOptions")
@software.amazon.jsii.Jsii.Proxy(SingleStateOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SingleStateOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.ParallelProps {

    /**
     * String to prefix all stateIds in the state machine with.
     * <p>
     * Default: stateId
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrefixStates() {
        return null;
    }

    /**
     * ID of newly created containing state.
     * <p>
     * Default: Construct ID of the StateMachineFragment
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getStateId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SingleStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SingleStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SingleStateOptions> {
        private java.lang.String prefixStates;
        private java.lang.String stateId;
        private java.lang.String comment;
        private java.lang.String inputPath;
        private java.lang.String outputPath;
        private java.lang.String resultPath;

        /**
         * Sets the value of {@link SingleStateOptions#getPrefixStates}
         * @param prefixStates String to prefix all stateIds in the state machine with.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder prefixStates(java.lang.String prefixStates) {
            this.prefixStates = prefixStates;
            return this;
        }

        /**
         * Sets the value of {@link SingleStateOptions#getStateId}
         * @param stateId ID of newly created containing state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateId(java.lang.String stateId) {
            this.stateId = stateId;
            return this;
        }

        /**
         * Sets the value of {@link SingleStateOptions#getComment}
         * @param comment An optional description for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link SingleStateOptions#getInputPath}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state.
         *                  May also be the special value JsonPath.DISCARD, which will cause the effective
         *                  input to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(java.lang.String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        /**
         * Sets the value of {@link SingleStateOptions#getOutputPath}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state.
         *                   May also be the special value JsonPath.DISCARD, which will cause the effective
         *                   output to be the empty object {}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(java.lang.String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        /**
         * Sets the value of {@link SingleStateOptions#getResultPath}
         * @param resultPath JSONPath expression to indicate where to inject the state's output.
         *                   May also be the special value JsonPath.DISCARD, which will cause the state's
         *                   input to become its output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(java.lang.String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SingleStateOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SingleStateOptions build() {
            return new Jsii$Proxy(prefixStates, stateId, comment, inputPath, outputPath, resultPath);
        }
    }

    /**
     * An implementation for {@link SingleStateOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SingleStateOptions {
        private final java.lang.String prefixStates;
        private final java.lang.String stateId;
        private final java.lang.String comment;
        private final java.lang.String inputPath;
        private final java.lang.String outputPath;
        private final java.lang.String resultPath;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.prefixStates = this.jsiiGet("prefixStates", java.lang.String.class);
            this.stateId = this.jsiiGet("stateId", java.lang.String.class);
            this.comment = this.jsiiGet("comment", java.lang.String.class);
            this.inputPath = this.jsiiGet("inputPath", java.lang.String.class);
            this.outputPath = this.jsiiGet("outputPath", java.lang.String.class);
            this.resultPath = this.jsiiGet("resultPath", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String prefixStates, final java.lang.String stateId, final java.lang.String comment, final java.lang.String inputPath, final java.lang.String outputPath, final java.lang.String resultPath) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.prefixStates = prefixStates;
            this.stateId = stateId;
            this.comment = comment;
            this.inputPath = inputPath;
            this.outputPath = outputPath;
            this.resultPath = resultPath;
        }

        @Override
        public java.lang.String getPrefixStates() {
            return this.prefixStates;
        }

        @Override
        public java.lang.String getStateId() {
            return this.stateId;
        }

        @Override
        public java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public java.lang.String getInputPath() {
            return this.inputPath;
        }

        @Override
        public java.lang.String getOutputPath() {
            return this.outputPath;
        }

        @Override
        public java.lang.String getResultPath() {
            return this.resultPath;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getPrefixStates() != null) {
                data.set("prefixStates", om.valueToTree(this.getPrefixStates()));
            }
            if (this.getStateId() != null) {
                data.set("stateId", om.valueToTree(this.getStateId()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getInputPath() != null) {
                data.set("inputPath", om.valueToTree(this.getInputPath()));
            }
            if (this.getOutputPath() != null) {
                data.set("outputPath", om.valueToTree(this.getOutputPath()));
            }
            if (this.getResultPath() != null) {
                data.set("resultPath", om.valueToTree(this.getResultPath()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.SingleStateOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SingleStateOptions.Jsii$Proxy that = (SingleStateOptions.Jsii$Proxy) o;

            if (this.prefixStates != null ? !this.prefixStates.equals(that.prefixStates) : that.prefixStates != null) return false;
            if (this.stateId != null ? !this.stateId.equals(that.stateId) : that.stateId != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.inputPath != null ? !this.inputPath.equals(that.inputPath) : that.inputPath != null) return false;
            if (this.outputPath != null ? !this.outputPath.equals(that.outputPath) : that.outputPath != null) return false;
            return this.resultPath != null ? this.resultPath.equals(that.resultPath) : that.resultPath == null;
        }

        @Override
        public int hashCode() {
            int result = this.prefixStates != null ? this.prefixStates.hashCode() : 0;
            result = 31 * result + (this.stateId != null ? this.stateId.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.inputPath != null ? this.inputPath.hashCode() : 0);
            result = 31 * result + (this.outputPath != null ? this.outputPath.hashCode() : 0);
            result = 31 * result + (this.resultPath != null ? this.resultPath.hashCode() : 0);
            return result;
        }
    }
}
