package software.amazon.awscdk.services.stepfunctions;

/**
 * A collection of states to chain onto.
 * <p>
 * A Chain has a start and zero or more chainable ends. If there are
 * zero ends, calling next() on the Chain will fail.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:13.481Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.Chain")
public class Chain extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.stepfunctions.IChainable {

    protected Chain(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Chain(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Make a Chain with specific start and end states, and a last-added Chainable.
     * <p>
     * @param startState This parameter is required.
     * @param endStates This parameter is required.
     * @param lastAdded This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain custom(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State startState, final @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> endStates, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable lastAdded) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "custom", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(startState, "startState is required"), java.util.Objects.requireNonNull(endStates, "endStates is required"), java.util.Objects.requireNonNull(lastAdded, "lastAdded is required") });
    }

    /**
     * Make a Chain with the start from one chain and the ends from another.
     * <p>
     * @param start This parameter is required.
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain sequence(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable start, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "sequence", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(start, "start is required"), java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Begin a new Chain from one chainable.
     * <p>
     * @param state This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain start(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable state) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.Chain.class, "start", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(state, "state is required") });
    }

    /**
     * Continue normal execution with the given state.
     * <p>
     * @param next This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Chain next(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.IChainable next) {
        return this.jsiiCall("next", software.amazon.awscdk.services.stepfunctions.Chain.class, new Object[] { java.util.Objects.requireNonNull(next, "next is required") });
    }

    /**
     * Return a single state that encompasses all states in the chain.
     * <p>
     * This can be used to add error handling to a sequence of states.
     * <p>
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     * <p>
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.ParallelProps props) {
        return this.jsiiCall("toSingleState", software.amazon.awscdk.services.stepfunctions.Parallel.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Return a single state that encompasses all states in the chain.
     * <p>
     * This can be used to add error handling to a sequence of states.
     * <p>
     * Be aware that this changes the result of the inner state machine
     * to be an array with the result of the state machine in it. Adjust
     * your paths accordingly. For example, change 'outputPath' to
     * '$[0]'.
     * <p>
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.Parallel toSingleState(final @org.jetbrains.annotations.NotNull java.lang.String id) {
        return this.jsiiCall("toSingleState", software.amazon.awscdk.services.stepfunctions.Parallel.class, new Object[] { java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The chainable end state(s) of this chain.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.stepfunctions.INextable> getEndStates() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("endStates", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.INextable.class))));
    }

    /**
     * Identify this Chain.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getId() {
        return this.jsiiGet("id", java.lang.String.class);
    }

    /**
     * The start state of this chain.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.State getStartState() {
        return this.jsiiGet("startState", software.amazon.awscdk.services.stepfunctions.State.class);
    }
}
