/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.cloudwatch.Metric;
import software.amazon.awscdk.services.cloudwatch.MetricOptions;
import software.amazon.awscdk.services.iam.Grant;
import software.amazon.awscdk.services.iam.IGrantable;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.iam.PolicyStatement;
import software.amazon.awscdk.services.stepfunctions.;
import software.amazon.awscdk.services.stepfunctions.IChainable;
import software.amazon.awscdk.services.stepfunctions.IStateMachine;
import software.amazon.awscdk.services.stepfunctions.LogOptions;
import software.amazon.awscdk.services.stepfunctions.StateMachineProps;
import software.amazon.awscdk.services.stepfunctions.StateMachineType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-stepfunctions.StateMachine")
public class StateMachine
extends Resource
implements IStateMachine {
    protected StateMachine(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected StateMachine(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public StateMachine(@NotNull Construct scope, @NotNull String id, @NotNull StateMachineProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IStateMachine fromStateMachineArn(@NotNull Construct scope, @NotNull String id, @NotNull String stateMachineArn) {
        return (IStateMachine)JsiiObject.jsiiStaticCall(StateMachine.class, (String)"fromStateMachineArn", IStateMachine.class, (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(stateMachineArn, "stateMachineArn is required")});
    }

    public void addToRolePolicy(@NotNull PolicyStatement statement) {
        this.jsiiCall("addToRolePolicy", NativeType.VOID, new Object[]{Objects.requireNonNull(statement, "statement is required")});
    }

    @Override
    @NotNull
    public Grant grantStartExecution(@NotNull IGrantable identity) {
        return (Grant)this.jsiiCall("grantStartExecution", Grant.class, new Object[]{Objects.requireNonNull(identity, "identity is required")});
    }

    @NotNull
    public Metric metric(@NotNull String metricName, @Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required"), props});
    }

    @NotNull
    public Metric metric(@NotNull String metricName) {
        return (Metric)this.jsiiCall("metric", Metric.class, new Object[]{Objects.requireNonNull(metricName, "metricName is required")});
    }

    @NotNull
    public Metric metricAborted(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricAborted", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricAborted() {
        return (Metric)this.jsiiCall("metricAborted", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricFailed(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricFailed", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricFailed() {
        return (Metric)this.jsiiCall("metricFailed", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricStarted(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricStarted", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricStarted() {
        return (Metric)this.jsiiCall("metricStarted", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricSucceeded(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricSucceeded", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricSucceeded() {
        return (Metric)this.jsiiCall("metricSucceeded", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricThrottled(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricThrottled", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricThrottled() {
        return (Metric)this.jsiiCall("metricThrottled", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricTime(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricTime", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricTime() {
        return (Metric)this.jsiiCall("metricTime", Metric.class, new Object[0]);
    }

    @NotNull
    public Metric metricTimedOut(@Nullable MetricOptions props) {
        return (Metric)this.jsiiCall("metricTimedOut", Metric.class, new Object[]{props});
    }

    @NotNull
    public Metric metricTimedOut() {
        return (Metric)this.jsiiCall("metricTimedOut", Metric.class, new Object[0]);
    }

    @NotNull
    public IRole getRole() {
        return (IRole)this.jsiiGet("role", IRole.class);
    }

    @Override
    @NotNull
    public String getStateMachineArn() {
        return (String)this.jsiiGet("stateMachineArn", String.class);
    }

    @NotNull
    public String getStateMachineName() {
        return (String)this.jsiiGet("stateMachineName", String.class);
    }

    @NotNull
    public StateMachineType getStateMachineType() {
        return (StateMachineType)((Object)this.jsiiGet("stateMachineType", StateMachineType.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<StateMachine> {
        private final Construct scope;
        private final String id;
        private final StateMachineProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new StateMachineProps.Builder();
        }

        public Builder definition(IChainable definition) {
            this.props.definition(definition);
            return this;
        }

        public Builder logs(LogOptions logs) {
            this.props.logs(logs);
            return this;
        }

        public Builder role(IRole role) {
            this.props.role(role);
            return this;
        }

        public Builder stateMachineName(String stateMachineName) {
            this.props.stateMachineName(stateMachineName);
            return this;
        }

        public Builder stateMachineType(StateMachineType stateMachineType) {
            this.props.stateMachineType(stateMachineType);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        public StateMachine build() {
            return new StateMachine(this.scope, this.id, this.props.build());
        }
    }
}

