package software.amazon.awscdk.services.stepfunctions;

/**
 * A CloudFormation `AWS::StepFunctions::StateMachine`.
 * <p>
 * Provisions a state machine. A state machine consists of a collection of states that can do work ( <code>Task</code> states), determine to which states to transition next ( <code>Choice</code> states), stop an execution with an error ( <code>Fail</code> states), and so on. State machines are specified using a JSON-based, structured language.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.stepfunctions.*;
 * Object definition;
 * Object definitionSubstitutions;
 * CfnStateMachine cfnStateMachine = CfnStateMachine.Builder.create(this, "MyCfnStateMachine")
 *         .roleArn("roleArn")
 *         // the properties below are optional
 *         .definition(definition)
 *         .definitionS3Location(S3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .key("key")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .definitionString("definitionString")
 *         .definitionSubstitutions(Map.of(
 *                 "definitionSubstitutionsKey", definitionSubstitutions))
 *         .loggingConfiguration(LoggingConfigurationProperty.builder()
 *                 .destinations(List.of(LogDestinationProperty.builder()
 *                         .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
 *                                 .logGroupArn("logGroupArn")
 *                                 .build())
 *                         .build()))
 *                 .includeExecutionData(false)
 *                 .level("level")
 *                 .build())
 *         .stateMachineName("stateMachineName")
 *         .stateMachineType("stateMachineType")
 *         .tags(List.of(TagsEntryProperty.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .tracingConfiguration(TracingConfigurationProperty.builder()
 *                 .enabled(false)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-28T18:14:38.822Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.CfnStateMachine")
public class CfnStateMachine extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnStateMachine(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnStateMachine(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::StepFunctions::StateMachine`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnStateMachine(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.CfnStateMachineProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the name of the state machine. For example:.
     * <p>
     * <code>{ "Fn::GetAtt": ["MyStateMachine", "Name"] }</code>
     * <p>
     * Returns the name of your state machine:
     * <p>
     * <code>HelloWorld-StateMachine</code>
     * <p>
     * If you did not specify the name it will be similar to the following:
     * <p>
     * <code>MyStateMachine-1234abcdefgh</code>
     * <p>
     * For more information about using <code>Fn::GetAtt</code> , see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/intrinsic-function-reference-getatt.html">Fn::GetAtt</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrName() {
        return software.amazon.jsii.Kernel.get(this, "attrName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The list of tags to add to a resource.
     * <p>
     * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - &#64;</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.TagManager.class));
    }

    /**
     * The Amazon States Language definition of the state machine.
     * <p>
     * The state machine definition must be in JSON or YAML, and the format of the object must match the format of your AWS Step Functions template file. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon States Language definition of the state machine.
     * <p>
     * The state machine definition must be in JSON or YAML, and the format of the object must match the format of your AWS Step Functions template file. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.NotNull java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "definition", java.util.Objects.requireNonNull(value, "definition is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "roleArn", java.util.Objects.requireNonNull(value, "roleArn is required"));
    }

    /**
     * The name of the S3 bucket where the state machine definition is stored.
     * <p>
     * The state machine definition must be a JSON or YAML file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionS3Location() {
        return software.amazon.jsii.Kernel.get(this, "definitionS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The name of the S3 bucket where the state machine definition is stored.
     * <p>
     * The state machine definition must be a JSON or YAML file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionS3Location", value);
    }

    /**
     * The name of the S3 bucket where the state machine definition is stored.
     * <p>
     * The state machine definition must be a JSON or YAML file.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "definitionS3Location", value);
    }

    /**
     * The Amazon States Language definition of the state machine.
     * <p>
     * The state machine definition must be in JSON. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefinitionString() {
        return software.amazon.jsii.Kernel.get(this, "definitionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon States Language definition of the state machine.
     * <p>
     * The state machine definition must be in JSON. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionString(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definitionString", value);
    }

    /**
     * A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
     * <p>
     * This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionSubstitutions() {
        return software.amazon.jsii.Kernel.get(this, "definitionSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
     * <p>
     * This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionSubstitutions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionSubstitutions", value);
    }

    /**
     * A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
     * <p>
     * This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionSubstitutions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
            }
        }
        software.amazon.jsii.Kernel.set(this, "definitionSubstitutions", value);
    }

    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * <blockquote>
     * <p>
     * By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLoggingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "loggingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * <blockquote>
     * <p>
     * By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * <blockquote>
     * <p>
     * By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLoggingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CfnStateMachine.LoggingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "loggingConfiguration", value);
    }

    /**
     * The name of the state machine.
     * <p>
     * A name must <em>not</em> contain:
     * <p>
     * <ul>
     * <li>white space</li>
     * <li>brackets <code>&lt; &gt; { } [ ]</code></li>
     * <li>wildcard characters <code>? *</code></li>
     * <li>special characters <code>" # % \ ^ | ~ </code> $ &amp; , ; : /`</li>
     * <li>control characters ( <code>U+0000-001F</code> , <code>U+007F-009F</code> )</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStateMachineName() {
        return software.amazon.jsii.Kernel.get(this, "stateMachineName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the state machine.
     * <p>
     * A name must <em>not</em> contain:
     * <p>
     * <ul>
     * <li>white space</li>
     * <li>brackets <code>&lt; &gt; { } [ ]</code></li>
     * <li>wildcard characters <code>? *</code></li>
     * <li>special characters <code>" # % \ ^ | ~ </code> $ &amp; , ; : /`</li>
     * <li>control characters ( <code>U+0000-001F</code> , <code>U+007F-009F</code> )</li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
     * <p>
     * </blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStateMachineName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stateMachineName", value);
    }

    /**
     * Determines whether a `STANDARD` or `EXPRESS` state machine is created.
     * <p>
     * The default is <code>STANDARD</code> . You cannot update the <code>type</code> of a state machine once it has been created. For more information on <code>STANDARD</code> and <code>EXPRESS</code> workflows, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">Standard Versus Express Workflows</a> in the AWS Step Functions Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStateMachineType() {
        return software.amazon.jsii.Kernel.get(this, "stateMachineType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Determines whether a `STANDARD` or `EXPRESS` state machine is created.
     * <p>
     * The default is <code>STANDARD</code> . You cannot update the <code>type</code> of a state machine once it has been created. For more information on <code>STANDARD</code> and <code>EXPRESS</code> workflows, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">Standard Versus Express Workflows</a> in the AWS Step Functions Developer Guide.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStateMachineType(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "stateMachineType", value);
    }

    /**
     * Selects whether or not the state machine's AWS X-Ray tracing is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTracingConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "tracingConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Selects whether or not the state machine's AWS X-Ray tracing is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "tracingConfiguration", value);
    }

    /**
     * Selects whether or not the state machine's AWS X-Ray tracing is enabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTracingConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TracingConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "tracingConfiguration", value);
    }
    /**
     * Defines a CloudWatch log group.
     * <p>
     * <blockquote>
     * <p>
     * For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">Standard Versus Express Workflows</a> in the AWS Step Functions Developer Guide.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * CloudWatchLogsLogGroupProperty cloudWatchLogsLogGroupProperty = CloudWatchLogsLogGroupProperty.builder()
     *         .logGroupArn("logGroupArn")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.CfnStateMachine.CloudWatchLogsLogGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(CloudWatchLogsLogGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CloudWatchLogsLogGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The ARN of the the CloudWatch log group to which you want your logs emitted to.
         * <p>
         * The ARN must end with <code>:*</code>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLogGroupArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CloudWatchLogsLogGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CloudWatchLogsLogGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CloudWatchLogsLogGroupProperty> {
            java.lang.String logGroupArn;

            /**
             * Sets the value of {@link CloudWatchLogsLogGroupProperty#getLogGroupArn}
             * @param logGroupArn The ARN of the the CloudWatch log group to which you want your logs emitted to.
             *                    The ARN must end with <code>:*</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logGroupArn(java.lang.String logGroupArn) {
                this.logGroupArn = logGroupArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CloudWatchLogsLogGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CloudWatchLogsLogGroupProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link CloudWatchLogsLogGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CloudWatchLogsLogGroupProperty {
            private final java.lang.String logGroupArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.logGroupArn = software.amazon.jsii.Kernel.get(this, "logGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.logGroupArn = builder.logGroupArn;
            }

            @Override
            public final java.lang.String getLogGroupArn() {
                return this.logGroupArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getLogGroupArn() != null) {
                    data.set("logGroupArn", om.valueToTree(this.getLogGroupArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.CfnStateMachine.CloudWatchLogsLogGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CloudWatchLogsLogGroupProperty.Jsii$Proxy that = (CloudWatchLogsLogGroupProperty.Jsii$Proxy) o;

                return this.logGroupArn != null ? this.logGroupArn.equals(that.logGroupArn) : that.logGroupArn == null;
            }

            @Override
            public final int hashCode() {
                int result = this.logGroupArn != null ? this.logGroupArn.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Defines a destination for `LoggingConfiguration` .
     * <p>
     * <blockquote>
     * <p>
     * For more information on logging with <code>EXPRESS</code> workflows, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cw-logs.html">Logging Express Workflows Using CloudWatch Logs</a> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * LogDestinationProperty logDestinationProperty = LogDestinationProperty.builder()
     *         .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
     *                 .logGroupArn("logGroupArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.CfnStateMachine.LogDestinationProperty")
    @software.amazon.jsii.Jsii.Proxy(LogDestinationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LogDestinationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An object describing a CloudWatch log group.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudWatchLogsLogGroup() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LogDestinationProperty> {
            java.lang.Object cloudWatchLogsLogGroup;

            /**
             * Sets the value of {@link LogDestinationProperty#getCloudWatchLogsLogGroup}
             * @param cloudWatchLogsLogGroup An object describing a CloudWatch log group.
             *                               For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroup(software.amazon.awscdk.core.IResolvable cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            /**
             * Sets the value of {@link LogDestinationProperty#getCloudWatchLogsLogGroup}
             * @param cloudWatchLogsLogGroup An object describing a CloudWatch log group.
             *                               For more information, see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-logs-loggroup.html">AWS::Logs::LogGroup</a> in the AWS CloudFormation User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudWatchLogsLogGroup(software.amazon.awscdk.services.stepfunctions.CfnStateMachine.CloudWatchLogsLogGroupProperty cloudWatchLogsLogGroup) {
                this.cloudWatchLogsLogGroup = cloudWatchLogsLogGroup;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LogDestinationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LogDestinationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LogDestinationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LogDestinationProperty {
            private final java.lang.Object cloudWatchLogsLogGroup;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.cloudWatchLogsLogGroup = software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroup", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cloudWatchLogsLogGroup = builder.cloudWatchLogsLogGroup;
            }

            @Override
            public final java.lang.Object getCloudWatchLogsLogGroup() {
                return this.cloudWatchLogsLogGroup;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getCloudWatchLogsLogGroup() != null) {
                    data.set("cloudWatchLogsLogGroup", om.valueToTree(this.getCloudWatchLogsLogGroup()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.CfnStateMachine.LogDestinationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LogDestinationProperty.Jsii$Proxy that = (LogDestinationProperty.Jsii$Proxy) o;

                return this.cloudWatchLogsLogGroup != null ? this.cloudWatchLogsLogGroup.equals(that.cloudWatchLogsLogGroup) : that.cloudWatchLogsLogGroup == null;
            }

            @Override
            public final int hashCode() {
                int result = this.cloudWatchLogsLogGroup != null ? this.cloudWatchLogsLogGroup.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Defines what execution history events are logged and where they are logged.
     * <p>
     * <blockquote>
     * <p>
     * By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * LoggingConfigurationProperty loggingConfigurationProperty = LoggingConfigurationProperty.builder()
     *         .destinations(List.of(LogDestinationProperty.builder()
     *                 .cloudWatchLogsLogGroup(CloudWatchLogsLogGroupProperty.builder()
     *                         .logGroupArn("logGroupArn")
     *                         .build())
     *                 .build()))
     *         .includeExecutionData(false)
     *         .level("level")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.CfnStateMachine.LoggingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of objects that describes where your execution history events will be logged.
         * <p>
         * Limited to size 1. Required, if your log level is not set to <code>OFF</code> .
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDestinations() {
            return null;
        }

        /**
         * Determines whether execution data is included in your log.
         * <p>
         * When set to <code>false</code> , data is excluded.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeExecutionData() {
            return null;
        }

        /**
         * Defines which category of execution history events are logged.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLevel() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingConfigurationProperty> {
            java.lang.Object destinations;
            java.lang.Object includeExecutionData;
            java.lang.String level;

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDestinations}
             * @param destinations An array of objects that describes where your execution history events will be logged.
             *                     Limited to size 1. Required, if your log level is not set to <code>OFF</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(software.amazon.awscdk.core.IResolvable destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getDestinations}
             * @param destinations An array of objects that describes where your execution history events will be logged.
             *                     Limited to size 1. Required, if your log level is not set to <code>OFF</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder destinations(java.util.List<? extends java.lang.Object> destinations) {
                this.destinations = destinations;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getIncludeExecutionData}
             * @param includeExecutionData Determines whether execution data is included in your log.
             *                             When set to <code>false</code> , data is excluded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeExecutionData(java.lang.Boolean includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getIncludeExecutionData}
             * @param includeExecutionData Determines whether execution data is included in your log.
             *                             When set to <code>false</code> , data is excluded.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeExecutionData(software.amazon.awscdk.core.IResolvable includeExecutionData) {
                this.includeExecutionData = includeExecutionData;
                return this;
            }

            /**
             * Sets the value of {@link LoggingConfigurationProperty#getLevel}
             * @param level Defines which category of execution history events are logged.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder level(java.lang.String level) {
                this.level = level;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LoggingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingConfigurationProperty {
            private final java.lang.Object destinations;
            private final java.lang.Object includeExecutionData;
            private final java.lang.String level;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.destinations = software.amazon.jsii.Kernel.get(this, "destinations", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.includeExecutionData = software.amazon.jsii.Kernel.get(this, "includeExecutionData", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.level = software.amazon.jsii.Kernel.get(this, "level", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.destinations = builder.destinations;
                this.includeExecutionData = builder.includeExecutionData;
                this.level = builder.level;
            }

            @Override
            public final java.lang.Object getDestinations() {
                return this.destinations;
            }

            @Override
            public final java.lang.Object getIncludeExecutionData() {
                return this.includeExecutionData;
            }

            @Override
            public final java.lang.String getLevel() {
                return this.level;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDestinations() != null) {
                    data.set("destinations", om.valueToTree(this.getDestinations()));
                }
                if (this.getIncludeExecutionData() != null) {
                    data.set("includeExecutionData", om.valueToTree(this.getIncludeExecutionData()));
                }
                if (this.getLevel() != null) {
                    data.set("level", om.valueToTree(this.getLevel()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.CfnStateMachine.LoggingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingConfigurationProperty.Jsii$Proxy that = (LoggingConfigurationProperty.Jsii$Proxy) o;

                if (this.destinations != null ? !this.destinations.equals(that.destinations) : that.destinations != null) return false;
                if (this.includeExecutionData != null ? !this.includeExecutionData.equals(that.includeExecutionData) : that.includeExecutionData != null) return false;
                return this.level != null ? this.level.equals(that.level) : that.level == null;
            }

            @Override
            public final int hashCode() {
                int result = this.destinations != null ? this.destinations.hashCode() : 0;
                result = 31 * result + (this.includeExecutionData != null ? this.includeExecutionData.hashCode() : 0);
                result = 31 * result + (this.level != null ? this.level.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Defines the S3 bucket location where a state machine definition is stored.
     * <p>
     * The state machine definition must be a JSON or YAML file.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         // the properties below are optional
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.CfnStateMachine.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the S3 bucket where the state machine definition JSON or YAML file is stored.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The name of the state machine definition file (Amazon S3 object name).
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * For versioning-enabled buckets, a specific version of the state machine definition.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.String version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket The name of the S3 bucket where the state machine definition JSON or YAML file is stored. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key The name of the state machine definition file (Amazon S3 object name). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version For versioning-enabled buckets, a specific version of the state machine definition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.CfnStateMachine.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The `TagsEntry` property specifies *tags* to identify a state machine.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * TagsEntryProperty tagsEntryProperty = TagsEntryProperty.builder()
     *         .key("key")
     *         .value("value")
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.CfnStateMachine.TagsEntryProperty")
    @software.amazon.jsii.Jsii.Proxy(TagsEntryProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TagsEntryProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The `key` for a key-value pair in a tag entry.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The `value` for a key-value pair in a tag entry.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getValue();

        /**
         * @return a {@link Builder} of {@link TagsEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TagsEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TagsEntryProperty> {
            java.lang.String key;
            java.lang.String value;

            /**
             * Sets the value of {@link TagsEntryProperty#getKey}
             * @param key The `key` for a key-value pair in a tag entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link TagsEntryProperty#getValue}
             * @param value The `value` for a key-value pair in a tag entry. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder value(java.lang.String value) {
                this.value = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TagsEntryProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TagsEntryProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TagsEntryProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TagsEntryProperty {
            private final java.lang.String key;
            private final java.lang.String value;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.value = java.util.Objects.requireNonNull(builder.value, "value is required");
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getValue() {
                return this.value;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("key", om.valueToTree(this.getKey()));
                data.set("value", om.valueToTree(this.getValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.CfnStateMachine.TagsEntryProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TagsEntryProperty.Jsii$Proxy that = (TagsEntryProperty.Jsii$Proxy) o;

                if (!key.equals(that.key)) return false;
                return this.value.equals(that.value);
            }

            @Override
            public final int hashCode() {
                int result = this.key.hashCode();
                result = 31 * result + (this.value.hashCode());
                return result;
            }
        }
    }
    /**
     * Selects whether or not the state machine's AWS X-Ray tracing is enabled.
     * <p>
     * To configure your state machine to send trace data to X-Ray, set <code>Enabled</code> to <code>true</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.stepfunctions.*;
     * TracingConfigurationProperty tracingConfigurationProperty = TracingConfigurationProperty.builder()
     *         .enabled(false)
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.stepfunctions.$Module.class, fqn = "@aws-cdk/aws-stepfunctions.CfnStateMachine.TracingConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TracingConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TracingConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * When set to `true` , X-Ray tracing is enabled.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEnabled() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TracingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TracingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TracingConfigurationProperty> {
            java.lang.Object enabled;

            /**
             * Sets the value of {@link TracingConfigurationProperty#getEnabled}
             * @param enabled When set to `true` , X-Ray tracing is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link TracingConfigurationProperty#getEnabled}
             * @param enabled When set to `true` , X-Ray tracing is enabled.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TracingConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TracingConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TracingConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TracingConfigurationProperty {
            private final java.lang.Object enabled;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = builder.enabled;
            }

            @Override
            public final java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEnabled() != null) {
                    data.set("enabled", om.valueToTree(this.getEnabled()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-stepfunctions.CfnStateMachine.TracingConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TracingConfigurationProperty.Jsii$Proxy that = (TracingConfigurationProperty.Jsii$Proxy) o;

                return this.enabled != null ? this.enabled.equals(that.enabled) : that.enabled == null;
            }

            @Override
            public final int hashCode() {
                int result = this.enabled != null ? this.enabled.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachine}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.CfnStateMachine> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.CfnStateMachineProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.CfnStateMachineProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the IAM role to use for this state machine.
         * <p>
         * @return {@code this}
         * @param roleArn The Amazon Resource Name (ARN) of the IAM role to use for this state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(final java.lang.String roleArn) {
            this.props.roleArn(roleArn);
            return this;
        }

        /**
         * The Amazon States Language definition of the state machine.
         * <p>
         * The state machine definition must be in JSON or YAML, and the format of the object must match the format of your AWS Step Functions template file. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
         * <p>
         * @return {@code this}
         * @param definition The Amazon States Language definition of the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final java.lang.Object definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * The name of the S3 bucket where the state machine definition is stored.
         * <p>
         * The state machine definition must be a JSON or YAML file.
         * <p>
         * @return {@code this}
         * @param definitionS3Location The name of the S3 bucket where the state machine definition is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(final software.amazon.awscdk.core.IResolvable definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }
        /**
         * The name of the S3 bucket where the state machine definition is stored.
         * <p>
         * The state machine definition must be a JSON or YAML file.
         * <p>
         * @return {@code this}
         * @param definitionS3Location The name of the S3 bucket where the state machine definition is stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(final software.amazon.awscdk.services.stepfunctions.CfnStateMachine.S3LocationProperty definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        /**
         * The Amazon States Language definition of the state machine.
         * <p>
         * The state machine definition must be in JSON. See <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-amazon-states-language.html">Amazon States Language</a> .
         * <p>
         * @return {@code this}
         * @param definitionString The Amazon States Language definition of the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionString(final java.lang.String definitionString) {
            this.props.definitionString(definitionString);
            return this;
        }

        /**
         * A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
         * <p>
         * This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
         * <p>
         * @return {@code this}
         * @param definitionSubstitutions A map (string to string) that specifies the mappings for placeholder variables in the state machine definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(final software.amazon.awscdk.core.IResolvable definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }
        /**
         * A map (string to string) that specifies the mappings for placeholder variables in the state machine definition.
         * <p>
         * This enables the customer to inject values obtained at runtime, for example from intrinsic functions, in the state machine definition. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map.
         * <p>
         * @return {@code this}
         * @param definitionSubstitutions A map (string to string) that specifies the mappings for placeholder variables in the state machine definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(final java.util.Map<java.lang.String, ? extends java.lang.Object> definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        /**
         * Defines what execution history events are logged and where they are logged.
         * <p>
         * <blockquote>
         * <p>
         * By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param loggingConfiguration Defines what execution history events are logged and where they are logged. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.core.IResolvable loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }
        /**
         * Defines what execution history events are logged and where they are logged.
         * <p>
         * <blockquote>
         * <p>
         * By default, the <code>level</code> is set to <code>OFF</code> . For more information see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/cloudwatch-log-level.html">Log Levels</a> in the AWS Step Functions User Guide.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param loggingConfiguration Defines what execution history events are logged and where they are logged. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingConfiguration(final software.amazon.awscdk.services.stepfunctions.CfnStateMachine.LoggingConfigurationProperty loggingConfiguration) {
            this.props.loggingConfiguration(loggingConfiguration);
            return this;
        }

        /**
         * The name of the state machine.
         * <p>
         * A name must <em>not</em> contain:
         * <p>
         * <ul>
         * <li>white space</li>
         * <li>brackets <code>&lt; &gt; { } [ ]</code></li>
         * <li>wildcard characters <code>? *</code></li>
         * <li>special characters <code>" # % \ ^ | ~ </code> $ &amp; , ; : /`</li>
         * <li>control characters ( <code>U+0000-001F</code> , <code>U+007F-009F</code> )</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * If you specify a name, you cannot perform updates that require replacement of this resource. You can perform updates that require no or some interruption. If you must replace the resource, specify a new name.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @param stateMachineName The name of the state machine. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineName(final java.lang.String stateMachineName) {
            this.props.stateMachineName(stateMachineName);
            return this;
        }

        /**
         * Determines whether a `STANDARD` or `EXPRESS` state machine is created.
         * <p>
         * The default is <code>STANDARD</code> . You cannot update the <code>type</code> of a state machine once it has been created. For more information on <code>STANDARD</code> and <code>EXPRESS</code> workflows, see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-standard-vs-express.html">Standard Versus Express Workflows</a> in the AWS Step Functions Developer Guide.
         * <p>
         * @return {@code this}
         * @param stateMachineType Determines whether a `STANDARD` or `EXPRESS` state machine is created. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateMachineType(final java.lang.String stateMachineType) {
            this.props.stateMachineType(stateMachineType);
            return this;
        }

        /**
         * The list of tags to add to a resource.
         * <p>
         * Tags may only contain Unicode letters, digits, white space, or these symbols: <code>_ . : / = + - &#64;</code> .
         * <p>
         * @return {@code this}
         * @param tags The list of tags to add to a resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TagsEntryProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Selects whether or not the state machine's AWS X-Ray tracing is enabled.
         * <p>
         * @return {@code this}
         * @param tracingConfiguration Selects whether or not the state machine's AWS X-Ray tracing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfiguration(final software.amazon.awscdk.core.IResolvable tracingConfiguration) {
            this.props.tracingConfiguration(tracingConfiguration);
            return this;
        }
        /**
         * Selects whether or not the state machine's AWS X-Ray tracing is enabled.
         * <p>
         * @return {@code this}
         * @param tracingConfiguration Selects whether or not the state machine's AWS X-Ray tracing is enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tracingConfiguration(final software.amazon.awscdk.services.stepfunctions.CfnStateMachine.TracingConfigurationProperty tracingConfiguration) {
            this.props.tracingConfiguration(tracingConfiguration);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.CfnStateMachine}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.CfnStateMachine build() {
            return new software.amazon.awscdk.services.stepfunctions.CfnStateMachine(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
