/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.stepfunctions.IntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.TaskInput;
import software.amazon.awscdk.services.stepfunctions.TaskStateBaseProps;
import software.amazon.awscdk.services.stepfunctions.tasks.;
import software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvocationType;
import software.amazon.awscdk.services.stepfunctions.tasks.LambdaInvokeProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.LambdaInvokeProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface LambdaInvokeProps
extends JsiiSerializable,
TaskStateBaseProps {
    @NotNull
    public IFunction getLambdaFunction();

    @Nullable
    default public String getClientContext() {
        return null;
    }

    @Nullable
    default public LambdaInvocationType getInvocationType() {
        return null;
    }

    @Nullable
    default public TaskInput getPayload() {
        return null;
    }

    @Nullable
    default public String getQualifier() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IFunction lambdaFunction;
        private String clientContext;
        private LambdaInvocationType invocationType;
        private TaskInput payload;
        private String qualifier;
        private String comment;
        private Duration heartbeat;
        private String inputPath;
        private IntegrationPattern integrationPattern;
        private String outputPath;
        private String resultPath;
        private Duration timeout;

        public Builder lambdaFunction(IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
            return this;
        }

        public Builder clientContext(String clientContext) {
            this.clientContext = clientContext;
            return this;
        }

        public Builder invocationType(LambdaInvocationType invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        public Builder payload(TaskInput payload) {
            this.payload = payload;
            return this;
        }

        public Builder qualifier(String qualifier) {
            this.qualifier = qualifier;
            return this;
        }

        public Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public Builder heartbeat(Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        public Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public Builder integrationPattern(IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder outputPath(String outputPath) {
            this.outputPath = outputPath;
            return this;
        }

        public Builder resultPath(String resultPath) {
            this.resultPath = resultPath;
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public LambdaInvokeProps build() {
            return new Jsii.Proxy(this.lambdaFunction, this.clientContext, this.invocationType, this.payload, this.qualifier, this.comment, this.heartbeat, this.inputPath, this.integrationPattern, this.outputPath, this.resultPath, this.timeout, null);
        }
    }
}

