/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.iam.IRole;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.tasks.$Module;
import software.amazon.awscdk.services.stepfunctions.tasks.BatchStrategy;
import software.amazon.awscdk.services.stepfunctions.tasks.SagemakerTransformProps;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformInput;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformOutput;
import software.amazon.awscdk.services.stepfunctions.tasks.TransformResources;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.SagemakerTransformProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface SagemakerTransformProps
extends JsiiSerializable {
    @NotNull
    public String getModelName();

    @NotNull
    public TransformInput getTransformInput();

    @NotNull
    public String getTransformJobName();

    @NotNull
    public TransformOutput getTransformOutput();

    @Nullable
    default public BatchStrategy getBatchStrategy() {
        return null;
    }

    @Nullable
    default public Map<String, String> getEnvironment() {
        return null;
    }

    @Nullable
    default public ServiceIntegrationPattern getIntegrationPattern() {
        return null;
    }

    @Nullable
    default public Number getMaxConcurrentTransforms() {
        return null;
    }

    @Nullable
    default public Number getMaxPayloadInMb() {
        return null;
    }

    @Nullable
    default public IRole getRole() {
        return null;
    }

    @Nullable
    default public Map<String, String> getTags() {
        return null;
    }

    @Nullable
    default public TransformResources getTransformResources() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String modelName;
        private TransformInput transformInput;
        private String transformJobName;
        private TransformOutput transformOutput;
        private BatchStrategy batchStrategy;
        private Map<String, String> environment;
        private ServiceIntegrationPattern integrationPattern;
        private Number maxConcurrentTransforms;
        private Number maxPayloadInMb;
        private IRole role;
        private Map<String, String> tags;
        private TransformResources transformResources;

        public Builder modelName(String modelName) {
            this.modelName = modelName;
            return this;
        }

        public Builder transformInput(TransformInput transformInput) {
            this.transformInput = transformInput;
            return this;
        }

        public Builder transformJobName(String transformJobName) {
            this.transformJobName = transformJobName;
            return this;
        }

        public Builder transformOutput(TransformOutput transformOutput) {
            this.transformOutput = transformOutput;
            return this;
        }

        public Builder batchStrategy(BatchStrategy batchStrategy) {
            this.batchStrategy = batchStrategy;
            return this;
        }

        public Builder environment(Map<String, String> environment) {
            this.environment = environment;
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        public Builder maxConcurrentTransforms(Number maxConcurrentTransforms) {
            this.maxConcurrentTransforms = maxConcurrentTransforms;
            return this;
        }

        public Builder maxPayloadInMb(Number maxPayloadInMb) {
            this.maxPayloadInMb = maxPayloadInMb;
            return this;
        }

        public Builder role(IRole role) {
            this.role = role;
            return this;
        }

        public Builder tags(Map<String, String> tags) {
            this.tags = tags;
            return this;
        }

        public Builder transformResources(TransformResources transformResources) {
            this.transformResources = transformResources;
            return this;
        }

        public SagemakerTransformProps build() {
            return new Jsii.Proxy(this.modelName, this.transformInput, this.transformJobName, this.transformOutput, this.batchStrategy, this.environment, this.integrationPattern, this.maxConcurrentTransforms, this.maxPayloadInMb, this.role, this.tags, this.transformResources, null);
        }
    }
}

