/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Duration;
import software.amazon.awscdk.services.stepfunctions.IStepFunctionsTask;
import software.amazon.awscdk.services.stepfunctions.ServiceIntegrationPattern;
import software.amazon.awscdk.services.stepfunctions.StepFunctionsTaskConfig;
import software.amazon.awscdk.services.stepfunctions.Task;
import software.amazon.awscdk.services.stepfunctions.tasks.$Module;
import software.amazon.awscdk.services.stepfunctions.tasks.RunGlueJobTaskProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;

@Jsii(module=$Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.RunGlueJobTask")
public class RunGlueJobTask
extends JsiiObject
implements IStepFunctionsTask {
    protected RunGlueJobTask(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected RunGlueJobTask(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public RunGlueJobTask(@NotNull String glueJobName, @Nullable RunGlueJobTaskProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(glueJobName, "glueJobName is required"), props});
    }

    public RunGlueJobTask(@NotNull String glueJobName) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(glueJobName, "glueJobName is required")});
    }

    @NotNull
    public StepFunctionsTaskConfig bind(@NotNull Task task) {
        return (StepFunctionsTaskConfig)this.jsiiCall("bind", StepFunctionsTaskConfig.class, new Object[]{Objects.requireNonNull(task, "task is required")});
    }

    public static final class Builder {
        private final String glueJobName;
        private RunGlueJobTaskProps.Builder props;

        public static Builder create(String glueJobName) {
            return new Builder(glueJobName);
        }

        private Builder(String glueJobName) {
            this.glueJobName = glueJobName;
        }

        public Builder arguments(Map<String, String> arguments) {
            this.props().arguments(arguments);
            return this;
        }

        public Builder integrationPattern(ServiceIntegrationPattern integrationPattern) {
            this.props().integrationPattern(integrationPattern);
            return this;
        }

        public Builder notifyDelayAfter(Duration notifyDelayAfter) {
            this.props().notifyDelayAfter(notifyDelayAfter);
            return this;
        }

        public Builder securityConfiguration(String securityConfiguration) {
            this.props().securityConfiguration(securityConfiguration);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        public RunGlueJobTask build() {
            return new RunGlueJobTask(this.glueJobName, this.props != null ? this.props.build() : null);
        }

        private RunGlueJobTaskProps.Builder props() {
            if (this.props == null) {
                this.props = new RunGlueJobTaskProps.Builder();
            }
            return this.props;
        }
    }
}

