/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.stepfunctions.tasks;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.services.stepfunctions.tasks.;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoAttributeValueMap;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoConsumedCapacity;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoItemCollectionMetrics;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoPutItemProps;
import software.amazon.awscdk.services.stepfunctions.tasks.DynamoReturnValues;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-stepfunctions-tasks.DynamoPutItemProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface DynamoPutItemProps
extends JsiiSerializable {
    @NotNull
    public DynamoAttributeValueMap getItem();

    @NotNull
    public String getTableName();

    @Nullable
    default public String getConditionExpression() {
        return null;
    }

    @Nullable
    default public Map<String, String> getExpressionAttributeNames() {
        return null;
    }

    @Nullable
    default public DynamoAttributeValueMap getExpressionAttributeValues() {
        return null;
    }

    @Nullable
    default public DynamoConsumedCapacity getReturnConsumedCapacity() {
        return null;
    }

    @Nullable
    default public DynamoItemCollectionMetrics getReturnItemCollectionMetrics() {
        return null;
    }

    @Nullable
    default public DynamoReturnValues getReturnValues() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private DynamoAttributeValueMap item;
        private String tableName;
        private String conditionExpression;
        private Map<String, String> expressionAttributeNames;
        private DynamoAttributeValueMap expressionAttributeValues;
        private DynamoConsumedCapacity returnConsumedCapacity;
        private DynamoItemCollectionMetrics returnItemCollectionMetrics;
        private DynamoReturnValues returnValues;

        public Builder item(DynamoAttributeValueMap item) {
            this.item = item;
            return this;
        }

        public Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder conditionExpression(String conditionExpression) {
            this.conditionExpression = conditionExpression;
            return this;
        }

        public Builder expressionAttributeNames(Map<String, String> expressionAttributeNames) {
            this.expressionAttributeNames = expressionAttributeNames;
            return this;
        }

        public Builder expressionAttributeValues(DynamoAttributeValueMap expressionAttributeValues) {
            this.expressionAttributeValues = expressionAttributeValues;
            return this;
        }

        public Builder returnConsumedCapacity(DynamoConsumedCapacity returnConsumedCapacity) {
            this.returnConsumedCapacity = returnConsumedCapacity;
            return this;
        }

        public Builder returnItemCollectionMetrics(DynamoItemCollectionMetrics returnItemCollectionMetrics) {
            this.returnItemCollectionMetrics = returnItemCollectionMetrics;
            return this;
        }

        public Builder returnValues(DynamoReturnValues returnValues) {
            this.returnValues = returnValues;
            return this;
        }

        public DynamoPutItemProps build() {
            return new Jsii.Proxy(this.item, this.tableName, this.conditionExpression, this.expressionAttributeNames, this.expressionAttributeValues, this.returnConsumedCapacity, this.returnItemCollectionMetrics, this.returnValues, null);
        }
    }
}

