package software.amazon.awscdk.services.secretsmanager;

/**
 * Configuration to generate secrets such as passwords automatically.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.440Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.secretsmanager.$Module.class, fqn = "@aws-cdk/aws-secretsmanager.SecretStringGenerator")
@software.amazon.jsii.Jsii.Proxy(SecretStringGenerator.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SecretStringGenerator extends software.amazon.jsii.JsiiSerializable {

    /**
     * A string that includes characters that shouldn't be included in the generated password.
     * <p>
     * The string can be a minimum
     * of <code>0</code> and a maximum of <code>4096</code> characters long.
     * <p>
     * Default: no exclusions
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExcludeCharacters() {
        return null;
    }

    /**
     * Specifies that the generated password shouldn't include lowercase letters.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExcludeLowercase() {
        return null;
    }

    /**
     * Specifies that the generated password shouldn't include digits.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExcludeNumbers() {
        return null;
    }

    /**
     * Specifies that the generated password shouldn't include punctuation characters.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExcludePunctuation() {
        return null;
    }

    /**
     * Specifies that the generated password shouldn't include uppercase letters.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExcludeUppercase() {
        return null;
    }

    /**
     * The JSON key name that's used to add the generated password to the JSON structure specified by the ``secretStringTemplate`` parameter.
     * <p>
     * If you specify <code>generateStringKey</code> then <code>secretStringTemplate</code>
     * must be also be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getGenerateStringKey() {
        return null;
    }

    /**
     * Specifies that the generated password can include the space character.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getIncludeSpace() {
        return null;
    }

    /**
     * The desired length of the generated password.
     * <p>
     * Default: 32
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getPasswordLength() {
        return null;
    }

    /**
     * Specifies whether the generated password must include at least one of every allowed character type.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireEachIncludedType() {
        return null;
    }

    /**
     * A properly structured JSON string that the generated password can be added to.
     * <p>
     * The <code>generateStringKey</code> is
     * combined with the generated random string and inserted into the JSON structure that's specified by this parameter.
     * The merged JSON string is returned as the completed SecretString of the secret. If you specify <code>secretStringTemplate</code>
     * then <code>generateStringKey</code> must be also be specified.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSecretStringTemplate() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link SecretStringGenerator}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SecretStringGenerator}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SecretStringGenerator> {
        private java.lang.String excludeCharacters;
        private java.lang.Boolean excludeLowercase;
        private java.lang.Boolean excludeNumbers;
        private java.lang.Boolean excludePunctuation;
        private java.lang.Boolean excludeUppercase;
        private java.lang.String generateStringKey;
        private java.lang.Boolean includeSpace;
        private java.lang.Number passwordLength;
        private java.lang.Boolean requireEachIncludedType;
        private java.lang.String secretStringTemplate;

        /**
         * Sets the value of {@link SecretStringGenerator#getExcludeCharacters}
         * @param excludeCharacters A string that includes characters that shouldn't be included in the generated password.
         *                          The string can be a minimum
         *                          of <code>0</code> and a maximum of <code>4096</code> characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeCharacters(java.lang.String excludeCharacters) {
            this.excludeCharacters = excludeCharacters;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getExcludeLowercase}
         * @param excludeLowercase Specifies that the generated password shouldn't include lowercase letters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeLowercase(java.lang.Boolean excludeLowercase) {
            this.excludeLowercase = excludeLowercase;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getExcludeNumbers}
         * @param excludeNumbers Specifies that the generated password shouldn't include digits.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeNumbers(java.lang.Boolean excludeNumbers) {
            this.excludeNumbers = excludeNumbers;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getExcludePunctuation}
         * @param excludePunctuation Specifies that the generated password shouldn't include punctuation characters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludePunctuation(java.lang.Boolean excludePunctuation) {
            this.excludePunctuation = excludePunctuation;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getExcludeUppercase}
         * @param excludeUppercase Specifies that the generated password shouldn't include uppercase letters.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder excludeUppercase(java.lang.Boolean excludeUppercase) {
            this.excludeUppercase = excludeUppercase;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getGenerateStringKey}
         * @param generateStringKey The JSON key name that's used to add the generated password to the JSON structure specified by the ``secretStringTemplate`` parameter.
         *                          If you specify <code>generateStringKey</code> then <code>secretStringTemplate</code>
         *                          must be also be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder generateStringKey(java.lang.String generateStringKey) {
            this.generateStringKey = generateStringKey;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getIncludeSpace}
         * @param includeSpace Specifies that the generated password can include the space character.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeSpace(java.lang.Boolean includeSpace) {
            this.includeSpace = includeSpace;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getPasswordLength}
         * @param passwordLength The desired length of the generated password.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passwordLength(java.lang.Number passwordLength) {
            this.passwordLength = passwordLength;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getRequireEachIncludedType}
         * @param requireEachIncludedType Specifies whether the generated password must include at least one of every allowed character type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireEachIncludedType(java.lang.Boolean requireEachIncludedType) {
            this.requireEachIncludedType = requireEachIncludedType;
            return this;
        }

        /**
         * Sets the value of {@link SecretStringGenerator#getSecretStringTemplate}
         * @param secretStringTemplate A properly structured JSON string that the generated password can be added to.
         *                             The <code>generateStringKey</code> is
         *                             combined with the generated random string and inserted into the JSON structure that's specified by this parameter.
         *                             The merged JSON string is returned as the completed SecretString of the secret. If you specify <code>secretStringTemplate</code>
         *                             then <code>generateStringKey</code> must be also be specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secretStringTemplate(java.lang.String secretStringTemplate) {
            this.secretStringTemplate = secretStringTemplate;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SecretStringGenerator}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SecretStringGenerator build() {
            return new Jsii$Proxy(excludeCharacters, excludeLowercase, excludeNumbers, excludePunctuation, excludeUppercase, generateStringKey, includeSpace, passwordLength, requireEachIncludedType, secretStringTemplate);
        }
    }

    /**
     * An implementation for {@link SecretStringGenerator}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SecretStringGenerator {
        private final java.lang.String excludeCharacters;
        private final java.lang.Boolean excludeLowercase;
        private final java.lang.Boolean excludeNumbers;
        private final java.lang.Boolean excludePunctuation;
        private final java.lang.Boolean excludeUppercase;
        private final java.lang.String generateStringKey;
        private final java.lang.Boolean includeSpace;
        private final java.lang.Number passwordLength;
        private final java.lang.Boolean requireEachIncludedType;
        private final java.lang.String secretStringTemplate;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.excludeCharacters = this.jsiiGet("excludeCharacters", java.lang.String.class);
            this.excludeLowercase = this.jsiiGet("excludeLowercase", java.lang.Boolean.class);
            this.excludeNumbers = this.jsiiGet("excludeNumbers", java.lang.Boolean.class);
            this.excludePunctuation = this.jsiiGet("excludePunctuation", java.lang.Boolean.class);
            this.excludeUppercase = this.jsiiGet("excludeUppercase", java.lang.Boolean.class);
            this.generateStringKey = this.jsiiGet("generateStringKey", java.lang.String.class);
            this.includeSpace = this.jsiiGet("includeSpace", java.lang.Boolean.class);
            this.passwordLength = this.jsiiGet("passwordLength", java.lang.Number.class);
            this.requireEachIncludedType = this.jsiiGet("requireEachIncludedType", java.lang.Boolean.class);
            this.secretStringTemplate = this.jsiiGet("secretStringTemplate", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String excludeCharacters, final java.lang.Boolean excludeLowercase, final java.lang.Boolean excludeNumbers, final java.lang.Boolean excludePunctuation, final java.lang.Boolean excludeUppercase, final java.lang.String generateStringKey, final java.lang.Boolean includeSpace, final java.lang.Number passwordLength, final java.lang.Boolean requireEachIncludedType, final java.lang.String secretStringTemplate) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.excludeCharacters = excludeCharacters;
            this.excludeLowercase = excludeLowercase;
            this.excludeNumbers = excludeNumbers;
            this.excludePunctuation = excludePunctuation;
            this.excludeUppercase = excludeUppercase;
            this.generateStringKey = generateStringKey;
            this.includeSpace = includeSpace;
            this.passwordLength = passwordLength;
            this.requireEachIncludedType = requireEachIncludedType;
            this.secretStringTemplate = secretStringTemplate;
        }

        @Override
        public java.lang.String getExcludeCharacters() {
            return this.excludeCharacters;
        }

        @Override
        public java.lang.Boolean getExcludeLowercase() {
            return this.excludeLowercase;
        }

        @Override
        public java.lang.Boolean getExcludeNumbers() {
            return this.excludeNumbers;
        }

        @Override
        public java.lang.Boolean getExcludePunctuation() {
            return this.excludePunctuation;
        }

        @Override
        public java.lang.Boolean getExcludeUppercase() {
            return this.excludeUppercase;
        }

        @Override
        public java.lang.String getGenerateStringKey() {
            return this.generateStringKey;
        }

        @Override
        public java.lang.Boolean getIncludeSpace() {
            return this.includeSpace;
        }

        @Override
        public java.lang.Number getPasswordLength() {
            return this.passwordLength;
        }

        @Override
        public java.lang.Boolean getRequireEachIncludedType() {
            return this.requireEachIncludedType;
        }

        @Override
        public java.lang.String getSecretStringTemplate() {
            return this.secretStringTemplate;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getExcludeCharacters() != null) {
                data.set("excludeCharacters", om.valueToTree(this.getExcludeCharacters()));
            }
            if (this.getExcludeLowercase() != null) {
                data.set("excludeLowercase", om.valueToTree(this.getExcludeLowercase()));
            }
            if (this.getExcludeNumbers() != null) {
                data.set("excludeNumbers", om.valueToTree(this.getExcludeNumbers()));
            }
            if (this.getExcludePunctuation() != null) {
                data.set("excludePunctuation", om.valueToTree(this.getExcludePunctuation()));
            }
            if (this.getExcludeUppercase() != null) {
                data.set("excludeUppercase", om.valueToTree(this.getExcludeUppercase()));
            }
            if (this.getGenerateStringKey() != null) {
                data.set("generateStringKey", om.valueToTree(this.getGenerateStringKey()));
            }
            if (this.getIncludeSpace() != null) {
                data.set("includeSpace", om.valueToTree(this.getIncludeSpace()));
            }
            if (this.getPasswordLength() != null) {
                data.set("passwordLength", om.valueToTree(this.getPasswordLength()));
            }
            if (this.getRequireEachIncludedType() != null) {
                data.set("requireEachIncludedType", om.valueToTree(this.getRequireEachIncludedType()));
            }
            if (this.getSecretStringTemplate() != null) {
                data.set("secretStringTemplate", om.valueToTree(this.getSecretStringTemplate()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-secretsmanager.SecretStringGenerator"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SecretStringGenerator.Jsii$Proxy that = (SecretStringGenerator.Jsii$Proxy) o;

            if (this.excludeCharacters != null ? !this.excludeCharacters.equals(that.excludeCharacters) : that.excludeCharacters != null) return false;
            if (this.excludeLowercase != null ? !this.excludeLowercase.equals(that.excludeLowercase) : that.excludeLowercase != null) return false;
            if (this.excludeNumbers != null ? !this.excludeNumbers.equals(that.excludeNumbers) : that.excludeNumbers != null) return false;
            if (this.excludePunctuation != null ? !this.excludePunctuation.equals(that.excludePunctuation) : that.excludePunctuation != null) return false;
            if (this.excludeUppercase != null ? !this.excludeUppercase.equals(that.excludeUppercase) : that.excludeUppercase != null) return false;
            if (this.generateStringKey != null ? !this.generateStringKey.equals(that.generateStringKey) : that.generateStringKey != null) return false;
            if (this.includeSpace != null ? !this.includeSpace.equals(that.includeSpace) : that.includeSpace != null) return false;
            if (this.passwordLength != null ? !this.passwordLength.equals(that.passwordLength) : that.passwordLength != null) return false;
            if (this.requireEachIncludedType != null ? !this.requireEachIncludedType.equals(that.requireEachIncludedType) : that.requireEachIncludedType != null) return false;
            return this.secretStringTemplate != null ? this.secretStringTemplate.equals(that.secretStringTemplate) : that.secretStringTemplate == null;
        }

        @Override
        public int hashCode() {
            int result = this.excludeCharacters != null ? this.excludeCharacters.hashCode() : 0;
            result = 31 * result + (this.excludeLowercase != null ? this.excludeLowercase.hashCode() : 0);
            result = 31 * result + (this.excludeNumbers != null ? this.excludeNumbers.hashCode() : 0);
            result = 31 * result + (this.excludePunctuation != null ? this.excludePunctuation.hashCode() : 0);
            result = 31 * result + (this.excludeUppercase != null ? this.excludeUppercase.hashCode() : 0);
            result = 31 * result + (this.generateStringKey != null ? this.generateStringKey.hashCode() : 0);
            result = 31 * result + (this.includeSpace != null ? this.includeSpace.hashCode() : 0);
            result = 31 * result + (this.passwordLength != null ? this.passwordLength.hashCode() : 0);
            result = 31 * result + (this.requireEachIncludedType != null ? this.requireEachIncludedType.hashCode() : 0);
            result = 31 * result + (this.secretStringTemplate != null ? this.secretStringTemplate.hashCode() : 0);
            return result;
        }
    }
}
