/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.s3objectlambda;

import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.Resource;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.awscdk.services.s3.IBucket;
import software.amazon.awscdk.services.s3.VirtualHostedStyleUrlOptions;
import software.amazon.awscdk.services.s3objectlambda.;
import software.amazon.awscdk.services.s3objectlambda.AccessPointAttributes;
import software.amazon.awscdk.services.s3objectlambda.AccessPointProps;
import software.amazon.awscdk.services.s3objectlambda.IAccessPoint;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-s3objectlambda.AccessPoint")
public class AccessPoint
extends Resource
implements IAccessPoint {
    protected AccessPoint(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected AccessPoint(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public AccessPoint(@NotNull Construct scope, @NotNull String id, @NotNull AccessPointProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @NotNull
    public static IAccessPoint fromAccessPointAttributes(@NotNull Construct scope, @NotNull String id, @NotNull AccessPointAttributes attrs) {
        return (IAccessPoint)JsiiObject.jsiiStaticCall(AccessPoint.class, (String)"fromAccessPointAttributes", (NativeType)NativeType.forClass(IAccessPoint.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(attrs, "attrs is required")});
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject(@Nullable String key, @Nullable VirtualHostedStyleUrlOptions options) {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key, options});
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject(@Nullable String key) {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[]{key});
    }

    @Override
    @NotNull
    public String virtualHostedUrlForObject() {
        return (String)Kernel.call((Object)this, (String)"virtualHostedUrlForObject", (NativeType)NativeType.forClass(String.class), (Object[])new Object[0]);
    }

    @Override
    @NotNull
    public String getAccessPointArn() {
        return (String)Kernel.get((Object)this, (String)"accessPointArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getAccessPointCreationDate() {
        return (String)Kernel.get((Object)this, (String)"accessPointCreationDate", (NativeType)NativeType.forClass(String.class));
    }

    @NotNull
    public String getAccessPointName() {
        return (String)Kernel.get((Object)this, (String)"accessPointName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getDomainName() {
        return (String)Kernel.get((Object)this, (String)"domainName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getRegionalDomainName() {
        return (String)Kernel.get((Object)this, (String)"regionalDomainName", (NativeType)NativeType.forClass(String.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<AccessPoint> {
        private final Construct scope;
        private final String id;
        private final AccessPointProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new AccessPointProps.Builder();
        }

        public Builder bucket(IBucket bucket) {
            this.props.bucket(bucket);
            return this;
        }

        public Builder handler(IFunction handler) {
            this.props.handler(handler);
            return this;
        }

        public Builder accessPointName(String accessPointName) {
            this.props.accessPointName(accessPointName);
            return this;
        }

        public Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.props.cloudWatchMetricsEnabled(cloudWatchMetricsEnabled);
            return this;
        }

        public Builder payload(Map<String, ? extends Object> payload) {
            this.props.payload(payload);
            return this;
        }

        public Builder supportsGetObjectPartNumber(Boolean supportsGetObjectPartNumber) {
            this.props.supportsGetObjectPartNumber(supportsGetObjectPartNumber);
            return this;
        }

        public Builder supportsGetObjectRange(Boolean supportsGetObjectRange) {
            this.props.supportsGetObjectRange(supportsGetObjectRange);
            return this;
        }

        public AccessPoint build() {
            return new AccessPoint(this.scope, this.id, this.props.build());
        }
    }
}

