/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.resourcegroups;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.core.CfnResource;
import software.amazon.awscdk.core.Construct;
import software.amazon.awscdk.core.IInspectable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.core.TagManager;
import software.amazon.awscdk.core.TreeInspector;
import software.amazon.awscdk.services.resourcegroups.;
import software.amazon.awscdk.services.resourcegroups.CfnGroup;
import software.amazon.awscdk.services.resourcegroups.CfnGroupProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.NativeType;

@Jsii(module=.Module.class, fqn="@aws-cdk/aws-resourcegroups.CfnGroup")
public class CfnGroup
extends CfnResource
implements IInspectable {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnGroup.class, (String)"CFN_RESOURCE_TYPE_NAME", String.class);

    protected CfnGroup(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGroup(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnGroup(@NotNull Construct scope, @NotNull String id, @NotNull CfnGroupProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    public void inspect(@NotNull TreeInspector inspector) {
        this.jsiiCall("inspect", NativeType.VOID, new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)this.jsiiCall("renderProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrArn() {
        return (String)this.jsiiGet("attrArn", String.class);
    }

    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)this.jsiiGet("cfnProperties", NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public TagManager getTags() {
        return (TagManager)this.jsiiGet("tags", TagManager.class);
    }

    @NotNull
    public String getName() {
        return (String)this.jsiiGet("name", String.class);
    }

    public void setName(@NotNull String value) {
        this.jsiiSet("name", Objects.requireNonNull(value, "name is required"));
    }

    @Nullable
    public String getDescription() {
        return (String)this.jsiiGet("description", String.class);
    }

    public void setDescription(@Nullable String value) {
        this.jsiiSet("description", value);
    }

    @Nullable
    public Object getResourceQuery() {
        return this.jsiiGet("resourceQuery", Object.class);
    }

    public void setResourceQuery(@Nullable ResourceQueryProperty value) {
        this.jsiiSet("resourceQuery", value);
    }

    public void setResourceQuery(@Nullable IResolvable value) {
        this.jsiiSet("resourceQuery", value);
    }

    public static final class Builder {
        private final Construct scope;
        private final String id;
        private final CfnGroupProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnGroupProps.Builder();
        }

        public Builder name(String name) {
            this.props.name(name);
            return this;
        }

        public Builder description(String description) {
            this.props.description(description);
            return this;
        }

        public Builder resourceQuery(ResourceQueryProperty resourceQuery) {
            this.props.resourceQuery(resourceQuery);
            return this;
        }

        public Builder resourceQuery(IResolvable resourceQuery) {
            this.props.resourceQuery(resourceQuery);
            return this;
        }

        public Builder tags(Object tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnGroup build() {
            return new CfnGroup(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-resourcegroups.CfnGroup.TagFilterProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface TagFilterProperty
    extends JsiiSerializable {
        @Nullable
        default public String getKey() {
            return null;
        }

        @Nullable
        default public List<String> getValues() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private String key;
            private List<String> values;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder values(List<String> values) {
                this.values = values;
                return this;
            }

            public TagFilterProperty build() {
                return new Jsii.Proxy(this.key, this.values, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-resourcegroups.CfnGroup.ResourceQueryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceQueryProperty
    extends JsiiSerializable {
        @Nullable
        default public Object getQuery() {
            return null;
        }

        @Nullable
        default public String getType() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private Object query;
            private String type;

            public Builder query(IResolvable query) {
                this.query = query;
                return this;
            }

            public Builder query(QueryProperty query) {
                this.query = query;
                return this;
            }

            public Builder type(String type) {
                this.type = type;
                return this;
            }

            public ResourceQueryProperty build() {
                return new Jsii.Proxy(this.query, this.type, null);
            }
        }
    }

    @Jsii(module=.Module.class, fqn="@aws-cdk/aws-resourcegroups.CfnGroup.QueryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface QueryProperty
    extends JsiiSerializable {
        @Nullable
        default public List<String> getResourceTypeFilters() {
            return null;
        }

        @Nullable
        default public String getStackIdentifier() {
            return null;
        }

        @Nullable
        default public Object getTagFilters() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder {
            private List<String> resourceTypeFilters;
            private String stackIdentifier;
            private Object tagFilters;

            public Builder resourceTypeFilters(List<String> resourceTypeFilters) {
                this.resourceTypeFilters = resourceTypeFilters;
                return this;
            }

            public Builder stackIdentifier(String stackIdentifier) {
                this.stackIdentifier = stackIdentifier;
                return this;
            }

            public Builder tagFilters(IResolvable tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public Builder tagFilters(List<Object> tagFilters) {
                this.tagFilters = tagFilters;
                return this;
            }

            public QueryProperty build() {
                return new Jsii.Proxy(this.resourceTypeFilters, this.stackIdentifier, this.tagFilters, null);
            }
        }
    }
}

