package software.amazon.awscdk.services.lambda;

/**
 * Identification of an account (or organization) that is allowed to access a Lambda Layer Version.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.333Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.$Module.class, fqn = "@aws-cdk/aws-lambda.LayerVersionPermission")
@software.amazon.jsii.Jsii.Proxy(LayerVersionPermission.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LayerVersionPermission extends software.amazon.jsii.JsiiSerializable {

    /**
     * The AWS Account id of the account that is authorized to use a Lambda Layer Version.
     * <p>
     * The wild-card <code>'*'</code> can be
     * used to grant access to "any" account (or any account in an organization when <code>organizationId</code> is specified).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAccountId();

    /**
     * The ID of the AWS Organization to hwich the grant is restricted.
     * <p>
     * Can only be specified if <code>accountId</code> is <code>'*'</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOrganizationId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LayerVersionPermission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LayerVersionPermission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LayerVersionPermission> {
        private java.lang.String accountId;
        private java.lang.String organizationId;

        /**
         * Sets the value of {@link LayerVersionPermission#getAccountId}
         * @param accountId The AWS Account id of the account that is authorized to use a Lambda Layer Version. This parameter is required.
         *                  The wild-card <code>'*'</code> can be
         *                  used to grant access to "any" account (or any account in an organization when <code>organizationId</code> is specified).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accountId(java.lang.String accountId) {
            this.accountId = accountId;
            return this;
        }

        /**
         * Sets the value of {@link LayerVersionPermission#getOrganizationId}
         * @param organizationId The ID of the AWS Organization to hwich the grant is restricted.
         *                       Can only be specified if <code>accountId</code> is <code>'*'</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder organizationId(java.lang.String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LayerVersionPermission}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LayerVersionPermission build() {
            return new Jsii$Proxy(accountId, organizationId);
        }
    }

    /**
     * An implementation for {@link LayerVersionPermission}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LayerVersionPermission {
        private final java.lang.String accountId;
        private final java.lang.String organizationId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.accountId = this.jsiiGet("accountId", java.lang.String.class);
            this.organizationId = this.jsiiGet("organizationId", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String accountId, final java.lang.String organizationId) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.accountId = java.util.Objects.requireNonNull(accountId, "accountId is required");
            this.organizationId = organizationId;
        }

        @Override
        public java.lang.String getAccountId() {
            return this.accountId;
        }

        @Override
        public java.lang.String getOrganizationId() {
            return this.organizationId;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("accountId", om.valueToTree(this.getAccountId()));
            if (this.getOrganizationId() != null) {
                data.set("organizationId", om.valueToTree(this.getOrganizationId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-lambda.LayerVersionPermission"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LayerVersionPermission.Jsii$Proxy that = (LayerVersionPermission.Jsii$Proxy) o;

            if (!accountId.equals(that.accountId)) return false;
            return this.organizationId != null ? this.organizationId.equals(that.organizationId) : that.organizationId == null;
        }

        @Override
        public int hashCode() {
            int result = this.accountId.hashCode();
            result = 31 * result + (this.organizationId != null ? this.organizationId.hashCode() : 0);
            return result;
        }
    }
}
