package software.amazon.awscdk.services.lambda.eventsources;

/**
 * Use an Amazon SQS queue as an event source for AWS Lambda.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:27.894Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.lambda.eventsources.$Module.class, fqn = "@aws-cdk/aws-lambda-event-sources.SqsEventSource")
public class SqsEventSource extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.lambda.IEventSource {

    protected SqsEventSource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected SqsEventSource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param queue This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required"), props });
    }

    /**
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public SqsEventSource(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue queue) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     * <p>
     * @param target This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction target) {
        this.jsiiCall("bind", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(target, "target is required") });
    }

    /**
     * The identifier for this EventSourceMapping.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getEventSourceMappingId() {
        return this.jsiiGet("eventSourceMappingId", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.sqs.IQueue getQueue() {
        return this.jsiiGet("queue", software.amazon.awscdk.services.sqs.IQueue.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.lambda.eventsources.SqsEventSource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.lambda.eventsources.SqsEventSource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param queue This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.services.sqs.IQueue queue) {
            return new Builder(queue);
        }

        private final software.amazon.awscdk.services.sqs.IQueue queue;
        private software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder props;

        private Builder(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.queue = queue;
        }

        /**
         * The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function.
         * <p>
         * Your function receives an
         * event with all the retrieved records.
         * <p>
         * Valid Range: Minimum value of 1. Maximum value of 10.
         * <p>
         * Default: 10
         * <p>
         * @return {@code this}
         * @param batchSize The largest number of records that AWS Lambda will retrieve from your event source at the time of invoking your function. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder batchSize(final java.lang.Number batchSize) {
            this.props().batchSize(batchSize);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.lambda.eventsources.SqsEventSource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.lambda.eventsources.SqsEventSource build() {
            return new software.amazon.awscdk.services.lambda.eventsources.SqsEventSource(
                this.queue,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.lambda.eventsources.SqsEventSourceProps.Builder();
            }
            return this.props;
        }
    }
}
