/**
 * <h1>AWS CodeStarNotifications Construct Library</h1>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * This module is part of the <a href="https://github.com/aws/aws-cdk">AWS Cloud Development Kit</a> project.
 * <p>
 * <h2>NotificationRule</h2>
 * <p>
 * The <code>NotificationRule</code> construct defines an AWS CodeStarNotifications rule.
 * The rule specifies the events you want notifications about and the targets
 * (such as Amazon SNS topics or AWS Chatbot clients configured for Slack)
 * where you want to receive them.
 * Notification targets are objects that implement the <code>INotificationRuleTarget</code>
 * interface and notification source is object that implement the <code>INotificationRuleSource</code> interface.
 * <p>
 * <h2>Notification Targets</h2>
 * <p>
 * This module includes classes that implement the <code>INotificationRuleTarget</code> interface for SNS and slack in AWS Chatbot.
 * <p>
 * The following targets are supported:
 * <p>
 * <ul>
 * <li><code>SNS</code>: specify event and notify to SNS topic.</li>
 * <li><code>AWS Chatbot</code>: specify event and notify to slack channel and only support <code>SlackChannelConfiguration</code>.</li>
 * </ul>
 * <p>
 * <h2>Examples</h2>
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.codestarnotifications.*;
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.sns.*;
 * import software.amazon.awscdk.services.chatbot.*;
 * 
 * 
 * PipelineProject project = new PipelineProject(this, "MyProject");
 * 
 * Topic topic = new Topic(this, "MyTopic1");
 * 
 * SlackChannelConfiguration slack = SlackChannelConfiguration.Builder.create(this, "MySlackChannel")
 *         .slackChannelConfigurationName("YOUR_CHANNEL_NAME")
 *         .slackWorkspaceId("YOUR_SLACK_WORKSPACE_ID")
 *         .slackChannelId("YOUR_SLACK_CHANNEL_ID")
 *         .build();
 * 
 * NotificationRule rule = NotificationRule.Builder.create(this, "NotificationRule")
 *         .source(project)
 *         .events(List.of("codebuild-project-build-state-succeeded", "codebuild-project-build-state-failed"))
 *         .targets(List.of(topic))
 *         .build();
 * rule.addTarget(slack);
 * </pre></blockquote>
 * <p>
 * <h2>Notification Source</h2>
 * <p>
 * This module includes classes that implement the <code>INotificationRuleSource</code> interface for AWS CodeBuild,
 * AWS CodePipeline and will support AWS CodeCommit, AWS CodeDeploy in future.
 * <p>
 * The following sources are supported:
 * <p>
 * <ul>
 * <li><code>AWS CodeBuild</code>: support codebuild project to trigger notification when event specified.</li>
 * <li><code>AWS CodePipeline</code>: support codepipeline to trigger notification when event specified.</li>
 * </ul>
 * <p>
 * <h2>Events</h2>
 * <p>
 * For the complete list of supported event types for CodeBuild and CodePipeline, see:
 * <p>
 * <ul>
 * <li><a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-buildproject">Events for notification rules on build projects</a>.</li>
 * <li><a href="https://docs.aws.amazon.com/dtconsole/latest/userguide/concepts.html#events-ref-pipeline">Events for notification rules on pipelines</a>.</li>
 * </ul>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.codestarnotifications;
