/**
 * <h2>AWS CodeBuild Construct Library</h2>
 * <p>
 * <!--BEGIN STABILITY BANNER-->---
 * <p>
 * <img alt="cfn-resources: Stable" src="https://img.shields.io/badge/cfn--resources-stable-success.svg?style=for-the-badge">
 * <p>
 * <img alt="cdk-constructs: Stable" src="https://img.shields.io/badge/cdk--constructs-stable-success.svg?style=for-the-badge">
 * <p>
 * <hr>
 * <p>
 * <!--END STABILITY BANNER-->
 * <p>
 * AWS CodeBuild is a fully managed continuous integration service that compiles
 * source code, runs tests, and produces software packages that are ready to
 * deploy. With CodeBuild, you don’t need to provision, manage, and scale your own
 * build servers. CodeBuild scales continuously and processes multiple builds
 * concurrently, so your builds are not left waiting in a queue. You can get
 * started quickly by using prepackaged build environments, or you can create
 * custom build environments that use your own build tools. With CodeBuild, you are
 * charged by the minute for the compute resources you use.
 * <p>
 * <h2>Installation</h2>
 * <p>
 * Install the module:
 * <p>
 * <blockquote><pre>
 * $ npm i &#64;aws-cdk/aws-codebuild
 * </pre></blockquote>
 * <p>
 * Import it into your code:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codebuild.*;
 * </pre></blockquote>
 * <p>
 * The <code>codebuild.Project</code> construct represents a build project resource. See the
 * reference documentation for a comprehensive list of initialization properties,
 * methods and attributes.
 * <p>
 * <h2>Source</h2>
 * <p>
 * Build projects are usually associated with a <em>source</em>, which is specified via
 * the <code>source</code> property which accepts a class that extends the <code>Source</code>
 * abstract base class.
 * The default is to have no source associated with the build project;
 * the <code>buildSpec</code> option is required in that case.
 * <p>
 * Here's a CodeBuild project with no source which simply prints <code>Hello, CodeBuild!</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * new Project(this, "MyProject", new ProjectProps()
 *         .buildSpec(codebuild.BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", asList("echo \"Hello, CodeBuild!\"")))))));
 * </pre></blockquote>
 * <p>
 * <h3><code>CodeCommitSource</code></h3>
 * <p>
 * Use an AWS CodeCommit repository as the source of this build:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.codecommit.*;
 * 
 * Repository repository = new Repository(this, "MyRepo", new RepositoryProps().repositoryName("foo"));
 * new Project(this, "MyFirstCodeCommitProject", new ProjectProps()
 *         .source(codebuild.Source.codeCommit(new CodeCommitSourceProps().repository(repository))));
 * </pre></blockquote>
 * <p>
 * <h3><code>S3Source</code></h3>
 * <p>
 * Create a CodeBuild project with an S3 bucket as the source:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * import software.amazon.awscdk.services.codebuild.*;
 * import software.amazon.awscdk.services.s3.*;
 * 
 * Bucket bucket = new Bucket(this, "MyBucket");
 * new Project(this, "MyProject", new ProjectProps()
 *         .source(codebuild.Source.s3(new S3SourceProps()
 *                 .bucket(bucket)
 *                 .path("path/to/file.zip"))));
 * </pre></blockquote>
 * <p>
 * <h3><code>GitHubSource</code> and <code>GitHubEnterpriseSource</code></h3>
 * <p>
 * These source types can be used to build code from a GitHub repository.
 * Example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var gitHubSource = codebuild.Source.gitHub(Map.of(
 *         "owner", "awslabs",
 *         "repo", "aws-cdk",
 *         "webhook", true, // optional, default: true if `webhookFilters` were provided, false otherwise
 *         "webhookFilters", asList(codebuild.FilterGroup.inEventOf(codebuild.EventAction.PUSH).andBranchIs("master"))));
 * </pre></blockquote>
 * <p>
 * To provide GitHub credentials, please either go to AWS CodeBuild Console to connect
 * or call <code>ImportSourceCredentials</code> to persist your personal access token.
 * Example:
 * <p>
 * <blockquote><pre>
 * aws codebuild import-source-credentials --server-type GITHUB --auth-type PERSONAL_ACCESS_TOKEN --token &lt;token_value&gt;
 * </pre></blockquote>
 * <p>
 * <h3><code>BitBucketSource</code></h3>
 * <p>
 * This source type can be used to build code from a BitBucket repository.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var bbSource = codebuild.Source.bitBucket(Map.of(
 *         "owner", "owner",
 *         "repo", "repo"));
 * </pre></blockquote>
 * <p>
 * <h2>Artifacts</h2>
 * <p>
 * CodeBuild Projects can produce Artifacts and upload them to S3. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var project = codebuild.Project(stack, "MyProject", Map.of(
 *         "buildSpec", codebuild.BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")),
 *         "artifacts", codebuild.Artifacts.s3(Map.of(
 *                 "bucket", bucket,
 *                 "includeBuildId", false,
 *                 "packageZip", true,
 *                 "path", "another/path",
 *                 "identifier", "AddArtifact1"))));
 * </pre></blockquote>
 * <p>
 * Because we've not set the <code>name</code> property, this example will set the
 * <code>overrideArtifactName</code> parameter, and produce an artifact named as defined in
 * the Buildspec file, uploaded to an S3 bucket (<code>bucket</code>). The path will be
 * <code>another/path</code> and the artifact will be a zipfile.
 * <p>
 * <h2>CodePipeline</h2>
 * <p>
 * To add a CodeBuild Project as an Action to CodePipeline,
 * use the <code>PipelineProject</code> class instead of <code>Project</code>.
 * It's a simple class that doesn't allow you to specify <code>sources</code>,
 * <code>secondarySources</code>, <code>artifacts</code> or <code>secondaryArtifacts</code>,
 * as these are handled by setting input and output CodePipeline <code>Artifact</code> instances on the Action,
 * instead of setting them on the Project.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var project = PipelineProject.Builder.create(this, "Project").build();
 * </pre></blockquote>
 * <p>
 * For more details, see the readme of the <code>&#64;aws-cdk/&#64;aws-codepipeline-actions</code> package.
 * <p>
 * <h2>Caching</h2>
 * <p>
 * You can save time when your project builds by using a cache. A cache can store reusable pieces of your build environment and use them across multiple builds. Your build project can use one of two types of caching: Amazon S3 or local. In general, S3 caching is a good option for small and intermediate build artifacts that are more expensive to build than to download. Local caching is a good option for large intermediate build artifacts because the cache is immediately available on the build host.
 * <p>
 * <h3>S3 Caching</h3>
 * <p>
 * With S3 caching, the cache is stored in an S3 bucket which is available from multiple hosts.
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Project.Builder.create(this, "Project")
 *         .source(codebuild.Source.bitBucket(Map.of(
 *                 "owner", "awslabs",
 *                 "repo", "aws-cdk")))
 *         .cache(codebuild.Cache.bucket(new Bucket(this, "Bucket")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Local Caching</h3>
 * <p>
 * With local caching, the cache is stored on the codebuild instance itself. This is simple,
 * cheap and fast, but CodeBuild cannot guarantee a reuse of instance and hence cannot
 * guarantee cache hits. For example, when a build starts and caches files locally, if two subsequent builds start at the same time afterwards only one of those builds would get the cache. Three different cache modes are supported, which can be turned on individually.
 * <p>
 * <ul>
 * <li><code>LocalCacheMode.SOURCE</code> caches Git metadata for primary and secondary sources.</li>
 * <li><code>LocalCacheMode.DOCKER_LAYER</code> caches existing Docker layers.</li>
 * <li><code>LocalCacheMode.CUSTOM</code> caches directories you specify in the buildspec file.</li>
 * </ul>
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Project.Builder.create(this, "Project")
 *         .source(codebuild.Source.gitHubEnterprise(Map.of(
 *                 "httpsCloneUrl", "https://my-github-enterprise.com/owner/repo")))
 * 
 *         // Enable Docker AND custom caching
 *         .cache(codebuild.Cache.local(LocalCacheMode.getDOCKER_LAYER(), LocalCacheMode.getCUSTOM()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Environment</h2>
 * <p>
 * By default, projects use a small instance with an Ubuntu 18.04 image. You
 * can use the <code>environment</code> property to customize the build environment:
 * <p>
 * <ul>
 * <li><code>buildImage</code> defines the Docker image used. See <a href="#images">Images</a> below for
 * details on how to define build images.</li>
 * <li><code>computeType</code> defines the instance type used for the build.</li>
 * <li><code>privileged</code> can be set to <code>true</code> to allow privileged access.</li>
 * <li><code>environmentVariables</code> can be set at this level (and also at the project
 * level).</li>
 * </ul>
 * <p>
 * <h2>Images</h2>
 * <p>
 * The CodeBuild library supports both Linux and Windows images via the
 * <code>LinuxBuildImage</code> and <code>WindowsBuildImage</code> classes, respectively.
 * <p>
 * You can specify one of the predefined Windows/Linux images by using one
 * of the constants such as <code>WindowsBuildImage.WIN_SERVER_CORE_2019_BASE</code>,
 * <code>WindowsBuildImage.WINDOWS_BASE_2_0</code> or <code>LinuxBuildImage.STANDARD_2_0</code>.
 * <p>
 * Alternatively, you can specify a custom image using one of the static methods on
 * <code>LinuxBuildImage</code>:
 * <p>
 * <ul>
 * <li><code>LinuxBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }])</code> to reference an image in any public or private Docker registry.</li>
 * <li><code>LinuxBuildImage.fromEcrRepository(repo[, tag])</code> to reference an image available in an
 * ECR repository.</li>
 * <li><code>LinuxBuildImage.fromAsset(parent, id, props)</code> to use an image created from a
 * local asset.</li>
 * <li><code>LinuxBuildImage.fromCodeBuildImageId(id)</code> to reference a pre-defined, CodeBuild-provided Docker image.</li>
 * </ul>
 * <p>
 * or one of the corresponding methods on <code>WindowsBuildImage</code>:
 * <p>
 * <ul>
 * <li><code>WindowsBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }, imageType])</code></li>
 * <li><code>WindowsBuildImage.fromEcrRepository(repo[, tag, imageType])</code></li>
 * <li><code>WindowsBuildImage.fromAsset(parent, id, props, [, imageType])</code></li>
 * </ul>
 * <p>
 * Note that the <code>WindowsBuildImage</code> version of the static methods accepts an optional parameter of type <code>WindowsImageType</code>,
 * which can be either <code>WindowsImageType.STANDARD</code>, the default, or <code>WindowsImageType.SERVER_2019</code>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Project.Builder.create(this, "Project")
 *         .environment(Map.of(
 *                 "buildImage", codebuild.WindowsBuildImage.fromEcrRepository(ecrRepository, "v1.0", codebuild.WindowsImageType.getSERVER_2019())))...
 *         .build();
 * </pre></blockquote>
 * <p>
 * The following example shows how to define an image from a Docker asset:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * .environment(new BuildEnvironment()
 *         .buildImage(codebuild.LinuxBuildImage.fromAsset(this, "MyImage", new DockerImageAssetProps()
 *                 .directory(path.join(__dirname, "demo-image"))))));
 * </pre></blockquote>
 * <p>
 * The following example shows how to define an image from an ECR repository:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * .environment(new BuildEnvironment()
 *         .buildImage(codebuild.LinuxBuildImage.fromEcrRepository(ecrRepository, "v1.0"))));
 * </pre></blockquote>
 * <p>
 * The following example shows how to define an image from a private docker registry:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated. See https://github.com/aws/jsii/issues/826
 * .environment(new BuildEnvironment()
 *         .buildImage(codebuild.LinuxBuildImage.fromDockerRegistry("my-registry/my-repo", new DockerImageOptions()
 *                 .secretsManagerCredentials(secrets)))));
 * </pre></blockquote>
 * <p>
 * <h3>GPU images</h3>
 * <p>
 * The class <code>LinuxGpuBuildImage</code> contains constants for working with
 * <a href="https://aws.amazon.com/releasenotes/available-deep-learning-containers-images">AWS Deep Learning Container images</a>:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Project.Builder.create(this, "Project")
 *         .environment(Map.of(
 *                 "buildImage", codebuild.LinuxGpuBuildImage.getDLC_TENSORFLOW_2_1_0_INFERENCE()))...
 *         .build();
 * </pre></blockquote>
 * <p>
 * One complication is that the repositories for the DLC images are in
 * different accounts in different AWS regions.
 * In most cases, the CDK will handle providing the correct account for you;
 * in rare cases (for example, deploying to new regions)
 * where our information might be out of date,
 * you can always specify the account
 * (along with the repository name and tag)
 * explicitly using the <code>awsDeepLearningContainersImage</code> method:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Project.Builder.create(this, "Project")
 *         .environment(Map.of(
 *                 "buildImage", codebuild.LinuxGpuBuildImage.awsDeepLearningContainersImage("tensorflow-inference", "2.1.0-gpu-py36-cu101-ubuntu18.04", "123456789012")))...
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h2>Credentials</h2>
 * <p>
 * CodeBuild allows you to store credentials used when communicating with various sources,
 * like GitHub:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * GitHubSourceCredentials.Builder.create(this, "CodeBuildGitHubCreds")
 *         .accessToken(cdk.SecretValue.secretsManager("my-token"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * and BitBucket:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * BitBucketSourceCredentials.Builder.create(this, "CodeBuildBitBucketCreds")
 *         .username(cdk.SecretValue.secretsManager("my-bitbucket-creds", Map.of("jsonField", "username")))
 *         .password(cdk.SecretValue.secretsManager("my-bitbucket-creds", Map.of("jsonField", "password")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <strong>Note</strong>: the credentials are global to a given account in a given region -
 * they are not defined per CodeBuild project.
 * CodeBuild only allows storing a single credential of a given type
 * (GitHub, GitHub Enterprise or BitBucket)
 * in a given account in a given region -
 * any attempt to save more than one will result in an error.
 * You can use the <a href="https://docs.aws.amazon.com/cli/latest/reference/codebuild/list-source-credentials.html"><code>list-source-credentials</code> AWS CLI operation</a>
 * to inspect what credentials are stored in your account.
 * <p>
 * <h2>Test reports</h2>
 * <p>
 * You can specify a test report in your buildspec:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var project = Project.Builder.create(this, "Project")
 *         .buildSpec(codebuild.BuildSpec.fromObject(Map.of(
 *                 // ...
 *                 "reports", Map.of(
 *                         "myReport", Map.of(
 *                                 "files", "**{@literal /}*",
 *                                 "base-directory", "build/test-results")))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * This will create a new test report group,
 * with the name <code>&lt;ProjectName&gt;-myReport</code>.
 * <p>
 * The project's role in the CDK will always be granted permissions to create and use report groups
 * with names starting with the project's name;
 * if you'd rather not have those permissions added,
 * you can opt out of it when creating the project:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var project = Project.Builder.create(this, "Project")
 *         // ...
 *         .grantReportGroupPermissions(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * Alternatively, you can specify an ARN of an existing resource group,
 * instead of a simple name, in your buildspec:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // create a new ReportGroup
 * var reportGroup = new ReportGroup(this, "ReportGroup");
 * 
 * var project = Project.Builder.create(this, "Project")
 *         .buildSpec(codebuild.BuildSpec.fromObject(Map.of(
 *                 // ...
 *                 "reports", Map.of(
 *                         [reportGroup.reportGroupArn], Map.of(
 *                                 "files", "**{@literal /}*",
 *                                 "base-directory", "build/test-results")))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * If you do that, you need to grant the project's role permissions to write reports to that report group:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * reportGroup.grantWrite(project);
 * </pre></blockquote>
 * <p>
 * For more information on the test reports feature,
 * see the <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/test-reporting.html">AWS CodeBuild documentation</a>.
 * <p>
 * <h2>Events</h2>
 * <p>
 * CodeBuild projects can be used either as a source for events or be triggered
 * by events via an event rule.
 * <p>
 * <h3>Using Project as an event target</h3>
 * <p>
 * The <code>&#64;aws-cdk/aws-events-targets.CodeBuildProject</code> allows using an AWS CodeBuild
 * project as a AWS CloudWatch event rule target:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * // start build when a commit is pushed
 * import software.amazon.awscdk.services.events.targets.*;
 * 
 * codeCommitRepository.onCommit("OnCommit", Map.of(
 *         "target", new CodeBuildProject(project)));
 * </pre></blockquote>
 * <p>
 * <h3>Using Project as an event source</h3>
 * <p>
 * To define Amazon CloudWatch event rules for build projects, use one of the <code>onXxx</code>
 * methods:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var rule = project.onStateChange("BuildStateChange", Map.of(
 *         "target", new LambdaFunction(fn)));
 * </pre></blockquote>
 * <p>
 * <h2>Secondary sources and artifacts</h2>
 * <p>
 * CodeBuild Projects can get their sources from multiple places, and produce
 * multiple outputs. For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var project = Project.Builder.create(this, "MyProject")
 *         .secondarySources(asList(codebuild.Source.codeCommit(Map.of(
 *                 "identifier", "source2",
 *                 "repository", repo))))
 *         .secondaryArtifacts(asList(codebuild.Artifacts.s3(Map.of(
 *                 "identifier", "artifact2",
 *                 "bucket", bucket,
 *                 "path", "some/path",
 *                 "name", "file.zip"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Note that the <code>identifier</code> property is required for both secondary sources and
 * artifacts.
 * <p>
 * The contents of the secondary source is available to the build under the
 * directory specified by the <code>CODEBUILD_SRC_DIR_&lt;identifier&gt;</code> environment variable
 * (so, <code>CODEBUILD_SRC_DIR_source2</code> in the above case).
 * <p>
 * The secondary artifacts have their own section in the buildspec, under the
 * regular <code>artifacts</code> one. Each secondary artifact has its own section, beginning
 * with their identifier.
 * <p>
 * So, a buildspec for the above Project could look something like this:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var project = Project.Builder.create(this, "MyProject")
 *         // secondary sources and artifacts as above...
 *         .buildSpec(codebuild.BuildSpec.fromObject(Map.of(
 *                 "version", "0.2",
 *                 "phases", Map.of(
 *                         "build", Map.of(
 *                                 "commands", asList("cd $CODEBUILD_SRC_DIR_source2", "touch output2.txt"))),
 *                 "artifacts", Map.of(
 *                         "secondary-artifacts", Map.of(
 *                                 "artifact2", Map.of(
 *                                         "base-directory", "$CODEBUILD_SRC_DIR_source2",
 *                                         "files", asList("output2.txt")))))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * <h3>Definition of VPC configuration in CodeBuild Project</h3>
 * <p>
 * Typically, resources in an VPC are not accessible by AWS CodeBuild. To enable
 * access, you must provide additional VPC-specific configuration information as
 * part of your CodeBuild project configuration. This includes the VPC ID, the
 * VPC subnet IDs, and the VPC security group IDs. VPC-enabled builds are then
 * able to access resources inside your VPC.
 * <p>
 * For further Information see https://docs.aws.amazon.com/codebuild/latest/userguide/vpc-support.html
 * <p>
 * <strong>Use Cases</strong>
 * VPC connectivity from AWS CodeBuild builds makes it possible to:
 * <p>
 * <ul>
 * <li>Run integration tests from your build against data in an Amazon RDS database that's isolated on a private subnet.</li>
 * <li>Query data in an Amazon ElastiCache cluster directly from tests.</li>
 * <li>Interact with internal web services hosted on Amazon EC2, Amazon ECS, or services that use internal Elastic Load Balancing.</li>
 * <li>Retrieve dependencies from self-hosted, internal artifact repositories, such as PyPI for Python, Maven for Java, and npm for Node.js.</li>
 * <li>Access objects in an Amazon S3 bucket configured to allow access through an Amazon VPC endpoint only.</li>
 * <li>Query external web services that require fixed IP addresses through the Elastic IP address of the NAT gateway or NAT instance associated with your subnet(s).</li>
 * </ul>
 * <p>
 * Your builds can access any resource that's hosted in your VPC.
 * <p>
 * <strong>Enable Amazon VPC Access in your CodeBuild Projects</strong>
 * <p>
 * Pass the VPC when defining your Project, then make sure to
 * give the CodeBuild's security group the right permissions
 * to access the resources that it needs by using the
 * <code>connections</code> object.
 * <p>
 * For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * var vpc = new Vpc(this, "MyVPC");
 * var project = Project.Builder.create(this, "MyProject")
 *         .vpc(vpc)
 *         .buildSpec(codebuild.BuildSpec.fromObject(Map.of()))
 *         .build();
 * 
 * project.connections.allowTo(loadBalancer, ec2.Port.tcp(443));
 * </pre></blockquote>
 * <p>
 * <h2>Project File System Location EFS</h2>
 * <p>
 * Add support for CodeBuild to build on AWS EFS file system mounts using
 * the new ProjectFileSystemLocation.
 * The <code>fileSystemLocations</code> property which accepts a list <code>ProjectFileSystemLocation</code>
 * as represented by the interface <code>IFileSystemLocations</code>.
 * The only supported file system type is <code>EFS</code>.
 * <p>
 * For example:
 * <p>
 * <blockquote><pre>
 * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
 * Project.Builder.create(stack, "MyProject")
 *         .buildSpec(codebuild.BuildSpec.fromObject(Map.of(
 *                 "version", "0.2")))
 *         .fileSystemLocations(asList(codebuild.FileSystemLocation.efs(Map.of(
 *                 "identifier", "myidentifier2",
 *                 "location", "myclodation.mydnsroot.com:/loc",
 *                 "mountPoint", "/media",
 *                 "mountOptions", "opts"))))
 *         .build();
 * </pre></blockquote>
 * <p>
 * Here's a CodeBuild project with a simple example that creates a project mounted on AWS EFS:
 * <p>
 * <a href="./test/integ.project-file-system-location.ts">Minimal Example</a>
 */
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
package software.amazon.awscdk.services.codebuild;
