package software.amazon.awscdk.services.codebuild;

/**
 * A CodeBuild image running Windows.
 * <p>
 * This class has a bunch of public constants that represent the most popular images.
 * <p>
 * You can also specify a custom image using one of the static methods:
 * <p>
 * <ul>
 * <li>WindowsBuildImage.fromDockerRegistry(image[, { secretsManagerCredentials }, imageType])</li>
 * <li>WindowsBuildImage.fromEcrRepository(repo[, tag, imageType])</li>
 * <li>WindowsBuildImage.fromAsset(parent, id, props, [, imageType])</li>
 * </ul>
 * <p>
 * @see https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-available.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.930Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.WindowsBuildImage")
public class WindowsBuildImage extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.codebuild.IBuildImage {

    protected WindowsBuildImage(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected WindowsBuildImage(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        WIN_SERVER_CORE_2016_BASE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "WIN_SERVER_CORE_2016_BASE", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        WIN_SERVER_CORE_2019_BASE = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "WIN_SERVER_CORE_2019_BASE", software.amazon.awscdk.services.codebuild.IBuildImage.class);
        WINDOWS_BASE_2_0 = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "WINDOWS_BASE_2_0", software.amazon.awscdk.services.codebuild.IBuildImage.class);
    }

    /**
     * Uses an Docker image asset as a Windows build image.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     * @param imageType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.WindowsImageType imageType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromAsset", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required"), imageType });
    }

    /**
     * Uses an Docker image asset as a Windows build image.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromAsset(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.assets.DockerImageAssetProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromAsset", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * @return a Windows build image from a Docker Hub image.
     * @param name This parameter is required.
     * @param options
     * @param imageType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.DockerImageOptions options, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.WindowsImageType imageType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromDockerRegistry", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), options, imageType });
    }

    /**
     * @return a Windows build image from a Docker Hub image.
     * @param name This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.DockerImageOptions options) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromDockerRegistry", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required"), options });
    }

    /**
     * @return a Windows build image from a Docker Hub image.
     * @param name This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromDockerRegistry(final @org.jetbrains.annotations.NotNull java.lang.String name) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromDockerRegistry", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(name, "name is required") });
    }

    /**
     * @return A Linux build image from an ECR repository.
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html
     * @param repository The ECR repository. This parameter is required.
     * @param tag Image tag (default "latest").
     * @param imageType
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tag, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.WindowsImageType imageType) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromEcrRepository", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tag, imageType });
    }

    /**
     * @return A Linux build image from an ECR repository.
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html
     * @param repository The ECR repository. This parameter is required.
     * @param tag Image tag (default "latest").
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository, final @org.jetbrains.annotations.Nullable java.lang.String tag) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromEcrRepository", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(repository, "repository is required"), tag });
    }

    /**
     * @return A Linux build image from an ECR repository.
     * NOTE: if the repository is external (i.e. imported), then we won't be able to add
     * a resource policy statement for it so CodeBuild can pull the image.
     * @see https://docs.aws.amazon.com/codebuild/latest/userguide/sample-ecr.html
     * @param repository The ECR repository. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IBuildImage fromEcrRepository(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecr.IRepository repository) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.WindowsBuildImage.class, "fromEcrRepository", software.amazon.awscdk.services.codebuild.IBuildImage.class, new Object[] { java.util.Objects.requireNonNull(repository, "repository is required") });
    }

    /**
     * Make a buildspec to run the indicated script.
     * <p>
     * @param entrypoint This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildSpec runScriptBuildspec(final @org.jetbrains.annotations.NotNull java.lang.String entrypoint) {
        return this.jsiiCall("runScriptBuildspec", software.amazon.awscdk.services.codebuild.BuildSpec.class, new Object[] { java.util.Objects.requireNonNull(entrypoint, "entrypoint is required") });
    }

    /**
     * Allows the image a chance to validate whether the passed configuration is correct.
     * <p>
     * @param buildEnvironment This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> validate(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.BuildEnvironment buildEnvironment) {
        return java.util.Collections.unmodifiableList(this.jsiiCall("validate", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)), new Object[] { java.util.Objects.requireNonNull(buildEnvironment, "buildEnvironment is required") }));
    }

    /**
     * Corresponds to the standard CodeBuild image `aws/codebuild/windows-base:1.0`.
     * <p>
     * @deprecated `WindowsBuildImage.WINDOWS_BASE_2_0` should be used instead.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public final static software.amazon.awscdk.services.codebuild.IBuildImage WIN_SERVER_CORE_2016_BASE;

    /**
     * The standard CodeBuild image `aws/codebuild/windows-base:2019-1.0`, which is based off Windows Server Core 2019.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage WIN_SERVER_CORE_2019_BASE;

    /**
     * The standard CodeBuild image `aws/codebuild/windows-base:2.0`, which is based off Windows Server Core 2016.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static software.amazon.awscdk.services.codebuild.IBuildImage WINDOWS_BASE_2_0;

    /**
     * The default {@link ComputeType} to use with this image, if one was not specified in {@link BuildEnvironment#computeType} explicitly.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.ComputeType getDefaultComputeType() {
        return this.jsiiGet("defaultComputeType", software.amazon.awscdk.services.codebuild.ComputeType.class);
    }

    /**
     * The Docker image identifier that the build environment uses.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getImageId() {
        return this.jsiiGet("imageId", java.lang.String.class);
    }

    /**
     * The type of build environment.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * The type of principal that CodeBuild will use to pull this build Docker image.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ImagePullPrincipalType getImagePullPrincipalType() {
        return this.jsiiGet("imagePullPrincipalType", software.amazon.awscdk.services.codebuild.ImagePullPrincipalType.class);
    }

    /**
     * An optional ECR repository that the image is hosted in.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecr.IRepository getRepository() {
        return this.jsiiGet("repository", software.amazon.awscdk.services.ecr.IRepository.class);
    }

    /**
     * The secretsManagerCredentials for access to a private registry.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.secretsmanager.ISecret getSecretsManagerCredentials() {
        return this.jsiiGet("secretsManagerCredentials", software.amazon.awscdk.services.secretsmanager.ISecret.class);
    }
}
