package software.amazon.awscdk.services.codebuild;

/**
 * The ReportGroup resource class.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:32.928Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.ReportGroup")
public class ReportGroup extends software.amazon.awscdk.core.Resource implements software.amazon.awscdk.services.codebuild.IReportGroup {

    protected ReportGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected ReportGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ReportGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.codebuild.ReportGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public ReportGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Reference an existing ReportGroup, defined outside of the CDK code, by name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param reportGroupName This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.IReportGroup fromReportGroupName(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String reportGroupName) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.codebuild.ReportGroup.class, "fromReportGroupName", software.amazon.awscdk.services.codebuild.IReportGroup.class, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(reportGroupName, "reportGroupName is required") });
    }

    /**
     * Grants the given entity permissions to write (that is, upload reports to) this report group.
     * <p>
     * @param identity This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantWrite(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity) {
        return this.jsiiCall("grantWrite", software.amazon.awscdk.services.iam.Grant.class, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required") });
    }

    /**
     * The ARN of the ReportGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReportGroupArn() {
        return this.jsiiGet("reportGroupArn", java.lang.String.class);
    }

    /**
     * The name of the ReportGroup.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getReportGroupName() {
        return this.jsiiGet("reportGroupName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.s3.IBucket getExportBucket() {
        return this.jsiiGet("exportBucket", software.amazon.awscdk.services.s3.IBucket.class);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.ReportGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.ReportGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * An optional S3 bucket to export the reports to.
         * <p>
         * Default: - the reports will not be exported
         * <p>
         * @return {@code this}
         * @param exportBucket An optional S3 bucket to export the reports to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportBucket(final software.amazon.awscdk.services.s3.IBucket exportBucket) {
            this.props().exportBucket(exportBucket);
            return this;
        }

        /**
         * What to do when this resource is deleted from a stack.
         * <p>
         * As CodeBuild does not allow deleting a ResourceGroup that has reports inside of it,
         * this is set to retain the resource by default.
         * <p>
         * Default: RemovalPolicy.RETAIN
         * <p>
         * @return {@code this}
         * @param removalPolicy What to do when this resource is deleted from a stack. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(final software.amazon.awscdk.core.RemovalPolicy removalPolicy) {
            this.props().removalPolicy(removalPolicy);
            return this;
        }

        /**
         * The physical name of the report group.
         * <p>
         * Default: - CloudFormation-generated name
         * <p>
         * @return {@code this}
         * @param reportGroupName The physical name of the report group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reportGroupName(final java.lang.String reportGroupName) {
            this.props().reportGroupName(reportGroupName);
            return this;
        }

        /**
         * Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export.
         * <p>
         * Ignored if {&#64;link exportBucket} has not been provided.
         * <p>
         * Default: - false (the files will not be ZIPped)
         * <p>
         * @return {@code this}
         * @param zipExport Whether to output the report files into the export bucket as-is, or create a ZIP from them before doing the export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder zipExport(final java.lang.Boolean zipExport) {
            this.props().zipExport(zipExport);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codebuild.ReportGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.ReportGroup build() {
            return new software.amazon.awscdk.services.codebuild.ReportGroup(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.codebuild.ReportGroupProps.Builder();
            }
            return this.props;
        }
    }
}
