package software.amazon.awscdk.services.codebuild;

/**
 * Construction properties for {@link CodeCommitSource}.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:29.409Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CodeCommitSourceProps")
@software.amazon.jsii.Jsii.Proxy(CodeCommitSourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CodeCommitSourceProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.codebuild.SourceProps {

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codecommit.IRepository getRepository();

    /**
     * The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
     * <p>
     * Default: the default branch's HEAD commit ID is used
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>{@code
     * // Example automatically generated without compilation. See https://github.com/aws/jsii/issues/826
     * "mybranch";}</pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getBranchOrRef() {
        return null;
    }

    /**
     * The depth of history to download.
     * <p>
     * Minimum value is 0.
     * If this value is 0, greater than 25, or not provided,
     * then the full history is downloaded with each build of the project.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getCloneDepth() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CodeCommitSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CodeCommitSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CodeCommitSourceProps> {
        private software.amazon.awscdk.services.codecommit.IRepository repository;
        private java.lang.String branchOrRef;
        private java.lang.Number cloneDepth;
        private java.lang.String identifier;

        /**
         * Sets the value of {@link CodeCommitSourceProps#getRepository}
         * @param repository the value to be set. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder repository(software.amazon.awscdk.services.codecommit.IRepository repository) {
            this.repository = repository;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceProps#getBranchOrRef}
         * @param branchOrRef The commit ID, pull request ID, branch name, or tag name that corresponds to the version of the source code you want to build.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder branchOrRef(java.lang.String branchOrRef) {
            this.branchOrRef = branchOrRef;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceProps#getCloneDepth}
         * @param cloneDepth The depth of history to download.
         *                   Minimum value is 0.
         *                   If this value is 0, greater than 25, or not provided,
         *                   then the full history is downloaded with each build of the project.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloneDepth(java.lang.Number cloneDepth) {
            this.cloneDepth = cloneDepth;
            return this;
        }

        /**
         * Sets the value of {@link CodeCommitSourceProps#getIdentifier}
         * @param identifier The source identifier.
         *                   This property is required on secondary sources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identifier(java.lang.String identifier) {
            this.identifier = identifier;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CodeCommitSourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CodeCommitSourceProps build() {
            return new Jsii$Proxy(repository, branchOrRef, cloneDepth, identifier);
        }
    }

    /**
     * An implementation for {@link CodeCommitSourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CodeCommitSourceProps {
        private final software.amazon.awscdk.services.codecommit.IRepository repository;
        private final java.lang.String branchOrRef;
        private final java.lang.Number cloneDepth;
        private final java.lang.String identifier;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.repository = this.jsiiGet("repository", software.amazon.awscdk.services.codecommit.IRepository.class);
            this.branchOrRef = this.jsiiGet("branchOrRef", java.lang.String.class);
            this.cloneDepth = this.jsiiGet("cloneDepth", java.lang.Number.class);
            this.identifier = this.jsiiGet("identifier", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final software.amazon.awscdk.services.codecommit.IRepository repository, final java.lang.String branchOrRef, final java.lang.Number cloneDepth, final java.lang.String identifier) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.repository = java.util.Objects.requireNonNull(repository, "repository is required");
            this.branchOrRef = branchOrRef;
            this.cloneDepth = cloneDepth;
            this.identifier = identifier;
        }

        @Override
        public software.amazon.awscdk.services.codecommit.IRepository getRepository() {
            return this.repository;
        }

        @Override
        public java.lang.String getBranchOrRef() {
            return this.branchOrRef;
        }

        @Override
        public java.lang.Number getCloneDepth() {
            return this.cloneDepth;
        }

        @Override
        public java.lang.String getIdentifier() {
            return this.identifier;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("repository", om.valueToTree(this.getRepository()));
            if (this.getBranchOrRef() != null) {
                data.set("branchOrRef", om.valueToTree(this.getBranchOrRef()));
            }
            if (this.getCloneDepth() != null) {
                data.set("cloneDepth", om.valueToTree(this.getCloneDepth()));
            }
            if (this.getIdentifier() != null) {
                data.set("identifier", om.valueToTree(this.getIdentifier()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CodeCommitSourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CodeCommitSourceProps.Jsii$Proxy that = (CodeCommitSourceProps.Jsii$Proxy) o;

            if (!repository.equals(that.repository)) return false;
            if (this.branchOrRef != null ? !this.branchOrRef.equals(that.branchOrRef) : that.branchOrRef != null) return false;
            if (this.cloneDepth != null ? !this.cloneDepth.equals(that.cloneDepth) : that.cloneDepth != null) return false;
            return this.identifier != null ? this.identifier.equals(that.identifier) : that.identifier == null;
        }

        @Override
        public int hashCode() {
            int result = this.repository.hashCode();
            result = 31 * result + (this.branchOrRef != null ? this.branchOrRef.hashCode() : 0);
            result = 31 * result + (this.cloneDepth != null ? this.cloneDepth.hashCode() : 0);
            result = 31 * result + (this.identifier != null ? this.identifier.hashCode() : 0);
            return result;
        }
    }
}
