package software.amazon.awscdk.services.codebuild;

/**
 * A CloudFormation `AWS::CodeBuild::ReportGroup`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:29.408Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnReportGroup")
public class CfnReportGroup extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnReportGroup(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnReportGroup(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.codebuild.CfnReportGroup.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CodeBuild::ReportGroup`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnReportGroup(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnReportGroupProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return this.jsiiGet("attrArn", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CodeBuild::ReportGroup.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::CodeBuild::ReportGroup.ExportConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getExportConfig() {
        return this.jsiiGet("exportConfig", java.lang.Object.class);
    }

    /**
     * `AWS::CodeBuild::ReportGroup.ExportConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExportConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("exportConfig", java.util.Objects.requireNonNull(value, "exportConfig is required"));
    }

    /**
     * `AWS::CodeBuild::ReportGroup.ExportConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExportConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codebuild.CfnReportGroup.ReportExportConfigProperty value) {
        this.jsiiSet("exportConfig", java.util.Objects.requireNonNull(value, "exportConfig is required"));
    }

    /**
     * `AWS::CodeBuild::ReportGroup.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getType() {
        return this.jsiiGet("type", java.lang.String.class);
    }

    /**
     * `AWS::CodeBuild::ReportGroup.Type`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        this.jsiiSet("type", java.util.Objects.requireNonNull(value, "type is required"));
    }

    /**
     * `AWS::CodeBuild::ReportGroup.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return this.jsiiGet("name", java.lang.String.class);
    }

    /**
     * `AWS::CodeBuild::ReportGroup.Name`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        this.jsiiSet("name", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnReportGroup.ReportExportConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ReportExportConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ReportExportConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnReportGroup.ReportExportConfigProperty.ExportConfigType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-exportconfigtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExportConfigType();

        /**
         * `CfnReportGroup.ReportExportConfigProperty.S3Destination`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-reportexportconfig.html#cfn-codebuild-reportgroup-reportexportconfig-s3destination
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3Destination() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ReportExportConfigProperty> {
            private java.lang.String exportConfigType;
            private java.lang.Object s3Destination;

            /**
             * Sets the value of {@link ReportExportConfigProperty#getExportConfigType}
             * @param exportConfigType `CfnReportGroup.ReportExportConfigProperty.ExportConfigType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder exportConfigType(java.lang.String exportConfigType) {
                this.exportConfigType = exportConfigType;
                return this;
            }

            /**
             * Sets the value of {@link ReportExportConfigProperty#getS3Destination}
             * @param s3Destination `CfnReportGroup.ReportExportConfigProperty.S3Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Destination(software.amazon.awscdk.core.IResolvable s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            /**
             * Sets the value of {@link ReportExportConfigProperty#getS3Destination}
             * @param s3Destination `CfnReportGroup.ReportExportConfigProperty.S3Destination`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3Destination(software.amazon.awscdk.services.codebuild.CfnReportGroup.S3ReportExportConfigProperty s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ReportExportConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ReportExportConfigProperty build() {
                return new Jsii$Proxy(exportConfigType, s3Destination);
            }
        }

        /**
         * An implementation for {@link ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ReportExportConfigProperty {
            private final java.lang.String exportConfigType;
            private final java.lang.Object s3Destination;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.exportConfigType = this.jsiiGet("exportConfigType", java.lang.String.class);
                this.s3Destination = this.jsiiGet("s3Destination", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String exportConfigType, final java.lang.Object s3Destination) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.exportConfigType = java.util.Objects.requireNonNull(exportConfigType, "exportConfigType is required");
                this.s3Destination = s3Destination;
            }

            @Override
            public java.lang.String getExportConfigType() {
                return this.exportConfigType;
            }

            @Override
            public java.lang.Object getS3Destination() {
                return this.s3Destination;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("exportConfigType", om.valueToTree(this.getExportConfigType()));
                if (this.getS3Destination() != null) {
                    data.set("s3Destination", om.valueToTree(this.getS3Destination()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnReportGroup.ReportExportConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ReportExportConfigProperty.Jsii$Proxy that = (ReportExportConfigProperty.Jsii$Proxy) o;

                if (!exportConfigType.equals(that.exportConfigType)) return false;
                return this.s3Destination != null ? this.s3Destination.equals(that.s3Destination) : that.s3Destination == null;
            }

            @Override
            public int hashCode() {
                int result = this.exportConfigType.hashCode();
                result = 31 * result + (this.s3Destination != null ? this.s3Destination.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.codebuild.$Module.class, fqn = "@aws-cdk/aws-codebuild.CfnReportGroup.S3ReportExportConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3ReportExportConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3ReportExportConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Bucket`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.EncryptionDisabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptiondisabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getEncryptionDisabled() {
            return null;
        }

        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.EncryptionKey`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-encryptionkey
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKey() {
            return null;
        }

        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Packaging`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-packaging
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPackaging() {
            return null;
        }

        /**
         * `CfnReportGroup.S3ReportExportConfigProperty.Path`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-codebuild-reportgroup-s3reportexportconfig.html#cfn-codebuild-reportgroup-s3reportexportconfig-path
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3ReportExportConfigProperty> {
            private java.lang.String bucket;
            private java.lang.Object encryptionDisabled;
            private java.lang.String encryptionKey;
            private java.lang.String packaging;
            private java.lang.String path;

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getBucket}
             * @param bucket `CfnReportGroup.S3ReportExportConfigProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled `CfnReportGroup.S3ReportExportConfigProperty.EncryptionDisabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(java.lang.Boolean encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getEncryptionDisabled}
             * @param encryptionDisabled `CfnReportGroup.S3ReportExportConfigProperty.EncryptionDisabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionDisabled(software.amazon.awscdk.core.IResolvable encryptionDisabled) {
                this.encryptionDisabled = encryptionDisabled;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getEncryptionKey}
             * @param encryptionKey `CfnReportGroup.S3ReportExportConfigProperty.EncryptionKey`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder encryptionKey(java.lang.String encryptionKey) {
                this.encryptionKey = encryptionKey;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getPackaging}
             * @param packaging `CfnReportGroup.S3ReportExportConfigProperty.Packaging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder packaging(java.lang.String packaging) {
                this.packaging = packaging;
                return this;
            }

            /**
             * Sets the value of {@link S3ReportExportConfigProperty#getPath}
             * @param path `CfnReportGroup.S3ReportExportConfigProperty.Path`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder path(java.lang.String path) {
                this.path = path;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3ReportExportConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3ReportExportConfigProperty build() {
                return new Jsii$Proxy(bucket, encryptionDisabled, encryptionKey, packaging, path);
            }
        }

        /**
         * An implementation for {@link S3ReportExportConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3ReportExportConfigProperty {
            private final java.lang.String bucket;
            private final java.lang.Object encryptionDisabled;
            private final java.lang.String encryptionKey;
            private final java.lang.String packaging;
            private final java.lang.String path;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.encryptionDisabled = this.jsiiGet("encryptionDisabled", java.lang.Object.class);
                this.encryptionKey = this.jsiiGet("encryptionKey", java.lang.String.class);
                this.packaging = this.jsiiGet("packaging", java.lang.String.class);
                this.path = this.jsiiGet("path", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String bucket, final java.lang.Object encryptionDisabled, final java.lang.String encryptionKey, final java.lang.String packaging, final java.lang.String path) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.encryptionDisabled = encryptionDisabled;
                this.encryptionKey = encryptionKey;
                this.packaging = packaging;
                this.path = path;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.Object getEncryptionDisabled() {
                return this.encryptionDisabled;
            }

            @Override
            public java.lang.String getEncryptionKey() {
                return this.encryptionKey;
            }

            @Override
            public java.lang.String getPackaging() {
                return this.packaging;
            }

            @Override
            public java.lang.String getPath() {
                return this.path;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getEncryptionDisabled() != null) {
                    data.set("encryptionDisabled", om.valueToTree(this.getEncryptionDisabled()));
                }
                if (this.getEncryptionKey() != null) {
                    data.set("encryptionKey", om.valueToTree(this.getEncryptionKey()));
                }
                if (this.getPackaging() != null) {
                    data.set("packaging", om.valueToTree(this.getPackaging()));
                }
                if (this.getPath() != null) {
                    data.set("path", om.valueToTree(this.getPath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-codebuild.CfnReportGroup.S3ReportExportConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3ReportExportConfigProperty.Jsii$Proxy that = (S3ReportExportConfigProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.encryptionDisabled != null ? !this.encryptionDisabled.equals(that.encryptionDisabled) : that.encryptionDisabled != null) return false;
                if (this.encryptionKey != null ? !this.encryptionKey.equals(that.encryptionKey) : that.encryptionKey != null) return false;
                if (this.packaging != null ? !this.packaging.equals(that.packaging) : that.packaging != null) return false;
                return this.path != null ? this.path.equals(that.path) : that.path == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.encryptionDisabled != null ? this.encryptionDisabled.hashCode() : 0);
                result = 31 * result + (this.encryptionKey != null ? this.encryptionKey.hashCode() : 0);
                result = 31 * result + (this.packaging != null ? this.packaging.hashCode() : 0);
                result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codebuild.CfnReportGroup}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codebuild.CfnReportGroup> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.codebuild.CfnReportGroupProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.codebuild.CfnReportGroupProps.Builder();
        }

        /**
         * `AWS::CodeBuild::ReportGroup.ExportConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
         * @param exportConfig `AWS::CodeBuild::ReportGroup.ExportConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportConfig(final software.amazon.awscdk.core.IResolvable exportConfig) {
            this.props.exportConfig(exportConfig);
            return this;
        }
        /**
         * `AWS::CodeBuild::ReportGroup.ExportConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-exportconfig
         * @param exportConfig `AWS::CodeBuild::ReportGroup.ExportConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exportConfig(final software.amazon.awscdk.services.codebuild.CfnReportGroup.ReportExportConfigProperty exportConfig) {
            this.props.exportConfig(exportConfig);
            return this;
        }

        /**
         * `AWS::CodeBuild::ReportGroup.Type`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-type
         * @param type `AWS::CodeBuild::ReportGroup.Type`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(final java.lang.String type) {
            this.props.type(type);
            return this;
        }

        /**
         * `AWS::CodeBuild::ReportGroup.Name`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-name
         * @param name `AWS::CodeBuild::ReportGroup.Name`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * `AWS::CodeBuild::ReportGroup.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-codebuild-reportgroup.html#cfn-codebuild-reportgroup-tags
         * @param tags `AWS::CodeBuild::ReportGroup.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.codebuild.CfnReportGroup}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codebuild.CfnReportGroup build() {
            return new software.amazon.awscdk.services.codebuild.CfnReportGroup(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
