package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFormation `AWS::CloudFront::Distribution`.
 * <p>
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.523Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution")
public class CfnDistribution extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnDistribution(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDistribution(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudfront.CfnDistribution.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::CloudFront::Distribution`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnDistribution(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnDistributionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * EXPERIMENTAL
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        this.jsiiCall("inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrDomainName() {
        return this.jsiiGet("attrDomainName", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * `AWS::CloudFront::Distribution.Tags`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getDistributionConfig() {
        return this.jsiiGet("distributionConfig", java.lang.Object.class);
    }

    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("distributionConfig", java.util.Objects.requireNonNull(value, "distributionConfig is required"));
    }

    /**
     * `AWS::CloudFront::Distribution.DistributionConfig`.
     * <p>
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDistributionConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.CfnDistribution.DistributionConfigProperty value) {
        this.jsiiSet("distributionConfig", java.util.Objects.requireNonNull(value, "distributionConfig is required"));
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.CacheBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(CacheBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CacheBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CacheBehaviorProperty.PathPattern`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-pathpattern
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPathPattern();

        /**
         * `CfnDistribution.CacheBehaviorProperty.TargetOriginId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-targetoriginid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetOriginId();

        /**
         * `CfnDistribution.CacheBehaviorProperty.ViewerProtocolPolicy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-viewerprotocolpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getViewerProtocolPolicy();

        /**
         * `CfnDistribution.CacheBehaviorProperty.AllowedMethods`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-allowedmethods
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.CachedMethods`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachedmethods
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCachedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.CachePolicyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-cachepolicyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCachePolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.Compress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-compress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompress() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.DefaultTTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-defaultttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.FieldLevelEncryptionId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-fieldlevelencryptionid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLevelEncryptionId() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.ForwardedValues`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-forwardedvalues
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedValues() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.LambdaFunctionAssociations`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-lambdafunctionassociations
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunctionAssociations() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.MaxTTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-maxttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.MinTTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-minttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.OriginRequestPolicyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-originrequestpolicyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginRequestPolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.SmoothStreaming`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-smoothstreaming
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmoothStreaming() {
            return null;
        }

        /**
         * `CfnDistribution.CacheBehaviorProperty.TrustedSigners`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cachebehavior.html#cfn-cloudfront-distribution-cachebehavior-trustedsigners
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CacheBehaviorProperty> {
            private java.lang.String pathPattern;
            private java.lang.String targetOriginId;
            private java.lang.String viewerProtocolPolicy;
            private java.util.List<java.lang.String> allowedMethods;
            private java.util.List<java.lang.String> cachedMethods;
            private java.lang.String cachePolicyId;
            private java.lang.Object compress;
            private java.lang.Number defaultTtl;
            private java.lang.String fieldLevelEncryptionId;
            private java.lang.Object forwardedValues;
            private java.lang.Object lambdaFunctionAssociations;
            private java.lang.Number maxTtl;
            private java.lang.Number minTtl;
            private java.lang.String originRequestPolicyId;
            private java.lang.Object smoothStreaming;
            private java.util.List<java.lang.String> trustedSigners;

            /**
             * Sets the value of {@link CacheBehaviorProperty#getPathPattern}
             * @param pathPattern `CfnDistribution.CacheBehaviorProperty.PathPattern`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder pathPattern(java.lang.String pathPattern) {
                this.pathPattern = pathPattern;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTargetOriginId}
             * @param targetOriginId `CfnDistribution.CacheBehaviorProperty.TargetOriginId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetOriginId(java.lang.String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getViewerProtocolPolicy}
             * @param viewerProtocolPolicy `CfnDistribution.CacheBehaviorProperty.ViewerProtocolPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerProtocolPolicy(java.lang.String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getAllowedMethods}
             * @param allowedMethods `CfnDistribution.CacheBehaviorProperty.AllowedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCachedMethods}
             * @param cachedMethods `CfnDistribution.CacheBehaviorProperty.CachedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachedMethods(java.util.List<java.lang.String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCachePolicyId}
             * @param cachePolicyId `CfnDistribution.CacheBehaviorProperty.CachePolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachePolicyId(java.lang.String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.CacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(java.lang.Boolean compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.CacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(software.amazon.awscdk.core.IResolvable compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getDefaultTtl}
             * @param defaultTtl `CfnDistribution.CacheBehaviorProperty.DefaultTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getFieldLevelEncryptionId}
             * @param fieldLevelEncryptionId `CfnDistribution.CacheBehaviorProperty.FieldLevelEncryptionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLevelEncryptionId(java.lang.String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.CacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.core.IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.CacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.CacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(software.amazon.awscdk.core.IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.CacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(java.util.List<java.lang.Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getMaxTtl}
             * @param maxTtl `CfnDistribution.CacheBehaviorProperty.MaxTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getMinTtl}
             * @param minTtl `CfnDistribution.CacheBehaviorProperty.MinTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getOriginRequestPolicyId}
             * @param originRequestPolicyId `CfnDistribution.CacheBehaviorProperty.OriginRequestPolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originRequestPolicyId(java.lang.String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.CacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.CacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(software.amazon.awscdk.core.IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link CacheBehaviorProperty#getTrustedSigners}
             * @param trustedSigners `CfnDistribution.CacheBehaviorProperty.TrustedSigners`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CacheBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CacheBehaviorProperty build() {
                return new Jsii$Proxy(pathPattern, targetOriginId, viewerProtocolPolicy, allowedMethods, cachedMethods, cachePolicyId, compress, defaultTtl, fieldLevelEncryptionId, forwardedValues, lambdaFunctionAssociations, maxTtl, minTtl, originRequestPolicyId, smoothStreaming, trustedSigners);
            }
        }

        /**
         * An implementation for {@link CacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CacheBehaviorProperty {
            private final java.lang.String pathPattern;
            private final java.lang.String targetOriginId;
            private final java.lang.String viewerProtocolPolicy;
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> cachedMethods;
            private final java.lang.String cachePolicyId;
            private final java.lang.Object compress;
            private final java.lang.Number defaultTtl;
            private final java.lang.String fieldLevelEncryptionId;
            private final java.lang.Object forwardedValues;
            private final java.lang.Object lambdaFunctionAssociations;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String originRequestPolicyId;
            private final java.lang.Object smoothStreaming;
            private final java.util.List<java.lang.String> trustedSigners;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.pathPattern = this.jsiiGet("pathPattern", java.lang.String.class);
                this.targetOriginId = this.jsiiGet("targetOriginId", java.lang.String.class);
                this.viewerProtocolPolicy = this.jsiiGet("viewerProtocolPolicy", java.lang.String.class);
                this.allowedMethods = this.jsiiGet("allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachedMethods = this.jsiiGet("cachedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachePolicyId = this.jsiiGet("cachePolicyId", java.lang.String.class);
                this.compress = this.jsiiGet("compress", java.lang.Object.class);
                this.defaultTtl = this.jsiiGet("defaultTtl", java.lang.Number.class);
                this.fieldLevelEncryptionId = this.jsiiGet("fieldLevelEncryptionId", java.lang.String.class);
                this.forwardedValues = this.jsiiGet("forwardedValues", java.lang.Object.class);
                this.lambdaFunctionAssociations = this.jsiiGet("lambdaFunctionAssociations", java.lang.Object.class);
                this.maxTtl = this.jsiiGet("maxTtl", java.lang.Number.class);
                this.minTtl = this.jsiiGet("minTtl", java.lang.Number.class);
                this.originRequestPolicyId = this.jsiiGet("originRequestPolicyId", java.lang.String.class);
                this.smoothStreaming = this.jsiiGet("smoothStreaming", java.lang.Object.class);
                this.trustedSigners = this.jsiiGet("trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String pathPattern, final java.lang.String targetOriginId, final java.lang.String viewerProtocolPolicy, final java.util.List<java.lang.String> allowedMethods, final java.util.List<java.lang.String> cachedMethods, final java.lang.String cachePolicyId, final java.lang.Object compress, final java.lang.Number defaultTtl, final java.lang.String fieldLevelEncryptionId, final java.lang.Object forwardedValues, final java.lang.Object lambdaFunctionAssociations, final java.lang.Number maxTtl, final java.lang.Number minTtl, final java.lang.String originRequestPolicyId, final java.lang.Object smoothStreaming, final java.util.List<java.lang.String> trustedSigners) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.pathPattern = java.util.Objects.requireNonNull(pathPattern, "pathPattern is required");
                this.targetOriginId = java.util.Objects.requireNonNull(targetOriginId, "targetOriginId is required");
                this.viewerProtocolPolicy = java.util.Objects.requireNonNull(viewerProtocolPolicy, "viewerProtocolPolicy is required");
                this.allowedMethods = allowedMethods;
                this.cachedMethods = cachedMethods;
                this.cachePolicyId = cachePolicyId;
                this.compress = compress;
                this.defaultTtl = defaultTtl;
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                this.forwardedValues = forwardedValues;
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                this.maxTtl = maxTtl;
                this.minTtl = minTtl;
                this.originRequestPolicyId = originRequestPolicyId;
                this.smoothStreaming = smoothStreaming;
                this.trustedSigners = trustedSigners;
            }

            @Override
            public java.lang.String getPathPattern() {
                return this.pathPattern;
            }

            @Override
            public java.lang.String getTargetOriginId() {
                return this.targetOriginId;
            }

            @Override
            public java.lang.String getViewerProtocolPolicy() {
                return this.viewerProtocolPolicy;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public java.util.List<java.lang.String> getCachedMethods() {
                return this.cachedMethods;
            }

            @Override
            public java.lang.String getCachePolicyId() {
                return this.cachePolicyId;
            }

            @Override
            public java.lang.Object getCompress() {
                return this.compress;
            }

            @Override
            public java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public java.lang.String getFieldLevelEncryptionId() {
                return this.fieldLevelEncryptionId;
            }

            @Override
            public java.lang.Object getForwardedValues() {
                return this.forwardedValues;
            }

            @Override
            public java.lang.Object getLambdaFunctionAssociations() {
                return this.lambdaFunctionAssociations;
            }

            @Override
            public java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public java.lang.String getOriginRequestPolicyId() {
                return this.originRequestPolicyId;
            }

            @Override
            public java.lang.Object getSmoothStreaming() {
                return this.smoothStreaming;
            }

            @Override
            public java.util.List<java.lang.String> getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("pathPattern", om.valueToTree(this.getPathPattern()));
                data.set("targetOriginId", om.valueToTree(this.getTargetOriginId()));
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
                if (this.getAllowedMethods() != null) {
                    data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                }
                if (this.getCachedMethods() != null) {
                    data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
                }
                if (this.getCachePolicyId() != null) {
                    data.set("cachePolicyId", om.valueToTree(this.getCachePolicyId()));
                }
                if (this.getCompress() != null) {
                    data.set("compress", om.valueToTree(this.getCompress()));
                }
                if (this.getDefaultTtl() != null) {
                    data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                }
                if (this.getFieldLevelEncryptionId() != null) {
                    data.set("fieldLevelEncryptionId", om.valueToTree(this.getFieldLevelEncryptionId()));
                }
                if (this.getForwardedValues() != null) {
                    data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
                }
                if (this.getLambdaFunctionAssociations() != null) {
                    data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
                }
                if (this.getMaxTtl() != null) {
                    data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                }
                if (this.getMinTtl() != null) {
                    data.set("minTtl", om.valueToTree(this.getMinTtl()));
                }
                if (this.getOriginRequestPolicyId() != null) {
                    data.set("originRequestPolicyId", om.valueToTree(this.getOriginRequestPolicyId()));
                }
                if (this.getSmoothStreaming() != null) {
                    data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
                }
                if (this.getTrustedSigners() != null) {
                    data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.CacheBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CacheBehaviorProperty.Jsii$Proxy that = (CacheBehaviorProperty.Jsii$Proxy) o;

                if (!pathPattern.equals(that.pathPattern)) return false;
                if (!targetOriginId.equals(that.targetOriginId)) return false;
                if (!viewerProtocolPolicy.equals(that.viewerProtocolPolicy)) return false;
                if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
                if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
                if (this.cachePolicyId != null ? !this.cachePolicyId.equals(that.cachePolicyId) : that.cachePolicyId != null) return false;
                if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
                if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
                if (this.fieldLevelEncryptionId != null ? !this.fieldLevelEncryptionId.equals(that.fieldLevelEncryptionId) : that.fieldLevelEncryptionId != null) return false;
                if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
                if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
                if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
                if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
                if (this.originRequestPolicyId != null ? !this.originRequestPolicyId.equals(that.originRequestPolicyId) : that.originRequestPolicyId != null) return false;
                if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
                return this.trustedSigners != null ? this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners == null;
            }

            @Override
            public int hashCode() {
                int result = this.pathPattern.hashCode();
                result = 31 * result + (this.targetOriginId.hashCode());
                result = 31 * result + (this.viewerProtocolPolicy.hashCode());
                result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
                result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
                result = 31 * result + (this.cachePolicyId != null ? this.cachePolicyId.hashCode() : 0);
                result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
                result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
                result = 31 * result + (this.fieldLevelEncryptionId != null ? this.fieldLevelEncryptionId.hashCode() : 0);
                result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
                result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
                result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
                result = 31 * result + (this.originRequestPolicyId != null ? this.originRequestPolicyId.hashCode() : 0);
                result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
                result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.CookiesProperty")
    @software.amazon.jsii.Jsii.Proxy(CookiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CookiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CookiesProperty.Forward`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-forward
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getForward();

        /**
         * `CfnDistribution.CookiesProperty.WhitelistedNames`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-cookies.html#cfn-cloudfront-distribution-cookies-whitelistednames
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getWhitelistedNames() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CookiesProperty> {
            private java.lang.String forward;
            private java.util.List<java.lang.String> whitelistedNames;

            /**
             * Sets the value of {@link CookiesProperty#getForward}
             * @param forward `CfnDistribution.CookiesProperty.Forward`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forward(java.lang.String forward) {
                this.forward = forward;
                return this;
            }

            /**
             * Sets the value of {@link CookiesProperty#getWhitelistedNames}
             * @param whitelistedNames `CfnDistribution.CookiesProperty.WhitelistedNames`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder whitelistedNames(java.util.List<java.lang.String> whitelistedNames) {
                this.whitelistedNames = whitelistedNames;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CookiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CookiesProperty build() {
                return new Jsii$Proxy(forward, whitelistedNames);
            }
        }

        /**
         * An implementation for {@link CookiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CookiesProperty {
            private final java.lang.String forward;
            private final java.util.List<java.lang.String> whitelistedNames;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.forward = this.jsiiGet("forward", java.lang.String.class);
                this.whitelistedNames = this.jsiiGet("whitelistedNames", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String forward, final java.util.List<java.lang.String> whitelistedNames) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.forward = java.util.Objects.requireNonNull(forward, "forward is required");
                this.whitelistedNames = whitelistedNames;
            }

            @Override
            public java.lang.String getForward() {
                return this.forward;
            }

            @Override
            public java.util.List<java.lang.String> getWhitelistedNames() {
                return this.whitelistedNames;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("forward", om.valueToTree(this.getForward()));
                if (this.getWhitelistedNames() != null) {
                    data.set("whitelistedNames", om.valueToTree(this.getWhitelistedNames()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.CookiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CookiesProperty.Jsii$Proxy that = (CookiesProperty.Jsii$Proxy) o;

                if (!forward.equals(that.forward)) return false;
                return this.whitelistedNames != null ? this.whitelistedNames.equals(that.whitelistedNames) : that.whitelistedNames == null;
            }

            @Override
            public int hashCode() {
                int result = this.forward.hashCode();
                result = 31 * result + (this.whitelistedNames != null ? this.whitelistedNames.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.CustomErrorResponseProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomErrorResponseProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomErrorResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ErrorCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getErrorCode();

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ErrorCachingMinTTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-errorcachingminttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getErrorCachingMinTtl() {
            return null;
        }

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ResponseCode`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsecode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getResponseCode() {
            return null;
        }

        /**
         * `CfnDistribution.CustomErrorResponseProperty.ResponsePagePath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customerrorresponse.html#cfn-cloudfront-distribution-customerrorresponse-responsepagepath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getResponsePagePath() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomErrorResponseProperty> {
            private java.lang.Number errorCode;
            private java.lang.Number errorCachingMinTtl;
            private java.lang.Number responseCode;
            private java.lang.String responsePagePath;

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getErrorCode}
             * @param errorCode `CfnDistribution.CustomErrorResponseProperty.ErrorCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorCode(java.lang.Number errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getErrorCachingMinTtl}
             * @param errorCachingMinTtl `CfnDistribution.CustomErrorResponseProperty.ErrorCachingMinTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder errorCachingMinTtl(java.lang.Number errorCachingMinTtl) {
                this.errorCachingMinTtl = errorCachingMinTtl;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getResponseCode}
             * @param responseCode `CfnDistribution.CustomErrorResponseProperty.ResponseCode`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responseCode(java.lang.Number responseCode) {
                this.responseCode = responseCode;
                return this;
            }

            /**
             * Sets the value of {@link CustomErrorResponseProperty#getResponsePagePath}
             * @param responsePagePath `CfnDistribution.CustomErrorResponseProperty.ResponsePagePath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder responsePagePath(java.lang.String responsePagePath) {
                this.responsePagePath = responsePagePath;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomErrorResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomErrorResponseProperty build() {
                return new Jsii$Proxy(errorCode, errorCachingMinTtl, responseCode, responsePagePath);
            }
        }

        /**
         * An implementation for {@link CustomErrorResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomErrorResponseProperty {
            private final java.lang.Number errorCode;
            private final java.lang.Number errorCachingMinTtl;
            private final java.lang.Number responseCode;
            private final java.lang.String responsePagePath;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.errorCode = this.jsiiGet("errorCode", java.lang.Number.class);
                this.errorCachingMinTtl = this.jsiiGet("errorCachingMinTtl", java.lang.Number.class);
                this.responseCode = this.jsiiGet("responseCode", java.lang.Number.class);
                this.responsePagePath = this.jsiiGet("responsePagePath", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number errorCode, final java.lang.Number errorCachingMinTtl, final java.lang.Number responseCode, final java.lang.String responsePagePath) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.errorCode = java.util.Objects.requireNonNull(errorCode, "errorCode is required");
                this.errorCachingMinTtl = errorCachingMinTtl;
                this.responseCode = responseCode;
                this.responsePagePath = responsePagePath;
            }

            @Override
            public java.lang.Number getErrorCode() {
                return this.errorCode;
            }

            @Override
            public java.lang.Number getErrorCachingMinTtl() {
                return this.errorCachingMinTtl;
            }

            @Override
            public java.lang.Number getResponseCode() {
                return this.responseCode;
            }

            @Override
            public java.lang.String getResponsePagePath() {
                return this.responsePagePath;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("errorCode", om.valueToTree(this.getErrorCode()));
                if (this.getErrorCachingMinTtl() != null) {
                    data.set("errorCachingMinTtl", om.valueToTree(this.getErrorCachingMinTtl()));
                }
                if (this.getResponseCode() != null) {
                    data.set("responseCode", om.valueToTree(this.getResponseCode()));
                }
                if (this.getResponsePagePath() != null) {
                    data.set("responsePagePath", om.valueToTree(this.getResponsePagePath()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.CustomErrorResponseProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomErrorResponseProperty.Jsii$Proxy that = (CustomErrorResponseProperty.Jsii$Proxy) o;

                if (!errorCode.equals(that.errorCode)) return false;
                if (this.errorCachingMinTtl != null ? !this.errorCachingMinTtl.equals(that.errorCachingMinTtl) : that.errorCachingMinTtl != null) return false;
                if (this.responseCode != null ? !this.responseCode.equals(that.responseCode) : that.responseCode != null) return false;
                return this.responsePagePath != null ? this.responsePagePath.equals(that.responsePagePath) : that.responsePagePath == null;
            }

            @Override
            public int hashCode() {
                int result = this.errorCode.hashCode();
                result = 31 * result + (this.errorCachingMinTtl != null ? this.errorCachingMinTtl.hashCode() : 0);
                result = 31 * result + (this.responseCode != null ? this.responseCode.hashCode() : 0);
                result = 31 * result + (this.responsePagePath != null ? this.responsePagePath.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.CustomOriginConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(CustomOriginConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface CustomOriginConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginProtocolPolicy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originprotocolpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginProtocolPolicy();

        /**
         * `CfnDistribution.CustomOriginConfigProperty.HTTPPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpPort() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.HTTPSPort`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-httpsport
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getHttpsPort() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginKeepaliveTimeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originkeepalivetimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOriginKeepaliveTimeout() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginReadTimeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originreadtimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getOriginReadTimeout() {
            return null;
        }

        /**
         * `CfnDistribution.CustomOriginConfigProperty.OriginSSLProtocols`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-customoriginconfig.html#cfn-cloudfront-distribution-customoriginconfig-originsslprotocols
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOriginSslProtocols() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<CustomOriginConfigProperty> {
            private java.lang.String originProtocolPolicy;
            private java.lang.Number httpPort;
            private java.lang.Number httpsPort;
            private java.lang.Number originKeepaliveTimeout;
            private java.lang.Number originReadTimeout;
            private java.util.List<java.lang.String> originSslProtocols;

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginProtocolPolicy}
             * @param originProtocolPolicy `CfnDistribution.CustomOriginConfigProperty.OriginProtocolPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originProtocolPolicy(java.lang.String originProtocolPolicy) {
                this.originProtocolPolicy = originProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getHttpPort}
             * @param httpPort `CfnDistribution.CustomOriginConfigProperty.HTTPPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpPort(java.lang.Number httpPort) {
                this.httpPort = httpPort;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getHttpsPort}
             * @param httpsPort `CfnDistribution.CustomOriginConfigProperty.HTTPSPort`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpsPort(java.lang.Number httpsPort) {
                this.httpsPort = httpsPort;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginKeepaliveTimeout}
             * @param originKeepaliveTimeout `CfnDistribution.CustomOriginConfigProperty.OriginKeepaliveTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originKeepaliveTimeout(java.lang.Number originKeepaliveTimeout) {
                this.originKeepaliveTimeout = originKeepaliveTimeout;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginReadTimeout}
             * @param originReadTimeout `CfnDistribution.CustomOriginConfigProperty.OriginReadTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originReadTimeout(java.lang.Number originReadTimeout) {
                this.originReadTimeout = originReadTimeout;
                return this;
            }

            /**
             * Sets the value of {@link CustomOriginConfigProperty#getOriginSslProtocols}
             * @param originSslProtocols `CfnDistribution.CustomOriginConfigProperty.OriginSSLProtocols`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originSslProtocols(java.util.List<java.lang.String> originSslProtocols) {
                this.originSslProtocols = originSslProtocols;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link CustomOriginConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public CustomOriginConfigProperty build() {
                return new Jsii$Proxy(originProtocolPolicy, httpPort, httpsPort, originKeepaliveTimeout, originReadTimeout, originSslProtocols);
            }
        }

        /**
         * An implementation for {@link CustomOriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomOriginConfigProperty {
            private final java.lang.String originProtocolPolicy;
            private final java.lang.Number httpPort;
            private final java.lang.Number httpsPort;
            private final java.lang.Number originKeepaliveTimeout;
            private final java.lang.Number originReadTimeout;
            private final java.util.List<java.lang.String> originSslProtocols;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originProtocolPolicy = this.jsiiGet("originProtocolPolicy", java.lang.String.class);
                this.httpPort = this.jsiiGet("httpPort", java.lang.Number.class);
                this.httpsPort = this.jsiiGet("httpsPort", java.lang.Number.class);
                this.originKeepaliveTimeout = this.jsiiGet("originKeepaliveTimeout", java.lang.Number.class);
                this.originReadTimeout = this.jsiiGet("originReadTimeout", java.lang.Number.class);
                this.originSslProtocols = this.jsiiGet("originSslProtocols", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String originProtocolPolicy, final java.lang.Number httpPort, final java.lang.Number httpsPort, final java.lang.Number originKeepaliveTimeout, final java.lang.Number originReadTimeout, final java.util.List<java.lang.String> originSslProtocols) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originProtocolPolicy = java.util.Objects.requireNonNull(originProtocolPolicy, "originProtocolPolicy is required");
                this.httpPort = httpPort;
                this.httpsPort = httpsPort;
                this.originKeepaliveTimeout = originKeepaliveTimeout;
                this.originReadTimeout = originReadTimeout;
                this.originSslProtocols = originSslProtocols;
            }

            @Override
            public java.lang.String getOriginProtocolPolicy() {
                return this.originProtocolPolicy;
            }

            @Override
            public java.lang.Number getHttpPort() {
                return this.httpPort;
            }

            @Override
            public java.lang.Number getHttpsPort() {
                return this.httpsPort;
            }

            @Override
            public java.lang.Number getOriginKeepaliveTimeout() {
                return this.originKeepaliveTimeout;
            }

            @Override
            public java.lang.Number getOriginReadTimeout() {
                return this.originReadTimeout;
            }

            @Override
            public java.util.List<java.lang.String> getOriginSslProtocols() {
                return this.originSslProtocols;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("originProtocolPolicy", om.valueToTree(this.getOriginProtocolPolicy()));
                if (this.getHttpPort() != null) {
                    data.set("httpPort", om.valueToTree(this.getHttpPort()));
                }
                if (this.getHttpsPort() != null) {
                    data.set("httpsPort", om.valueToTree(this.getHttpsPort()));
                }
                if (this.getOriginKeepaliveTimeout() != null) {
                    data.set("originKeepaliveTimeout", om.valueToTree(this.getOriginKeepaliveTimeout()));
                }
                if (this.getOriginReadTimeout() != null) {
                    data.set("originReadTimeout", om.valueToTree(this.getOriginReadTimeout()));
                }
                if (this.getOriginSslProtocols() != null) {
                    data.set("originSslProtocols", om.valueToTree(this.getOriginSslProtocols()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.CustomOriginConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                CustomOriginConfigProperty.Jsii$Proxy that = (CustomOriginConfigProperty.Jsii$Proxy) o;

                if (!originProtocolPolicy.equals(that.originProtocolPolicy)) return false;
                if (this.httpPort != null ? !this.httpPort.equals(that.httpPort) : that.httpPort != null) return false;
                if (this.httpsPort != null ? !this.httpsPort.equals(that.httpsPort) : that.httpsPort != null) return false;
                if (this.originKeepaliveTimeout != null ? !this.originKeepaliveTimeout.equals(that.originKeepaliveTimeout) : that.originKeepaliveTimeout != null) return false;
                if (this.originReadTimeout != null ? !this.originReadTimeout.equals(that.originReadTimeout) : that.originReadTimeout != null) return false;
                return this.originSslProtocols != null ? this.originSslProtocols.equals(that.originSslProtocols) : that.originSslProtocols == null;
            }

            @Override
            public int hashCode() {
                int result = this.originProtocolPolicy.hashCode();
                result = 31 * result + (this.httpPort != null ? this.httpPort.hashCode() : 0);
                result = 31 * result + (this.httpsPort != null ? this.httpsPort.hashCode() : 0);
                result = 31 * result + (this.originKeepaliveTimeout != null ? this.originKeepaliveTimeout.hashCode() : 0);
                result = 31 * result + (this.originReadTimeout != null ? this.originReadTimeout.hashCode() : 0);
                result = 31 * result + (this.originSslProtocols != null ? this.originSslProtocols.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.DefaultCacheBehaviorProperty")
    @software.amazon.jsii.Jsii.Proxy(DefaultCacheBehaviorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DefaultCacheBehaviorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.TargetOriginId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-targetoriginid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetOriginId();

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.ViewerProtocolPolicy`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-viewerprotocolpolicy
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getViewerProtocolPolicy();

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.AllowedMethods`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-allowedmethods
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAllowedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.CachedMethods`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachedmethods
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCachedMethods() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.CachePolicyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-cachepolicyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getCachePolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.Compress`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-compress
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCompress() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.DefaultTTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-defaultttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getDefaultTtl() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.FieldLevelEncryptionId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-fieldlevelencryptionid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getFieldLevelEncryptionId() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.ForwardedValues`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-forwardedvalues
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getForwardedValues() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.LambdaFunctionAssociations`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-lambdafunctionassociations
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunctionAssociations() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.MaxTTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-maxttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTtl() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.MinTTL`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-minttl
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMinTtl() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.OriginRequestPolicyId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-originrequestpolicyid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginRequestPolicyId() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.SmoothStreaming`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-smoothstreaming
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getSmoothStreaming() {
            return null;
        }

        /**
         * `CfnDistribution.DefaultCacheBehaviorProperty.TrustedSigners`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-defaultcachebehavior.html#cfn-cloudfront-distribution-defaultcachebehavior-trustedsigners
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getTrustedSigners() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DefaultCacheBehaviorProperty> {
            private java.lang.String targetOriginId;
            private java.lang.String viewerProtocolPolicy;
            private java.util.List<java.lang.String> allowedMethods;
            private java.util.List<java.lang.String> cachedMethods;
            private java.lang.String cachePolicyId;
            private java.lang.Object compress;
            private java.lang.Number defaultTtl;
            private java.lang.String fieldLevelEncryptionId;
            private java.lang.Object forwardedValues;
            private java.lang.Object lambdaFunctionAssociations;
            private java.lang.Number maxTtl;
            private java.lang.Number minTtl;
            private java.lang.String originRequestPolicyId;
            private java.lang.Object smoothStreaming;
            private java.util.List<java.lang.String> trustedSigners;

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTargetOriginId}
             * @param targetOriginId `CfnDistribution.DefaultCacheBehaviorProperty.TargetOriginId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetOriginId(java.lang.String targetOriginId) {
                this.targetOriginId = targetOriginId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getViewerProtocolPolicy}
             * @param viewerProtocolPolicy `CfnDistribution.DefaultCacheBehaviorProperty.ViewerProtocolPolicy`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerProtocolPolicy(java.lang.String viewerProtocolPolicy) {
                this.viewerProtocolPolicy = viewerProtocolPolicy;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getAllowedMethods}
             * @param allowedMethods `CfnDistribution.DefaultCacheBehaviorProperty.AllowedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowedMethods(java.util.List<java.lang.String> allowedMethods) {
                this.allowedMethods = allowedMethods;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCachedMethods}
             * @param cachedMethods `CfnDistribution.DefaultCacheBehaviorProperty.CachedMethods`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachedMethods(java.util.List<java.lang.String> cachedMethods) {
                this.cachedMethods = cachedMethods;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCachePolicyId}
             * @param cachePolicyId `CfnDistribution.DefaultCacheBehaviorProperty.CachePolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cachePolicyId(java.lang.String cachePolicyId) {
                this.cachePolicyId = cachePolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.DefaultCacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(java.lang.Boolean compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getCompress}
             * @param compress `CfnDistribution.DefaultCacheBehaviorProperty.Compress`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder compress(software.amazon.awscdk.core.IResolvable compress) {
                this.compress = compress;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getDefaultTtl}
             * @param defaultTtl `CfnDistribution.DefaultCacheBehaviorProperty.DefaultTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultTtl(java.lang.Number defaultTtl) {
                this.defaultTtl = defaultTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getFieldLevelEncryptionId}
             * @param fieldLevelEncryptionId `CfnDistribution.DefaultCacheBehaviorProperty.FieldLevelEncryptionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldLevelEncryptionId(java.lang.String fieldLevelEncryptionId) {
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.DefaultCacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.core.IResolvable forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getForwardedValues}
             * @param forwardedValues `CfnDistribution.DefaultCacheBehaviorProperty.ForwardedValues`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder forwardedValues(software.amazon.awscdk.services.cloudfront.CfnDistribution.ForwardedValuesProperty forwardedValues) {
                this.forwardedValues = forwardedValues;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.DefaultCacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(software.amazon.awscdk.core.IResolvable lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getLambdaFunctionAssociations}
             * @param lambdaFunctionAssociations `CfnDistribution.DefaultCacheBehaviorProperty.LambdaFunctionAssociations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionAssociations(java.util.List<java.lang.Object> lambdaFunctionAssociations) {
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getMaxTtl}
             * @param maxTtl `CfnDistribution.DefaultCacheBehaviorProperty.MaxTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTtl(java.lang.Number maxTtl) {
                this.maxTtl = maxTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getMinTtl}
             * @param minTtl `CfnDistribution.DefaultCacheBehaviorProperty.MinTTL`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minTtl(java.lang.Number minTtl) {
                this.minTtl = minTtl;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getOriginRequestPolicyId}
             * @param originRequestPolicyId `CfnDistribution.DefaultCacheBehaviorProperty.OriginRequestPolicyId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originRequestPolicyId(java.lang.String originRequestPolicyId) {
                this.originRequestPolicyId = originRequestPolicyId;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.DefaultCacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getSmoothStreaming}
             * @param smoothStreaming `CfnDistribution.DefaultCacheBehaviorProperty.SmoothStreaming`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder smoothStreaming(software.amazon.awscdk.core.IResolvable smoothStreaming) {
                this.smoothStreaming = smoothStreaming;
                return this;
            }

            /**
             * Sets the value of {@link DefaultCacheBehaviorProperty#getTrustedSigners}
             * @param trustedSigners `CfnDistribution.DefaultCacheBehaviorProperty.TrustedSigners`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder trustedSigners(java.util.List<java.lang.String> trustedSigners) {
                this.trustedSigners = trustedSigners;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DefaultCacheBehaviorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DefaultCacheBehaviorProperty build() {
                return new Jsii$Proxy(targetOriginId, viewerProtocolPolicy, allowedMethods, cachedMethods, cachePolicyId, compress, defaultTtl, fieldLevelEncryptionId, forwardedValues, lambdaFunctionAssociations, maxTtl, minTtl, originRequestPolicyId, smoothStreaming, trustedSigners);
            }
        }

        /**
         * An implementation for {@link DefaultCacheBehaviorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DefaultCacheBehaviorProperty {
            private final java.lang.String targetOriginId;
            private final java.lang.String viewerProtocolPolicy;
            private final java.util.List<java.lang.String> allowedMethods;
            private final java.util.List<java.lang.String> cachedMethods;
            private final java.lang.String cachePolicyId;
            private final java.lang.Object compress;
            private final java.lang.Number defaultTtl;
            private final java.lang.String fieldLevelEncryptionId;
            private final java.lang.Object forwardedValues;
            private final java.lang.Object lambdaFunctionAssociations;
            private final java.lang.Number maxTtl;
            private final java.lang.Number minTtl;
            private final java.lang.String originRequestPolicyId;
            private final java.lang.Object smoothStreaming;
            private final java.util.List<java.lang.String> trustedSigners;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.targetOriginId = this.jsiiGet("targetOriginId", java.lang.String.class);
                this.viewerProtocolPolicy = this.jsiiGet("viewerProtocolPolicy", java.lang.String.class);
                this.allowedMethods = this.jsiiGet("allowedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachedMethods = this.jsiiGet("cachedMethods", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cachePolicyId = this.jsiiGet("cachePolicyId", java.lang.String.class);
                this.compress = this.jsiiGet("compress", java.lang.Object.class);
                this.defaultTtl = this.jsiiGet("defaultTtl", java.lang.Number.class);
                this.fieldLevelEncryptionId = this.jsiiGet("fieldLevelEncryptionId", java.lang.String.class);
                this.forwardedValues = this.jsiiGet("forwardedValues", java.lang.Object.class);
                this.lambdaFunctionAssociations = this.jsiiGet("lambdaFunctionAssociations", java.lang.Object.class);
                this.maxTtl = this.jsiiGet("maxTtl", java.lang.Number.class);
                this.minTtl = this.jsiiGet("minTtl", java.lang.Number.class);
                this.originRequestPolicyId = this.jsiiGet("originRequestPolicyId", java.lang.String.class);
                this.smoothStreaming = this.jsiiGet("smoothStreaming", java.lang.Object.class);
                this.trustedSigners = this.jsiiGet("trustedSigners", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String targetOriginId, final java.lang.String viewerProtocolPolicy, final java.util.List<java.lang.String> allowedMethods, final java.util.List<java.lang.String> cachedMethods, final java.lang.String cachePolicyId, final java.lang.Object compress, final java.lang.Number defaultTtl, final java.lang.String fieldLevelEncryptionId, final java.lang.Object forwardedValues, final java.lang.Object lambdaFunctionAssociations, final java.lang.Number maxTtl, final java.lang.Number minTtl, final java.lang.String originRequestPolicyId, final java.lang.Object smoothStreaming, final java.util.List<java.lang.String> trustedSigners) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.targetOriginId = java.util.Objects.requireNonNull(targetOriginId, "targetOriginId is required");
                this.viewerProtocolPolicy = java.util.Objects.requireNonNull(viewerProtocolPolicy, "viewerProtocolPolicy is required");
                this.allowedMethods = allowedMethods;
                this.cachedMethods = cachedMethods;
                this.cachePolicyId = cachePolicyId;
                this.compress = compress;
                this.defaultTtl = defaultTtl;
                this.fieldLevelEncryptionId = fieldLevelEncryptionId;
                this.forwardedValues = forwardedValues;
                this.lambdaFunctionAssociations = lambdaFunctionAssociations;
                this.maxTtl = maxTtl;
                this.minTtl = minTtl;
                this.originRequestPolicyId = originRequestPolicyId;
                this.smoothStreaming = smoothStreaming;
                this.trustedSigners = trustedSigners;
            }

            @Override
            public java.lang.String getTargetOriginId() {
                return this.targetOriginId;
            }

            @Override
            public java.lang.String getViewerProtocolPolicy() {
                return this.viewerProtocolPolicy;
            }

            @Override
            public java.util.List<java.lang.String> getAllowedMethods() {
                return this.allowedMethods;
            }

            @Override
            public java.util.List<java.lang.String> getCachedMethods() {
                return this.cachedMethods;
            }

            @Override
            public java.lang.String getCachePolicyId() {
                return this.cachePolicyId;
            }

            @Override
            public java.lang.Object getCompress() {
                return this.compress;
            }

            @Override
            public java.lang.Number getDefaultTtl() {
                return this.defaultTtl;
            }

            @Override
            public java.lang.String getFieldLevelEncryptionId() {
                return this.fieldLevelEncryptionId;
            }

            @Override
            public java.lang.Object getForwardedValues() {
                return this.forwardedValues;
            }

            @Override
            public java.lang.Object getLambdaFunctionAssociations() {
                return this.lambdaFunctionAssociations;
            }

            @Override
            public java.lang.Number getMaxTtl() {
                return this.maxTtl;
            }

            @Override
            public java.lang.Number getMinTtl() {
                return this.minTtl;
            }

            @Override
            public java.lang.String getOriginRequestPolicyId() {
                return this.originRequestPolicyId;
            }

            @Override
            public java.lang.Object getSmoothStreaming() {
                return this.smoothStreaming;
            }

            @Override
            public java.util.List<java.lang.String> getTrustedSigners() {
                return this.trustedSigners;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("targetOriginId", om.valueToTree(this.getTargetOriginId()));
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
                if (this.getAllowedMethods() != null) {
                    data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
                }
                if (this.getCachedMethods() != null) {
                    data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
                }
                if (this.getCachePolicyId() != null) {
                    data.set("cachePolicyId", om.valueToTree(this.getCachePolicyId()));
                }
                if (this.getCompress() != null) {
                    data.set("compress", om.valueToTree(this.getCompress()));
                }
                if (this.getDefaultTtl() != null) {
                    data.set("defaultTtl", om.valueToTree(this.getDefaultTtl()));
                }
                if (this.getFieldLevelEncryptionId() != null) {
                    data.set("fieldLevelEncryptionId", om.valueToTree(this.getFieldLevelEncryptionId()));
                }
                if (this.getForwardedValues() != null) {
                    data.set("forwardedValues", om.valueToTree(this.getForwardedValues()));
                }
                if (this.getLambdaFunctionAssociations() != null) {
                    data.set("lambdaFunctionAssociations", om.valueToTree(this.getLambdaFunctionAssociations()));
                }
                if (this.getMaxTtl() != null) {
                    data.set("maxTtl", om.valueToTree(this.getMaxTtl()));
                }
                if (this.getMinTtl() != null) {
                    data.set("minTtl", om.valueToTree(this.getMinTtl()));
                }
                if (this.getOriginRequestPolicyId() != null) {
                    data.set("originRequestPolicyId", om.valueToTree(this.getOriginRequestPolicyId()));
                }
                if (this.getSmoothStreaming() != null) {
                    data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
                }
                if (this.getTrustedSigners() != null) {
                    data.set("trustedSigners", om.valueToTree(this.getTrustedSigners()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.DefaultCacheBehaviorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DefaultCacheBehaviorProperty.Jsii$Proxy that = (DefaultCacheBehaviorProperty.Jsii$Proxy) o;

                if (!targetOriginId.equals(that.targetOriginId)) return false;
                if (!viewerProtocolPolicy.equals(that.viewerProtocolPolicy)) return false;
                if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
                if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
                if (this.cachePolicyId != null ? !this.cachePolicyId.equals(that.cachePolicyId) : that.cachePolicyId != null) return false;
                if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
                if (this.defaultTtl != null ? !this.defaultTtl.equals(that.defaultTtl) : that.defaultTtl != null) return false;
                if (this.fieldLevelEncryptionId != null ? !this.fieldLevelEncryptionId.equals(that.fieldLevelEncryptionId) : that.fieldLevelEncryptionId != null) return false;
                if (this.forwardedValues != null ? !this.forwardedValues.equals(that.forwardedValues) : that.forwardedValues != null) return false;
                if (this.lambdaFunctionAssociations != null ? !this.lambdaFunctionAssociations.equals(that.lambdaFunctionAssociations) : that.lambdaFunctionAssociations != null) return false;
                if (this.maxTtl != null ? !this.maxTtl.equals(that.maxTtl) : that.maxTtl != null) return false;
                if (this.minTtl != null ? !this.minTtl.equals(that.minTtl) : that.minTtl != null) return false;
                if (this.originRequestPolicyId != null ? !this.originRequestPolicyId.equals(that.originRequestPolicyId) : that.originRequestPolicyId != null) return false;
                if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
                return this.trustedSigners != null ? this.trustedSigners.equals(that.trustedSigners) : that.trustedSigners == null;
            }

            @Override
            public int hashCode() {
                int result = this.targetOriginId.hashCode();
                result = 31 * result + (this.viewerProtocolPolicy.hashCode());
                result = 31 * result + (this.allowedMethods != null ? this.allowedMethods.hashCode() : 0);
                result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
                result = 31 * result + (this.cachePolicyId != null ? this.cachePolicyId.hashCode() : 0);
                result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
                result = 31 * result + (this.defaultTtl != null ? this.defaultTtl.hashCode() : 0);
                result = 31 * result + (this.fieldLevelEncryptionId != null ? this.fieldLevelEncryptionId.hashCode() : 0);
                result = 31 * result + (this.forwardedValues != null ? this.forwardedValues.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionAssociations != null ? this.lambdaFunctionAssociations.hashCode() : 0);
                result = 31 * result + (this.maxTtl != null ? this.maxTtl.hashCode() : 0);
                result = 31 * result + (this.minTtl != null ? this.minTtl.hashCode() : 0);
                result = 31 * result + (this.originRequestPolicyId != null ? this.originRequestPolicyId.hashCode() : 0);
                result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
                result = 31 * result + (this.trustedSigners != null ? this.trustedSigners.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.DistributionConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(DistributionConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DistributionConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.DistributionConfigProperty.Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getEnabled();

        /**
         * `CfnDistribution.DistributionConfigProperty.Aliases`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-aliases
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAliases() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.CacheBehaviors`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-cachebehaviors
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCacheBehaviors() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Comment`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-comment
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getComment() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.CustomErrorResponses`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-customerrorresponses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomErrorResponses() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.DefaultCacheBehavior`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultcachebehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultCacheBehavior() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.DefaultRootObject`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-defaultrootobject
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDefaultRootObject() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.HttpVersion`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-httpversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getHttpVersion() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.IPV6Enabled`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-ipv6enabled
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIpv6Enabled() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Logging`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-logging
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLogging() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.OriginGroups`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origingroups
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginGroups() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Origins`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-origins
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOrigins() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.PriceClass`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-priceclass
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPriceClass() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.Restrictions`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-restrictions
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRestrictions() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.ViewerCertificate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-viewercertificate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getViewerCertificate() {
            return null;
        }

        /**
         * `CfnDistribution.DistributionConfigProperty.WebACLId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-distributionconfig.html#cfn-cloudfront-distribution-distributionconfig-webaclid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getWebAclId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DistributionConfigProperty> {
            private java.lang.Object enabled;
            private java.util.List<java.lang.String> aliases;
            private java.lang.Object cacheBehaviors;
            private java.lang.String comment;
            private java.lang.Object customErrorResponses;
            private java.lang.Object defaultCacheBehavior;
            private java.lang.String defaultRootObject;
            private java.lang.String httpVersion;
            private java.lang.Object ipv6Enabled;
            private java.lang.Object logging;
            private java.lang.Object originGroups;
            private java.lang.Object origins;
            private java.lang.String priceClass;
            private java.lang.Object restrictions;
            private java.lang.Object viewerCertificate;
            private java.lang.String webAclId;

            /**
             * Sets the value of {@link DistributionConfigProperty#getEnabled}
             * @param enabled `CfnDistribution.DistributionConfigProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(java.lang.Boolean enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getEnabled}
             * @param enabled `CfnDistribution.DistributionConfigProperty.Enabled`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder enabled(software.amazon.awscdk.core.IResolvable enabled) {
                this.enabled = enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getAliases}
             * @param aliases `CfnDistribution.DistributionConfigProperty.Aliases`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder aliases(java.util.List<java.lang.String> aliases) {
                this.aliases = aliases;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCacheBehaviors}
             * @param cacheBehaviors `CfnDistribution.DistributionConfigProperty.CacheBehaviors`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheBehaviors(software.amazon.awscdk.core.IResolvable cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCacheBehaviors}
             * @param cacheBehaviors `CfnDistribution.DistributionConfigProperty.CacheBehaviors`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cacheBehaviors(java.util.List<java.lang.Object> cacheBehaviors) {
                this.cacheBehaviors = cacheBehaviors;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getComment}
             * @param comment `CfnDistribution.DistributionConfigProperty.Comment`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder comment(java.lang.String comment) {
                this.comment = comment;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomErrorResponses}
             * @param customErrorResponses `CfnDistribution.DistributionConfigProperty.CustomErrorResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customErrorResponses(software.amazon.awscdk.core.IResolvable customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getCustomErrorResponses}
             * @param customErrorResponses `CfnDistribution.DistributionConfigProperty.CustomErrorResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customErrorResponses(java.util.List<java.lang.Object> customErrorResponses) {
                this.customErrorResponses = customErrorResponses;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultCacheBehavior}
             * @param defaultCacheBehavior `CfnDistribution.DistributionConfigProperty.DefaultCacheBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultCacheBehavior(software.amazon.awscdk.core.IResolvable defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultCacheBehavior}
             * @param defaultCacheBehavior `CfnDistribution.DistributionConfigProperty.DefaultCacheBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultCacheBehavior(software.amazon.awscdk.services.cloudfront.CfnDistribution.DefaultCacheBehaviorProperty defaultCacheBehavior) {
                this.defaultCacheBehavior = defaultCacheBehavior;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getDefaultRootObject}
             * @param defaultRootObject `CfnDistribution.DistributionConfigProperty.DefaultRootObject`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder defaultRootObject(java.lang.String defaultRootObject) {
                this.defaultRootObject = defaultRootObject;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getHttpVersion}
             * @param httpVersion `CfnDistribution.DistributionConfigProperty.HttpVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder httpVersion(java.lang.String httpVersion) {
                this.httpVersion = httpVersion;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getIpv6Enabled}
             * @param ipv6Enabled `CfnDistribution.DistributionConfigProperty.IPV6Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Enabled(java.lang.Boolean ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getIpv6Enabled}
             * @param ipv6Enabled `CfnDistribution.DistributionConfigProperty.IPV6Enabled`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder ipv6Enabled(software.amazon.awscdk.core.IResolvable ipv6Enabled) {
                this.ipv6Enabled = ipv6Enabled;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getLogging}
             * @param logging `CfnDistribution.DistributionConfigProperty.Logging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.core.IResolvable logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getLogging}
             * @param logging `CfnDistribution.DistributionConfigProperty.Logging`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder logging(software.amazon.awscdk.services.cloudfront.CfnDistribution.LoggingProperty logging) {
                this.logging = logging;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOriginGroups}
             * @param originGroups `CfnDistribution.DistributionConfigProperty.OriginGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originGroups(software.amazon.awscdk.core.IResolvable originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOriginGroups}
             * @param originGroups `CfnDistribution.DistributionConfigProperty.OriginGroups`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originGroups(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupsProperty originGroups) {
                this.originGroups = originGroups;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOrigins}
             * @param origins `CfnDistribution.DistributionConfigProperty.Origins`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder origins(software.amazon.awscdk.core.IResolvable origins) {
                this.origins = origins;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getOrigins}
             * @param origins `CfnDistribution.DistributionConfigProperty.Origins`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder origins(java.util.List<java.lang.Object> origins) {
                this.origins = origins;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getPriceClass}
             * @param priceClass `CfnDistribution.DistributionConfigProperty.PriceClass`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder priceClass(java.lang.String priceClass) {
                this.priceClass = priceClass;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getRestrictions}
             * @param restrictions `CfnDistribution.DistributionConfigProperty.Restrictions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.core.IResolvable restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getRestrictions}
             * @param restrictions `CfnDistribution.DistributionConfigProperty.Restrictions`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictions(software.amazon.awscdk.services.cloudfront.CfnDistribution.RestrictionsProperty restrictions) {
                this.restrictions = restrictions;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getViewerCertificate}
             * @param viewerCertificate `CfnDistribution.DistributionConfigProperty.ViewerCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerCertificate(software.amazon.awscdk.core.IResolvable viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getViewerCertificate}
             * @param viewerCertificate `CfnDistribution.DistributionConfigProperty.ViewerCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder viewerCertificate(software.amazon.awscdk.services.cloudfront.CfnDistribution.ViewerCertificateProperty viewerCertificate) {
                this.viewerCertificate = viewerCertificate;
                return this;
            }

            /**
             * Sets the value of {@link DistributionConfigProperty#getWebAclId}
             * @param webAclId `CfnDistribution.DistributionConfigProperty.WebACLId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder webAclId(java.lang.String webAclId) {
                this.webAclId = webAclId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DistributionConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DistributionConfigProperty build() {
                return new Jsii$Proxy(enabled, aliases, cacheBehaviors, comment, customErrorResponses, defaultCacheBehavior, defaultRootObject, httpVersion, ipv6Enabled, logging, originGroups, origins, priceClass, restrictions, viewerCertificate, webAclId);
            }
        }

        /**
         * An implementation for {@link DistributionConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DistributionConfigProperty {
            private final java.lang.Object enabled;
            private final java.util.List<java.lang.String> aliases;
            private final java.lang.Object cacheBehaviors;
            private final java.lang.String comment;
            private final java.lang.Object customErrorResponses;
            private final java.lang.Object defaultCacheBehavior;
            private final java.lang.String defaultRootObject;
            private final java.lang.String httpVersion;
            private final java.lang.Object ipv6Enabled;
            private final java.lang.Object logging;
            private final java.lang.Object originGroups;
            private final java.lang.Object origins;
            private final java.lang.String priceClass;
            private final java.lang.Object restrictions;
            private final java.lang.Object viewerCertificate;
            private final java.lang.String webAclId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.enabled = this.jsiiGet("enabled", java.lang.Object.class);
                this.aliases = this.jsiiGet("aliases", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.cacheBehaviors = this.jsiiGet("cacheBehaviors", java.lang.Object.class);
                this.comment = this.jsiiGet("comment", java.lang.String.class);
                this.customErrorResponses = this.jsiiGet("customErrorResponses", java.lang.Object.class);
                this.defaultCacheBehavior = this.jsiiGet("defaultCacheBehavior", java.lang.Object.class);
                this.defaultRootObject = this.jsiiGet("defaultRootObject", java.lang.String.class);
                this.httpVersion = this.jsiiGet("httpVersion", java.lang.String.class);
                this.ipv6Enabled = this.jsiiGet("ipv6Enabled", java.lang.Object.class);
                this.logging = this.jsiiGet("logging", java.lang.Object.class);
                this.originGroups = this.jsiiGet("originGroups", java.lang.Object.class);
                this.origins = this.jsiiGet("origins", java.lang.Object.class);
                this.priceClass = this.jsiiGet("priceClass", java.lang.String.class);
                this.restrictions = this.jsiiGet("restrictions", java.lang.Object.class);
                this.viewerCertificate = this.jsiiGet("viewerCertificate", java.lang.Object.class);
                this.webAclId = this.jsiiGet("webAclId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object enabled, final java.util.List<java.lang.String> aliases, final java.lang.Object cacheBehaviors, final java.lang.String comment, final java.lang.Object customErrorResponses, final java.lang.Object defaultCacheBehavior, final java.lang.String defaultRootObject, final java.lang.String httpVersion, final java.lang.Object ipv6Enabled, final java.lang.Object logging, final java.lang.Object originGroups, final java.lang.Object origins, final java.lang.String priceClass, final java.lang.Object restrictions, final java.lang.Object viewerCertificate, final java.lang.String webAclId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.enabled = java.util.Objects.requireNonNull(enabled, "enabled is required");
                this.aliases = aliases;
                this.cacheBehaviors = cacheBehaviors;
                this.comment = comment;
                this.customErrorResponses = customErrorResponses;
                this.defaultCacheBehavior = defaultCacheBehavior;
                this.defaultRootObject = defaultRootObject;
                this.httpVersion = httpVersion;
                this.ipv6Enabled = ipv6Enabled;
                this.logging = logging;
                this.originGroups = originGroups;
                this.origins = origins;
                this.priceClass = priceClass;
                this.restrictions = restrictions;
                this.viewerCertificate = viewerCertificate;
                this.webAclId = webAclId;
            }

            @Override
            public java.lang.Object getEnabled() {
                return this.enabled;
            }

            @Override
            public java.util.List<java.lang.String> getAliases() {
                return this.aliases;
            }

            @Override
            public java.lang.Object getCacheBehaviors() {
                return this.cacheBehaviors;
            }

            @Override
            public java.lang.String getComment() {
                return this.comment;
            }

            @Override
            public java.lang.Object getCustomErrorResponses() {
                return this.customErrorResponses;
            }

            @Override
            public java.lang.Object getDefaultCacheBehavior() {
                return this.defaultCacheBehavior;
            }

            @Override
            public java.lang.String getDefaultRootObject() {
                return this.defaultRootObject;
            }

            @Override
            public java.lang.String getHttpVersion() {
                return this.httpVersion;
            }

            @Override
            public java.lang.Object getIpv6Enabled() {
                return this.ipv6Enabled;
            }

            @Override
            public java.lang.Object getLogging() {
                return this.logging;
            }

            @Override
            public java.lang.Object getOriginGroups() {
                return this.originGroups;
            }

            @Override
            public java.lang.Object getOrigins() {
                return this.origins;
            }

            @Override
            public java.lang.String getPriceClass() {
                return this.priceClass;
            }

            @Override
            public java.lang.Object getRestrictions() {
                return this.restrictions;
            }

            @Override
            public java.lang.Object getViewerCertificate() {
                return this.viewerCertificate;
            }

            @Override
            public java.lang.String getWebAclId() {
                return this.webAclId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("enabled", om.valueToTree(this.getEnabled()));
                if (this.getAliases() != null) {
                    data.set("aliases", om.valueToTree(this.getAliases()));
                }
                if (this.getCacheBehaviors() != null) {
                    data.set("cacheBehaviors", om.valueToTree(this.getCacheBehaviors()));
                }
                if (this.getComment() != null) {
                    data.set("comment", om.valueToTree(this.getComment()));
                }
                if (this.getCustomErrorResponses() != null) {
                    data.set("customErrorResponses", om.valueToTree(this.getCustomErrorResponses()));
                }
                if (this.getDefaultCacheBehavior() != null) {
                    data.set("defaultCacheBehavior", om.valueToTree(this.getDefaultCacheBehavior()));
                }
                if (this.getDefaultRootObject() != null) {
                    data.set("defaultRootObject", om.valueToTree(this.getDefaultRootObject()));
                }
                if (this.getHttpVersion() != null) {
                    data.set("httpVersion", om.valueToTree(this.getHttpVersion()));
                }
                if (this.getIpv6Enabled() != null) {
                    data.set("ipv6Enabled", om.valueToTree(this.getIpv6Enabled()));
                }
                if (this.getLogging() != null) {
                    data.set("logging", om.valueToTree(this.getLogging()));
                }
                if (this.getOriginGroups() != null) {
                    data.set("originGroups", om.valueToTree(this.getOriginGroups()));
                }
                if (this.getOrigins() != null) {
                    data.set("origins", om.valueToTree(this.getOrigins()));
                }
                if (this.getPriceClass() != null) {
                    data.set("priceClass", om.valueToTree(this.getPriceClass()));
                }
                if (this.getRestrictions() != null) {
                    data.set("restrictions", om.valueToTree(this.getRestrictions()));
                }
                if (this.getViewerCertificate() != null) {
                    data.set("viewerCertificate", om.valueToTree(this.getViewerCertificate()));
                }
                if (this.getWebAclId() != null) {
                    data.set("webAclId", om.valueToTree(this.getWebAclId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.DistributionConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DistributionConfigProperty.Jsii$Proxy that = (DistributionConfigProperty.Jsii$Proxy) o;

                if (!enabled.equals(that.enabled)) return false;
                if (this.aliases != null ? !this.aliases.equals(that.aliases) : that.aliases != null) return false;
                if (this.cacheBehaviors != null ? !this.cacheBehaviors.equals(that.cacheBehaviors) : that.cacheBehaviors != null) return false;
                if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
                if (this.customErrorResponses != null ? !this.customErrorResponses.equals(that.customErrorResponses) : that.customErrorResponses != null) return false;
                if (this.defaultCacheBehavior != null ? !this.defaultCacheBehavior.equals(that.defaultCacheBehavior) : that.defaultCacheBehavior != null) return false;
                if (this.defaultRootObject != null ? !this.defaultRootObject.equals(that.defaultRootObject) : that.defaultRootObject != null) return false;
                if (this.httpVersion != null ? !this.httpVersion.equals(that.httpVersion) : that.httpVersion != null) return false;
                if (this.ipv6Enabled != null ? !this.ipv6Enabled.equals(that.ipv6Enabled) : that.ipv6Enabled != null) return false;
                if (this.logging != null ? !this.logging.equals(that.logging) : that.logging != null) return false;
                if (this.originGroups != null ? !this.originGroups.equals(that.originGroups) : that.originGroups != null) return false;
                if (this.origins != null ? !this.origins.equals(that.origins) : that.origins != null) return false;
                if (this.priceClass != null ? !this.priceClass.equals(that.priceClass) : that.priceClass != null) return false;
                if (this.restrictions != null ? !this.restrictions.equals(that.restrictions) : that.restrictions != null) return false;
                if (this.viewerCertificate != null ? !this.viewerCertificate.equals(that.viewerCertificate) : that.viewerCertificate != null) return false;
                return this.webAclId != null ? this.webAclId.equals(that.webAclId) : that.webAclId == null;
            }

            @Override
            public int hashCode() {
                int result = this.enabled.hashCode();
                result = 31 * result + (this.aliases != null ? this.aliases.hashCode() : 0);
                result = 31 * result + (this.cacheBehaviors != null ? this.cacheBehaviors.hashCode() : 0);
                result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
                result = 31 * result + (this.customErrorResponses != null ? this.customErrorResponses.hashCode() : 0);
                result = 31 * result + (this.defaultCacheBehavior != null ? this.defaultCacheBehavior.hashCode() : 0);
                result = 31 * result + (this.defaultRootObject != null ? this.defaultRootObject.hashCode() : 0);
                result = 31 * result + (this.httpVersion != null ? this.httpVersion.hashCode() : 0);
                result = 31 * result + (this.ipv6Enabled != null ? this.ipv6Enabled.hashCode() : 0);
                result = 31 * result + (this.logging != null ? this.logging.hashCode() : 0);
                result = 31 * result + (this.originGroups != null ? this.originGroups.hashCode() : 0);
                result = 31 * result + (this.origins != null ? this.origins.hashCode() : 0);
                result = 31 * result + (this.priceClass != null ? this.priceClass.hashCode() : 0);
                result = 31 * result + (this.restrictions != null ? this.restrictions.hashCode() : 0);
                result = 31 * result + (this.viewerCertificate != null ? this.viewerCertificate.hashCode() : 0);
                result = 31 * result + (this.webAclId != null ? this.webAclId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.ForwardedValuesProperty")
    @software.amazon.jsii.Jsii.Proxy(ForwardedValuesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ForwardedValuesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.ForwardedValuesProperty.QueryString`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystring
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryString();

        /**
         * `CfnDistribution.ForwardedValuesProperty.Cookies`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-cookies
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCookies() {
            return null;
        }

        /**
         * `CfnDistribution.ForwardedValuesProperty.Headers`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-headers
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getHeaders() {
            return null;
        }

        /**
         * `CfnDistribution.ForwardedValuesProperty.QueryStringCacheKeys`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-forwardedvalues.html#cfn-cloudfront-distribution-forwardedvalues-querystringcachekeys
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getQueryStringCacheKeys() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ForwardedValuesProperty> {
            private java.lang.Object queryString;
            private java.lang.Object cookies;
            private java.util.List<java.lang.String> headers;
            private java.util.List<java.lang.String> queryStringCacheKeys;

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryString}
             * @param queryString `CfnDistribution.ForwardedValuesProperty.QueryString`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(java.lang.Boolean queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryString}
             * @param queryString `CfnDistribution.ForwardedValuesProperty.QueryString`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryString(software.amazon.awscdk.core.IResolvable queryString) {
                this.queryString = queryString;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getCookies}
             * @param cookies `CfnDistribution.ForwardedValuesProperty.Cookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.core.IResolvable cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getCookies}
             * @param cookies `CfnDistribution.ForwardedValuesProperty.Cookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cookies(software.amazon.awscdk.services.cloudfront.CfnDistribution.CookiesProperty cookies) {
                this.cookies = cookies;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getHeaders}
             * @param headers `CfnDistribution.ForwardedValuesProperty.Headers`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headers(java.util.List<java.lang.String> headers) {
                this.headers = headers;
                return this;
            }

            /**
             * Sets the value of {@link ForwardedValuesProperty#getQueryStringCacheKeys}
             * @param queryStringCacheKeys `CfnDistribution.ForwardedValuesProperty.QueryStringCacheKeys`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryStringCacheKeys(java.util.List<java.lang.String> queryStringCacheKeys) {
                this.queryStringCacheKeys = queryStringCacheKeys;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ForwardedValuesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ForwardedValuesProperty build() {
                return new Jsii$Proxy(queryString, cookies, headers, queryStringCacheKeys);
            }
        }

        /**
         * An implementation for {@link ForwardedValuesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ForwardedValuesProperty {
            private final java.lang.Object queryString;
            private final java.lang.Object cookies;
            private final java.util.List<java.lang.String> headers;
            private final java.util.List<java.lang.String> queryStringCacheKeys;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryString = this.jsiiGet("queryString", java.lang.Object.class);
                this.cookies = this.jsiiGet("cookies", java.lang.Object.class);
                this.headers = this.jsiiGet("headers", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.queryStringCacheKeys = this.jsiiGet("queryStringCacheKeys", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object queryString, final java.lang.Object cookies, final java.util.List<java.lang.String> headers, final java.util.List<java.lang.String> queryStringCacheKeys) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryString = java.util.Objects.requireNonNull(queryString, "queryString is required");
                this.cookies = cookies;
                this.headers = headers;
                this.queryStringCacheKeys = queryStringCacheKeys;
            }

            @Override
            public java.lang.Object getQueryString() {
                return this.queryString;
            }

            @Override
            public java.lang.Object getCookies() {
                return this.cookies;
            }

            @Override
            public java.util.List<java.lang.String> getHeaders() {
                return this.headers;
            }

            @Override
            public java.util.List<java.lang.String> getQueryStringCacheKeys() {
                return this.queryStringCacheKeys;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryString", om.valueToTree(this.getQueryString()));
                if (this.getCookies() != null) {
                    data.set("cookies", om.valueToTree(this.getCookies()));
                }
                if (this.getHeaders() != null) {
                    data.set("headers", om.valueToTree(this.getHeaders()));
                }
                if (this.getQueryStringCacheKeys() != null) {
                    data.set("queryStringCacheKeys", om.valueToTree(this.getQueryStringCacheKeys()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.ForwardedValuesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ForwardedValuesProperty.Jsii$Proxy that = (ForwardedValuesProperty.Jsii$Proxy) o;

                if (!queryString.equals(that.queryString)) return false;
                if (this.cookies != null ? !this.cookies.equals(that.cookies) : that.cookies != null) return false;
                if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
                return this.queryStringCacheKeys != null ? this.queryStringCacheKeys.equals(that.queryStringCacheKeys) : that.queryStringCacheKeys == null;
            }

            @Override
            public int hashCode() {
                int result = this.queryString.hashCode();
                result = 31 * result + (this.cookies != null ? this.cookies.hashCode() : 0);
                result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
                result = 31 * result + (this.queryStringCacheKeys != null ? this.queryStringCacheKeys.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.GeoRestrictionProperty")
    @software.amazon.jsii.Jsii.Proxy(GeoRestrictionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GeoRestrictionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.GeoRestrictionProperty.RestrictionType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-restrictiontype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getRestrictionType();

        /**
         * `CfnDistribution.GeoRestrictionProperty.Locations`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-georestriction.html#cfn-cloudfront-distribution-georestriction-locations
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getLocations() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GeoRestrictionProperty> {
            private java.lang.String restrictionType;
            private java.util.List<java.lang.String> locations;

            /**
             * Sets the value of {@link GeoRestrictionProperty#getRestrictionType}
             * @param restrictionType `CfnDistribution.GeoRestrictionProperty.RestrictionType`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder restrictionType(java.lang.String restrictionType) {
                this.restrictionType = restrictionType;
                return this;
            }

            /**
             * Sets the value of {@link GeoRestrictionProperty#getLocations}
             * @param locations `CfnDistribution.GeoRestrictionProperty.Locations`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder locations(java.util.List<java.lang.String> locations) {
                this.locations = locations;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GeoRestrictionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GeoRestrictionProperty build() {
                return new Jsii$Proxy(restrictionType, locations);
            }
        }

        /**
         * An implementation for {@link GeoRestrictionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GeoRestrictionProperty {
            private final java.lang.String restrictionType;
            private final java.util.List<java.lang.String> locations;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.restrictionType = this.jsiiGet("restrictionType", java.lang.String.class);
                this.locations = this.jsiiGet("locations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String restrictionType, final java.util.List<java.lang.String> locations) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.restrictionType = java.util.Objects.requireNonNull(restrictionType, "restrictionType is required");
                this.locations = locations;
            }

            @Override
            public java.lang.String getRestrictionType() {
                return this.restrictionType;
            }

            @Override
            public java.util.List<java.lang.String> getLocations() {
                return this.locations;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("restrictionType", om.valueToTree(this.getRestrictionType()));
                if (this.getLocations() != null) {
                    data.set("locations", om.valueToTree(this.getLocations()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.GeoRestrictionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GeoRestrictionProperty.Jsii$Proxy that = (GeoRestrictionProperty.Jsii$Proxy) o;

                if (!restrictionType.equals(that.restrictionType)) return false;
                return this.locations != null ? this.locations.equals(that.locations) : that.locations == null;
            }

            @Override
            public int hashCode() {
                int result = this.restrictionType.hashCode();
                result = 31 * result + (this.locations != null ? this.locations.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.LambdaFunctionAssociationProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaFunctionAssociationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaFunctionAssociationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.EventType`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-eventtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getEventType() {
            return null;
        }

        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.IncludeBody`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-includebody
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeBody() {
            return null;
        }

        /**
         * `CfnDistribution.LambdaFunctionAssociationProperty.LambdaFunctionARN`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-lambdafunctionassociation.html#cfn-cloudfront-distribution-lambdafunctionassociation-lambdafunctionarn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getLambdaFunctionArn() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionAssociationProperty> {
            private java.lang.String eventType;
            private java.lang.Object includeBody;
            private java.lang.String lambdaFunctionArn;

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getEventType}
             * @param eventType `CfnDistribution.LambdaFunctionAssociationProperty.EventType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder eventType(java.lang.String eventType) {
                this.eventType = eventType;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getIncludeBody}
             * @param includeBody `CfnDistribution.LambdaFunctionAssociationProperty.IncludeBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeBody(java.lang.Boolean includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getIncludeBody}
             * @param includeBody `CfnDistribution.LambdaFunctionAssociationProperty.IncludeBody`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeBody(software.amazon.awscdk.core.IResolvable includeBody) {
                this.includeBody = includeBody;
                return this;
            }

            /**
             * Sets the value of {@link LambdaFunctionAssociationProperty#getLambdaFunctionArn}
             * @param lambdaFunctionArn `CfnDistribution.LambdaFunctionAssociationProperty.LambdaFunctionARN`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunctionArn(java.lang.String lambdaFunctionArn) {
                this.lambdaFunctionArn = lambdaFunctionArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaFunctionAssociationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaFunctionAssociationProperty build() {
                return new Jsii$Proxy(eventType, includeBody, lambdaFunctionArn);
            }
        }

        /**
         * An implementation for {@link LambdaFunctionAssociationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionAssociationProperty {
            private final java.lang.String eventType;
            private final java.lang.Object includeBody;
            private final java.lang.String lambdaFunctionArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.eventType = this.jsiiGet("eventType", java.lang.String.class);
                this.includeBody = this.jsiiGet("includeBody", java.lang.Object.class);
                this.lambdaFunctionArn = this.jsiiGet("lambdaFunctionArn", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String eventType, final java.lang.Object includeBody, final java.lang.String lambdaFunctionArn) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.eventType = eventType;
                this.includeBody = includeBody;
                this.lambdaFunctionArn = lambdaFunctionArn;
            }

            @Override
            public java.lang.String getEventType() {
                return this.eventType;
            }

            @Override
            public java.lang.Object getIncludeBody() {
                return this.includeBody;
            }

            @Override
            public java.lang.String getLambdaFunctionArn() {
                return this.lambdaFunctionArn;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getEventType() != null) {
                    data.set("eventType", om.valueToTree(this.getEventType()));
                }
                if (this.getIncludeBody() != null) {
                    data.set("includeBody", om.valueToTree(this.getIncludeBody()));
                }
                if (this.getLambdaFunctionArn() != null) {
                    data.set("lambdaFunctionArn", om.valueToTree(this.getLambdaFunctionArn()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.LambdaFunctionAssociationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaFunctionAssociationProperty.Jsii$Proxy that = (LambdaFunctionAssociationProperty.Jsii$Proxy) o;

                if (this.eventType != null ? !this.eventType.equals(that.eventType) : that.eventType != null) return false;
                if (this.includeBody != null ? !this.includeBody.equals(that.includeBody) : that.includeBody != null) return false;
                return this.lambdaFunctionArn != null ? this.lambdaFunctionArn.equals(that.lambdaFunctionArn) : that.lambdaFunctionArn == null;
            }

            @Override
            public int hashCode() {
                int result = this.eventType != null ? this.eventType.hashCode() : 0;
                result = 31 * result + (this.includeBody != null ? this.includeBody.hashCode() : 0);
                result = 31 * result + (this.lambdaFunctionArn != null ? this.lambdaFunctionArn.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.LoggingProperty")
    @software.amazon.jsii.Jsii.Proxy(LoggingProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LoggingProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.LoggingProperty.Bucket`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-bucket
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * `CfnDistribution.LoggingProperty.IncludeCookies`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-includecookies
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeCookies() {
            return null;
        }

        /**
         * `CfnDistribution.LoggingProperty.Prefix`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-logging.html#cfn-cloudfront-distribution-logging-prefix
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getPrefix() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LoggingProperty> {
            private java.lang.String bucket;
            private java.lang.Object includeCookies;
            private java.lang.String prefix;

            /**
             * Sets the value of {@link LoggingProperty#getBucket}
             * @param bucket `CfnDistribution.LoggingProperty.Bucket`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getIncludeCookies}
             * @param includeCookies `CfnDistribution.LoggingProperty.IncludeCookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCookies(java.lang.Boolean includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getIncludeCookies}
             * @param includeCookies `CfnDistribution.LoggingProperty.IncludeCookies`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeCookies(software.amazon.awscdk.core.IResolvable includeCookies) {
                this.includeCookies = includeCookies;
                return this;
            }

            /**
             * Sets the value of {@link LoggingProperty#getPrefix}
             * @param prefix `CfnDistribution.LoggingProperty.Prefix`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prefix(java.lang.String prefix) {
                this.prefix = prefix;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LoggingProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LoggingProperty build() {
                return new Jsii$Proxy(bucket, includeCookies, prefix);
            }
        }

        /**
         * An implementation for {@link LoggingProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LoggingProperty {
            private final java.lang.String bucket;
            private final java.lang.Object includeCookies;
            private final java.lang.String prefix;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = this.jsiiGet("bucket", java.lang.String.class);
                this.includeCookies = this.jsiiGet("includeCookies", java.lang.Object.class);
                this.prefix = this.jsiiGet("prefix", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String bucket, final java.lang.Object includeCookies, final java.lang.String prefix) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(bucket, "bucket is required");
                this.includeCookies = includeCookies;
                this.prefix = prefix;
            }

            @Override
            public java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public java.lang.Object getIncludeCookies() {
                return this.includeCookies;
            }

            @Override
            public java.lang.String getPrefix() {
                return this.prefix;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                if (this.getIncludeCookies() != null) {
                    data.set("includeCookies", om.valueToTree(this.getIncludeCookies()));
                }
                if (this.getPrefix() != null) {
                    data.set("prefix", om.valueToTree(this.getPrefix()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.LoggingProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LoggingProperty.Jsii$Proxy that = (LoggingProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (this.includeCookies != null ? !this.includeCookies.equals(that.includeCookies) : that.includeCookies != null) return false;
                return this.prefix != null ? this.prefix.equals(that.prefix) : that.prefix == null;
            }

            @Override
            public int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.includeCookies != null ? this.includeCookies.hashCode() : 0);
                result = 31 * result + (this.prefix != null ? this.prefix.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.OriginCustomHeaderProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginCustomHeaderProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginCustomHeaderProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginCustomHeaderProperty.HeaderName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headername
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderName();

        /**
         * `CfnDistribution.OriginCustomHeaderProperty.HeaderValue`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origincustomheader.html#cfn-cloudfront-distribution-origincustomheader-headervalue
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getHeaderValue();

        /**
         * @return a {@link Builder} of {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginCustomHeaderProperty> {
            private java.lang.String headerName;
            private java.lang.String headerValue;

            /**
             * Sets the value of {@link OriginCustomHeaderProperty#getHeaderName}
             * @param headerName `CfnDistribution.OriginCustomHeaderProperty.HeaderName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerName(java.lang.String headerName) {
                this.headerName = headerName;
                return this;
            }

            /**
             * Sets the value of {@link OriginCustomHeaderProperty#getHeaderValue}
             * @param headerValue `CfnDistribution.OriginCustomHeaderProperty.HeaderValue`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder headerValue(java.lang.String headerValue) {
                this.headerValue = headerValue;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginCustomHeaderProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginCustomHeaderProperty build() {
                return new Jsii$Proxy(headerName, headerValue);
            }
        }

        /**
         * An implementation for {@link OriginCustomHeaderProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginCustomHeaderProperty {
            private final java.lang.String headerName;
            private final java.lang.String headerValue;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.headerName = this.jsiiGet("headerName", java.lang.String.class);
                this.headerValue = this.jsiiGet("headerValue", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String headerName, final java.lang.String headerValue) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.headerName = java.util.Objects.requireNonNull(headerName, "headerName is required");
                this.headerValue = java.util.Objects.requireNonNull(headerValue, "headerValue is required");
            }

            @Override
            public java.lang.String getHeaderName() {
                return this.headerName;
            }

            @Override
            public java.lang.String getHeaderValue() {
                return this.headerValue;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("headerName", om.valueToTree(this.getHeaderName()));
                data.set("headerValue", om.valueToTree(this.getHeaderValue()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.OriginCustomHeaderProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginCustomHeaderProperty.Jsii$Proxy that = (OriginCustomHeaderProperty.Jsii$Proxy) o;

                if (!headerName.equals(that.headerName)) return false;
                return this.headerValue.equals(that.headerValue);
            }

            @Override
            public int hashCode() {
                int result = this.headerName.hashCode();
                result = 31 * result + (this.headerValue.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupFailoverCriteriaProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupFailoverCriteriaProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupFailoverCriteriaProperty.StatusCodes`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupfailovercriteria.html#cfn-cloudfront-distribution-origingroupfailovercriteria-statuscodes
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getStatusCodes();

        /**
         * @return a {@link Builder} of {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupFailoverCriteriaProperty> {
            private java.lang.Object statusCodes;

            /**
             * Sets the value of {@link OriginGroupFailoverCriteriaProperty#getStatusCodes}
             * @param statusCodes `CfnDistribution.OriginGroupFailoverCriteriaProperty.StatusCodes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCodes(software.amazon.awscdk.core.IResolvable statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupFailoverCriteriaProperty#getStatusCodes}
             * @param statusCodes `CfnDistribution.OriginGroupFailoverCriteriaProperty.StatusCodes`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder statusCodes(software.amazon.awscdk.services.cloudfront.CfnDistribution.StatusCodesProperty statusCodes) {
                this.statusCodes = statusCodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupFailoverCriteriaProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupFailoverCriteriaProperty build() {
                return new Jsii$Proxy(statusCodes);
            }
        }

        /**
         * An implementation for {@link OriginGroupFailoverCriteriaProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupFailoverCriteriaProperty {
            private final java.lang.Object statusCodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.statusCodes = this.jsiiGet("statusCodes", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object statusCodes) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCodes = java.util.Objects.requireNonNull(statusCodes, "statusCodes is required");
            }

            @Override
            public java.lang.Object getStatusCodes() {
                return this.statusCodes;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("statusCodes", om.valueToTree(this.getStatusCodes()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupFailoverCriteriaProperty.Jsii$Proxy that = (OriginGroupFailoverCriteriaProperty.Jsii$Proxy) o;

                return this.statusCodes.equals(that.statusCodes);
            }

            @Override
            public int hashCode() {
                int result = this.statusCodes.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupMemberProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupMemberProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupMemberProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupMemberProperty.OriginId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmember.html#cfn-cloudfront-distribution-origingroupmember-originid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getOriginId();

        /**
         * @return a {@link Builder} of {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupMemberProperty> {
            private java.lang.String originId;

            /**
             * Sets the value of {@link OriginGroupMemberProperty#getOriginId}
             * @param originId `CfnDistribution.OriginGroupMemberProperty.OriginId`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originId(java.lang.String originId) {
                this.originId = originId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupMemberProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupMemberProperty build() {
                return new Jsii$Proxy(originId);
            }
        }

        /**
         * An implementation for {@link OriginGroupMemberProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupMemberProperty {
            private final java.lang.String originId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originId = this.jsiiGet("originId", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String originId) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originId = java.util.Objects.requireNonNull(originId, "originId is required");
            }

            @Override
            public java.lang.String getOriginId() {
                return this.originId;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("originId", om.valueToTree(this.getOriginId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupMemberProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupMemberProperty.Jsii$Proxy that = (OriginGroupMemberProperty.Jsii$Proxy) o;

                return this.originId.equals(that.originId);
            }

            @Override
            public int hashCode() {
                int result = this.originId.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupMembersProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupMembersProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupMembersProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupMembersProperty.Items`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-items
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * `CfnDistribution.OriginGroupMembersProperty.Quantity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroupmembers.html#cfn-cloudfront-distribution-origingroupmembers-quantity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * @return a {@link Builder} of {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupMembersProperty> {
            private java.lang.Object items;
            private java.lang.Number quantity;

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getItems}
             * @param items `CfnDistribution.OriginGroupMembersProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.core.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getItems}
             * @param items `CfnDistribution.OriginGroupMembersProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupMembersProperty#getQuantity}
             * @param quantity `CfnDistribution.OriginGroupMembersProperty.Quantity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupMembersProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupMembersProperty build() {
                return new Jsii$Proxy(items, quantity);
            }
        }

        /**
         * An implementation for {@link OriginGroupMembersProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupMembersProperty {
            private final java.lang.Object items;
            private final java.lang.Number quantity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = this.jsiiGet("items", java.lang.Object.class);
                this.quantity = this.jsiiGet("quantity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object items, final java.lang.Number quantity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(items, "items is required");
                this.quantity = java.util.Objects.requireNonNull(quantity, "quantity is required");
            }

            @Override
            public java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));
                data.set("quantity", om.valueToTree(this.getQuantity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupMembersProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupMembersProperty.Jsii$Proxy that = (OriginGroupMembersProperty.Jsii$Proxy) o;

                if (!items.equals(that.items)) return false;
                return this.quantity.equals(that.quantity);
            }

            @Override
            public int hashCode() {
                int result = this.items.hashCode();
                result = 31 * result + (this.quantity.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupProperty.FailoverCriteria`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-failovercriteria
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFailoverCriteria();

        /**
         * `CfnDistribution.OriginGroupProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnDistribution.OriginGroupProperty.Members`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroup.html#cfn-cloudfront-distribution-origingroup-members
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getMembers();

        /**
         * @return a {@link Builder} of {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupProperty> {
            private java.lang.Object failoverCriteria;
            private java.lang.String id;
            private java.lang.Object members;

            /**
             * Sets the value of {@link OriginGroupProperty#getFailoverCriteria}
             * @param failoverCriteria `CfnDistribution.OriginGroupProperty.FailoverCriteria`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverCriteria(software.amazon.awscdk.core.IResolvable failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getFailoverCriteria}
             * @param failoverCriteria `CfnDistribution.OriginGroupProperty.FailoverCriteria`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder failoverCriteria(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupFailoverCriteriaProperty failoverCriteria) {
                this.failoverCriteria = failoverCriteria;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getId}
             * @param id `CfnDistribution.OriginGroupProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getMembers}
             * @param members `CfnDistribution.OriginGroupProperty.Members`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder members(software.amazon.awscdk.core.IResolvable members) {
                this.members = members;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupProperty#getMembers}
             * @param members `CfnDistribution.OriginGroupProperty.Members`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder members(software.amazon.awscdk.services.cloudfront.CfnDistribution.OriginGroupMembersProperty members) {
                this.members = members;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupProperty build() {
                return new Jsii$Proxy(failoverCriteria, id, members);
            }
        }

        /**
         * An implementation for {@link OriginGroupProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupProperty {
            private final java.lang.Object failoverCriteria;
            private final java.lang.String id;
            private final java.lang.Object members;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.failoverCriteria = this.jsiiGet("failoverCriteria", java.lang.Object.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.members = this.jsiiGet("members", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object failoverCriteria, final java.lang.String id, final java.lang.Object members) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.failoverCriteria = java.util.Objects.requireNonNull(failoverCriteria, "failoverCriteria is required");
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.members = java.util.Objects.requireNonNull(members, "members is required");
            }

            @Override
            public java.lang.Object getFailoverCriteria() {
                return this.failoverCriteria;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Object getMembers() {
                return this.members;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("failoverCriteria", om.valueToTree(this.getFailoverCriteria()));
                data.set("id", om.valueToTree(this.getId()));
                data.set("members", om.valueToTree(this.getMembers()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupProperty.Jsii$Proxy that = (OriginGroupProperty.Jsii$Proxy) o;

                if (!failoverCriteria.equals(that.failoverCriteria)) return false;
                if (!id.equals(that.id)) return false;
                return this.members.equals(that.members);
            }

            @Override
            public int hashCode() {
                int result = this.failoverCriteria.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.members.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupsProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginGroupsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginGroupsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginGroupsProperty.Quantity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-quantity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * `CfnDistribution.OriginGroupsProperty.Items`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origingroups.html#cfn-cloudfront-distribution-origingroups-items
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getItems() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginGroupsProperty> {
            private java.lang.Number quantity;
            private java.lang.Object items;

            /**
             * Sets the value of {@link OriginGroupsProperty#getQuantity}
             * @param quantity `CfnDistribution.OriginGroupsProperty.Quantity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupsProperty#getItems}
             * @param items `CfnDistribution.OriginGroupsProperty.Items`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.core.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link OriginGroupsProperty#getItems}
             * @param items `CfnDistribution.OriginGroupsProperty.Items`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<java.lang.Object> items) {
                this.items = items;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginGroupsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginGroupsProperty build() {
                return new Jsii$Proxy(quantity, items);
            }
        }

        /**
         * An implementation for {@link OriginGroupsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupsProperty {
            private final java.lang.Number quantity;
            private final java.lang.Object items;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.quantity = this.jsiiGet("quantity", java.lang.Number.class);
                this.items = this.jsiiGet("items", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Number quantity, final java.lang.Object items) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.quantity = java.util.Objects.requireNonNull(quantity, "quantity is required");
                this.items = items;
            }

            @Override
            public java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            public java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("quantity", om.valueToTree(this.getQuantity()));
                if (this.getItems() != null) {
                    data.set("items", om.valueToTree(this.getItems()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.OriginGroupsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginGroupsProperty.Jsii$Proxy that = (OriginGroupsProperty.Jsii$Proxy) o;

                if (!quantity.equals(that.quantity)) return false;
                return this.items != null ? this.items.equals(that.items) : that.items == null;
            }

            @Override
            public int hashCode() {
                int result = this.quantity.hashCode();
                result = 31 * result + (this.items != null ? this.items.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.OriginProperty")
    @software.amazon.jsii.Jsii.Proxy(OriginProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface OriginProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.OriginProperty.DomainName`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-domainname
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

        /**
         * `CfnDistribution.OriginProperty.Id`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-id
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getId();

        /**
         * `CfnDistribution.OriginProperty.ConnectionAttempts`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectionattempts
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionAttempts() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.ConnectionTimeout`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-connectiontimeout
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getConnectionTimeout() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.CustomOriginConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-customoriginconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCustomOriginConfig() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.OriginCustomHeaders`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-origincustomheaders
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOriginCustomHeaders() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.OriginPath`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-originpath
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginPath() {
            return null;
        }

        /**
         * `CfnDistribution.OriginProperty.S3OriginConfig`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-origin.html#cfn-cloudfront-distribution-origin-s3originconfig
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3OriginConfig() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<OriginProperty> {
            private java.lang.String domainName;
            private java.lang.String id;
            private java.lang.Number connectionAttempts;
            private java.lang.Number connectionTimeout;
            private java.lang.Object customOriginConfig;
            private java.lang.Object originCustomHeaders;
            private java.lang.String originPath;
            private java.lang.Object s3OriginConfig;

            /**
             * Sets the value of {@link OriginProperty#getDomainName}
             * @param domainName `CfnDistribution.OriginProperty.DomainName`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder domainName(java.lang.String domainName) {
                this.domainName = domainName;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getId}
             * @param id `CfnDistribution.OriginProperty.Id`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder id(java.lang.String id) {
                this.id = id;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getConnectionAttempts}
             * @param connectionAttempts `CfnDistribution.OriginProperty.ConnectionAttempts`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionAttempts(java.lang.Number connectionAttempts) {
                this.connectionAttempts = connectionAttempts;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getConnectionTimeout}
             * @param connectionTimeout `CfnDistribution.OriginProperty.ConnectionTimeout`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connectionTimeout(java.lang.Number connectionTimeout) {
                this.connectionTimeout = connectionTimeout;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getCustomOriginConfig}
             * @param customOriginConfig `CfnDistribution.OriginProperty.CustomOriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOriginConfig(software.amazon.awscdk.core.IResolvable customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getCustomOriginConfig}
             * @param customOriginConfig `CfnDistribution.OriginProperty.CustomOriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customOriginConfig(software.amazon.awscdk.services.cloudfront.CfnDistribution.CustomOriginConfigProperty customOriginConfig) {
                this.customOriginConfig = customOriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginCustomHeaders}
             * @param originCustomHeaders `CfnDistribution.OriginProperty.OriginCustomHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originCustomHeaders(software.amazon.awscdk.core.IResolvable originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginCustomHeaders}
             * @param originCustomHeaders `CfnDistribution.OriginProperty.OriginCustomHeaders`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originCustomHeaders(java.util.List<java.lang.Object> originCustomHeaders) {
                this.originCustomHeaders = originCustomHeaders;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getOriginPath}
             * @param originPath `CfnDistribution.OriginProperty.OriginPath`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originPath(java.lang.String originPath) {
                this.originPath = originPath;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getS3OriginConfig}
             * @param s3OriginConfig `CfnDistribution.OriginProperty.S3OriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OriginConfig(software.amazon.awscdk.core.IResolvable s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            /**
             * Sets the value of {@link OriginProperty#getS3OriginConfig}
             * @param s3OriginConfig `CfnDistribution.OriginProperty.S3OriginConfig`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3OriginConfig(software.amazon.awscdk.services.cloudfront.CfnDistribution.S3OriginConfigProperty s3OriginConfig) {
                this.s3OriginConfig = s3OriginConfig;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link OriginProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public OriginProperty build() {
                return new Jsii$Proxy(domainName, id, connectionAttempts, connectionTimeout, customOriginConfig, originCustomHeaders, originPath, s3OriginConfig);
            }
        }

        /**
         * An implementation for {@link OriginProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginProperty {
            private final java.lang.String domainName;
            private final java.lang.String id;
            private final java.lang.Number connectionAttempts;
            private final java.lang.Number connectionTimeout;
            private final java.lang.Object customOriginConfig;
            private final java.lang.Object originCustomHeaders;
            private final java.lang.String originPath;
            private final java.lang.Object s3OriginConfig;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.domainName = this.jsiiGet("domainName", java.lang.String.class);
                this.id = this.jsiiGet("id", java.lang.String.class);
                this.connectionAttempts = this.jsiiGet("connectionAttempts", java.lang.Number.class);
                this.connectionTimeout = this.jsiiGet("connectionTimeout", java.lang.Number.class);
                this.customOriginConfig = this.jsiiGet("customOriginConfig", java.lang.Object.class);
                this.originCustomHeaders = this.jsiiGet("originCustomHeaders", java.lang.Object.class);
                this.originPath = this.jsiiGet("originPath", java.lang.String.class);
                this.s3OriginConfig = this.jsiiGet("s3OriginConfig", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String domainName, final java.lang.String id, final java.lang.Number connectionAttempts, final java.lang.Number connectionTimeout, final java.lang.Object customOriginConfig, final java.lang.Object originCustomHeaders, final java.lang.String originPath, final java.lang.Object s3OriginConfig) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
                this.id = java.util.Objects.requireNonNull(id, "id is required");
                this.connectionAttempts = connectionAttempts;
                this.connectionTimeout = connectionTimeout;
                this.customOriginConfig = customOriginConfig;
                this.originCustomHeaders = originCustomHeaders;
                this.originPath = originPath;
                this.s3OriginConfig = s3OriginConfig;
            }

            @Override
            public java.lang.String getDomainName() {
                return this.domainName;
            }

            @Override
            public java.lang.String getId() {
                return this.id;
            }

            @Override
            public java.lang.Number getConnectionAttempts() {
                return this.connectionAttempts;
            }

            @Override
            public java.lang.Number getConnectionTimeout() {
                return this.connectionTimeout;
            }

            @Override
            public java.lang.Object getCustomOriginConfig() {
                return this.customOriginConfig;
            }

            @Override
            public java.lang.Object getOriginCustomHeaders() {
                return this.originCustomHeaders;
            }

            @Override
            public java.lang.String getOriginPath() {
                return this.originPath;
            }

            @Override
            public java.lang.Object getS3OriginConfig() {
                return this.s3OriginConfig;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("domainName", om.valueToTree(this.getDomainName()));
                data.set("id", om.valueToTree(this.getId()));
                if (this.getConnectionAttempts() != null) {
                    data.set("connectionAttempts", om.valueToTree(this.getConnectionAttempts()));
                }
                if (this.getConnectionTimeout() != null) {
                    data.set("connectionTimeout", om.valueToTree(this.getConnectionTimeout()));
                }
                if (this.getCustomOriginConfig() != null) {
                    data.set("customOriginConfig", om.valueToTree(this.getCustomOriginConfig()));
                }
                if (this.getOriginCustomHeaders() != null) {
                    data.set("originCustomHeaders", om.valueToTree(this.getOriginCustomHeaders()));
                }
                if (this.getOriginPath() != null) {
                    data.set("originPath", om.valueToTree(this.getOriginPath()));
                }
                if (this.getS3OriginConfig() != null) {
                    data.set("s3OriginConfig", om.valueToTree(this.getS3OriginConfig()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.OriginProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                OriginProperty.Jsii$Proxy that = (OriginProperty.Jsii$Proxy) o;

                if (!domainName.equals(that.domainName)) return false;
                if (!id.equals(that.id)) return false;
                if (this.connectionAttempts != null ? !this.connectionAttempts.equals(that.connectionAttempts) : that.connectionAttempts != null) return false;
                if (this.connectionTimeout != null ? !this.connectionTimeout.equals(that.connectionTimeout) : that.connectionTimeout != null) return false;
                if (this.customOriginConfig != null ? !this.customOriginConfig.equals(that.customOriginConfig) : that.customOriginConfig != null) return false;
                if (this.originCustomHeaders != null ? !this.originCustomHeaders.equals(that.originCustomHeaders) : that.originCustomHeaders != null) return false;
                if (this.originPath != null ? !this.originPath.equals(that.originPath) : that.originPath != null) return false;
                return this.s3OriginConfig != null ? this.s3OriginConfig.equals(that.s3OriginConfig) : that.s3OriginConfig == null;
            }

            @Override
            public int hashCode() {
                int result = this.domainName.hashCode();
                result = 31 * result + (this.id.hashCode());
                result = 31 * result + (this.connectionAttempts != null ? this.connectionAttempts.hashCode() : 0);
                result = 31 * result + (this.connectionTimeout != null ? this.connectionTimeout.hashCode() : 0);
                result = 31 * result + (this.customOriginConfig != null ? this.customOriginConfig.hashCode() : 0);
                result = 31 * result + (this.originCustomHeaders != null ? this.originCustomHeaders.hashCode() : 0);
                result = 31 * result + (this.originPath != null ? this.originPath.hashCode() : 0);
                result = 31 * result + (this.s3OriginConfig != null ? this.s3OriginConfig.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.RestrictionsProperty")
    @software.amazon.jsii.Jsii.Proxy(RestrictionsProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RestrictionsProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.RestrictionsProperty.GeoRestriction`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-restrictions.html#cfn-cloudfront-distribution-restrictions-georestriction
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getGeoRestriction();

        /**
         * @return a {@link Builder} of {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RestrictionsProperty> {
            private java.lang.Object geoRestriction;

            /**
             * Sets the value of {@link RestrictionsProperty#getGeoRestriction}
             * @param geoRestriction `CfnDistribution.RestrictionsProperty.GeoRestriction`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestriction(software.amazon.awscdk.core.IResolvable geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            /**
             * Sets the value of {@link RestrictionsProperty#getGeoRestriction}
             * @param geoRestriction `CfnDistribution.RestrictionsProperty.GeoRestriction`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder geoRestriction(software.amazon.awscdk.services.cloudfront.CfnDistribution.GeoRestrictionProperty geoRestriction) {
                this.geoRestriction = geoRestriction;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RestrictionsProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RestrictionsProperty build() {
                return new Jsii$Proxy(geoRestriction);
            }
        }

        /**
         * An implementation for {@link RestrictionsProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RestrictionsProperty {
            private final java.lang.Object geoRestriction;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.geoRestriction = this.jsiiGet("geoRestriction", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object geoRestriction) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.geoRestriction = java.util.Objects.requireNonNull(geoRestriction, "geoRestriction is required");
            }

            @Override
            public java.lang.Object getGeoRestriction() {
                return this.geoRestriction;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("geoRestriction", om.valueToTree(this.getGeoRestriction()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.RestrictionsProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RestrictionsProperty.Jsii$Proxy that = (RestrictionsProperty.Jsii$Proxy) o;

                return this.geoRestriction.equals(that.geoRestriction);
            }

            @Override
            public int hashCode() {
                int result = this.geoRestriction.hashCode();
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.S3OriginConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(S3OriginConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3OriginConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.S3OriginConfigProperty.OriginAccessIdentity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-s3originconfig.html#cfn-cloudfront-distribution-s3originconfig-originaccessidentity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getOriginAccessIdentity() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3OriginConfigProperty> {
            private java.lang.String originAccessIdentity;

            /**
             * Sets the value of {@link S3OriginConfigProperty#getOriginAccessIdentity}
             * @param originAccessIdentity `CfnDistribution.S3OriginConfigProperty.OriginAccessIdentity`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder originAccessIdentity(java.lang.String originAccessIdentity) {
                this.originAccessIdentity = originAccessIdentity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3OriginConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3OriginConfigProperty build() {
                return new Jsii$Proxy(originAccessIdentity);
            }
        }

        /**
         * An implementation for {@link S3OriginConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3OriginConfigProperty {
            private final java.lang.String originAccessIdentity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.originAccessIdentity = this.jsiiGet("originAccessIdentity", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String originAccessIdentity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.originAccessIdentity = originAccessIdentity;
            }

            @Override
            public java.lang.String getOriginAccessIdentity() {
                return this.originAccessIdentity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getOriginAccessIdentity() != null) {
                    data.set("originAccessIdentity", om.valueToTree(this.getOriginAccessIdentity()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.S3OriginConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3OriginConfigProperty.Jsii$Proxy that = (S3OriginConfigProperty.Jsii$Proxy) o;

                return this.originAccessIdentity != null ? this.originAccessIdentity.equals(that.originAccessIdentity) : that.originAccessIdentity == null;
            }

            @Override
            public int hashCode() {
                int result = this.originAccessIdentity != null ? this.originAccessIdentity.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.StatusCodesProperty")
    @software.amazon.jsii.Jsii.Proxy(StatusCodesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StatusCodesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.StatusCodesProperty.Items`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-items
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getItems();

        /**
         * `CfnDistribution.StatusCodesProperty.Quantity`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-statuscodes.html#cfn-cloudfront-distribution-statuscodes-quantity
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getQuantity();

        /**
         * @return a {@link Builder} of {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StatusCodesProperty> {
            private java.lang.Object items;
            private java.lang.Number quantity;

            /**
             * Sets the value of {@link StatusCodesProperty#getItems}
             * @param items `CfnDistribution.StatusCodesProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(software.amazon.awscdk.core.IResolvable items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link StatusCodesProperty#getItems}
             * @param items `CfnDistribution.StatusCodesProperty.Items`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder items(java.util.List<java.lang.Number> items) {
                this.items = items;
                return this;
            }

            /**
             * Sets the value of {@link StatusCodesProperty#getQuantity}
             * @param quantity `CfnDistribution.StatusCodesProperty.Quantity`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder quantity(java.lang.Number quantity) {
                this.quantity = quantity;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StatusCodesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StatusCodesProperty build() {
                return new Jsii$Proxy(items, quantity);
            }
        }

        /**
         * An implementation for {@link StatusCodesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StatusCodesProperty {
            private final java.lang.Object items;
            private final java.lang.Number quantity;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.items = this.jsiiGet("items", java.lang.Object.class);
                this.quantity = this.jsiiGet("quantity", java.lang.Number.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.Object items, final java.lang.Number quantity) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.items = java.util.Objects.requireNonNull(items, "items is required");
                this.quantity = java.util.Objects.requireNonNull(quantity, "quantity is required");
            }

            @Override
            public java.lang.Object getItems() {
                return this.items;
            }

            @Override
            public java.lang.Number getQuantity() {
                return this.quantity;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("items", om.valueToTree(this.getItems()));
                data.set("quantity", om.valueToTree(this.getQuantity()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.StatusCodesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StatusCodesProperty.Jsii$Proxy that = (StatusCodesProperty.Jsii$Proxy) o;

                if (!items.equals(that.items)) return false;
                return this.quantity.equals(that.quantity);
            }

            @Override
            public int hashCode() {
                int result = this.items.hashCode();
                result = 31 * result + (this.quantity.hashCode());
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.CfnDistribution.ViewerCertificateProperty")
    @software.amazon.jsii.Jsii.Proxy(ViewerCertificateProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ViewerCertificateProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDistribution.ViewerCertificateProperty.AcmCertificateArn`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-acmcertificatearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getAcmCertificateArn() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.CloudFrontDefaultCertificate`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-cloudfrontdefaultcertificate
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCloudFrontDefaultCertificate() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.IamCertificateId`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-iamcertificateid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getIamCertificateId() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.MinimumProtocolVersion`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-minimumprotocolversion
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getMinimumProtocolVersion() {
            return null;
        }

        /**
         * `CfnDistribution.ViewerCertificateProperty.SslSupportMethod`.
         * <p>
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudfront-distribution-viewercertificate.html#cfn-cloudfront-distribution-viewercertificate-sslsupportmethod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getSslSupportMethod() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ViewerCertificateProperty> {
            private java.lang.String acmCertificateArn;
            private java.lang.Object cloudFrontDefaultCertificate;
            private java.lang.String iamCertificateId;
            private java.lang.String minimumProtocolVersion;
            private java.lang.String sslSupportMethod;

            /**
             * Sets the value of {@link ViewerCertificateProperty#getAcmCertificateArn}
             * @param acmCertificateArn `CfnDistribution.ViewerCertificateProperty.AcmCertificateArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder acmCertificateArn(java.lang.String acmCertificateArn) {
                this.acmCertificateArn = acmCertificateArn;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getCloudFrontDefaultCertificate}
             * @param cloudFrontDefaultCertificate `CfnDistribution.ViewerCertificateProperty.CloudFrontDefaultCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFrontDefaultCertificate(java.lang.Boolean cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getCloudFrontDefaultCertificate}
             * @param cloudFrontDefaultCertificate `CfnDistribution.ViewerCertificateProperty.CloudFrontDefaultCertificate`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder cloudFrontDefaultCertificate(software.amazon.awscdk.core.IResolvable cloudFrontDefaultCertificate) {
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getIamCertificateId}
             * @param iamCertificateId `CfnDistribution.ViewerCertificateProperty.IamCertificateId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iamCertificateId(java.lang.String iamCertificateId) {
                this.iamCertificateId = iamCertificateId;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getMinimumProtocolVersion}
             * @param minimumProtocolVersion `CfnDistribution.ViewerCertificateProperty.MinimumProtocolVersion`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minimumProtocolVersion(java.lang.String minimumProtocolVersion) {
                this.minimumProtocolVersion = minimumProtocolVersion;
                return this;
            }

            /**
             * Sets the value of {@link ViewerCertificateProperty#getSslSupportMethod}
             * @param sslSupportMethod `CfnDistribution.ViewerCertificateProperty.SslSupportMethod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sslSupportMethod(java.lang.String sslSupportMethod) {
                this.sslSupportMethod = sslSupportMethod;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ViewerCertificateProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ViewerCertificateProperty build() {
                return new Jsii$Proxy(acmCertificateArn, cloudFrontDefaultCertificate, iamCertificateId, minimumProtocolVersion, sslSupportMethod);
            }
        }

        /**
         * An implementation for {@link ViewerCertificateProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ViewerCertificateProperty {
            private final java.lang.String acmCertificateArn;
            private final java.lang.Object cloudFrontDefaultCertificate;
            private final java.lang.String iamCertificateId;
            private final java.lang.String minimumProtocolVersion;
            private final java.lang.String sslSupportMethod;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.acmCertificateArn = this.jsiiGet("acmCertificateArn", java.lang.String.class);
                this.cloudFrontDefaultCertificate = this.jsiiGet("cloudFrontDefaultCertificate", java.lang.Object.class);
                this.iamCertificateId = this.jsiiGet("iamCertificateId", java.lang.String.class);
                this.minimumProtocolVersion = this.jsiiGet("minimumProtocolVersion", java.lang.String.class);
                this.sslSupportMethod = this.jsiiGet("sslSupportMethod", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(final java.lang.String acmCertificateArn, final java.lang.Object cloudFrontDefaultCertificate, final java.lang.String iamCertificateId, final java.lang.String minimumProtocolVersion, final java.lang.String sslSupportMethod) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.acmCertificateArn = acmCertificateArn;
                this.cloudFrontDefaultCertificate = cloudFrontDefaultCertificate;
                this.iamCertificateId = iamCertificateId;
                this.minimumProtocolVersion = minimumProtocolVersion;
                this.sslSupportMethod = sslSupportMethod;
            }

            @Override
            public java.lang.String getAcmCertificateArn() {
                return this.acmCertificateArn;
            }

            @Override
            public java.lang.Object getCloudFrontDefaultCertificate() {
                return this.cloudFrontDefaultCertificate;
            }

            @Override
            public java.lang.String getIamCertificateId() {
                return this.iamCertificateId;
            }

            @Override
            public java.lang.String getMinimumProtocolVersion() {
                return this.minimumProtocolVersion;
            }

            @Override
            public java.lang.String getSslSupportMethod() {
                return this.sslSupportMethod;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAcmCertificateArn() != null) {
                    data.set("acmCertificateArn", om.valueToTree(this.getAcmCertificateArn()));
                }
                if (this.getCloudFrontDefaultCertificate() != null) {
                    data.set("cloudFrontDefaultCertificate", om.valueToTree(this.getCloudFrontDefaultCertificate()));
                }
                if (this.getIamCertificateId() != null) {
                    data.set("iamCertificateId", om.valueToTree(this.getIamCertificateId()));
                }
                if (this.getMinimumProtocolVersion() != null) {
                    data.set("minimumProtocolVersion", om.valueToTree(this.getMinimumProtocolVersion()));
                }
                if (this.getSslSupportMethod() != null) {
                    data.set("sslSupportMethod", om.valueToTree(this.getSslSupportMethod()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.CfnDistribution.ViewerCertificateProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ViewerCertificateProperty.Jsii$Proxy that = (ViewerCertificateProperty.Jsii$Proxy) o;

                if (this.acmCertificateArn != null ? !this.acmCertificateArn.equals(that.acmCertificateArn) : that.acmCertificateArn != null) return false;
                if (this.cloudFrontDefaultCertificate != null ? !this.cloudFrontDefaultCertificate.equals(that.cloudFrontDefaultCertificate) : that.cloudFrontDefaultCertificate != null) return false;
                if (this.iamCertificateId != null ? !this.iamCertificateId.equals(that.iamCertificateId) : that.iamCertificateId != null) return false;
                if (this.minimumProtocolVersion != null ? !this.minimumProtocolVersion.equals(that.minimumProtocolVersion) : that.minimumProtocolVersion != null) return false;
                return this.sslSupportMethod != null ? this.sslSupportMethod.equals(that.sslSupportMethod) : that.sslSupportMethod == null;
            }

            @Override
            public int hashCode() {
                int result = this.acmCertificateArn != null ? this.acmCertificateArn.hashCode() : 0;
                result = 31 * result + (this.cloudFrontDefaultCertificate != null ? this.cloudFrontDefaultCertificate.hashCode() : 0);
                result = 31 * result + (this.iamCertificateId != null ? this.iamCertificateId.hashCode() : 0);
                result = 31 * result + (this.minimumProtocolVersion != null ? this.minimumProtocolVersion.hashCode() : 0);
                result = 31 * result + (this.sslSupportMethod != null ? this.sslSupportMethod.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.CfnDistribution}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.CfnDistribution> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudfront.CfnDistributionProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudfront.CfnDistributionProps.Builder();
        }

        /**
         * `AWS::CloudFront::Distribution.DistributionConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig
         * @param distributionConfig `AWS::CloudFront::Distribution.DistributionConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(final software.amazon.awscdk.core.IResolvable distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }
        /**
         * `AWS::CloudFront::Distribution.DistributionConfig`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-distributionconfig
         * @param distributionConfig `AWS::CloudFront::Distribution.DistributionConfig`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder distributionConfig(final software.amazon.awscdk.services.cloudfront.CfnDistribution.DistributionConfigProperty distributionConfig) {
            this.props.distributionConfig(distributionConfig);
            return this;
        }

        /**
         * `AWS::CloudFront::Distribution.Tags`.
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudfront-distribution.html#cfn-cloudfront-distribution-tags
         * @param tags `AWS::CloudFront::Distribution.Tags`. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.cloudfront.CfnDistribution}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.CfnDistribution build() {
            return new software.amazon.awscdk.services.cloudfront.CfnDistribution(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
