package software.amazon.awscdk.services.cloudfront;

/**
 * Configuration for custom domain names.
 * <p>
 * CloudFront can use a custom domain that you provide instead of a
 * "cloudfront.net" domain. To use this feature you must provide the list of
 * additional domains, and the ACM Certificate that CloudFront should use for
 * these additional domains.
 * <p>
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.9.0 (build 5c646d5)", date = "2020-08-19T23:25:15.512Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.AliasConfiguration")
@software.amazon.jsii.Jsii.Proxy(AliasConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface AliasConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * ARN of an AWS Certificate Manager (ACM) certificate.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.lang.String getAcmCertRef();

    /**
     * Domain names on the certificate.
     * <p>
     * Both main domain name and Subject Alternative Names.
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getNames();

    /**
     * The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
     * <p>
     * CloudFront serves your objects only to browsers or devices that support at
     * least the SSL version that you specify.
     * <p>
     * Default: - SSLv3 if sslMethod VIP, TLSv1 if sslMethod SNI
     * <p>
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol getSecurityPolicy() {
        return null;
    }

    /**
     * How CloudFront should serve HTTPS requests.
     * <p>
     * See the notes on SSLMethod if you wish to use other SSL termination types.
     * <p>
     * Default: SSLMethod.SNI
     * <p>
     * EXPERIMENTAL
     * <p>
     * @see https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_ViewerCertificate.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.SSLMethod getSslMethod() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AliasConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AliasConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    public static final class Builder implements software.amazon.jsii.Builder<AliasConfiguration> {
        private java.lang.String acmCertRef;
        private java.util.List<java.lang.String> names;
        private software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol securityPolicy;
        private software.amazon.awscdk.services.cloudfront.SSLMethod sslMethod;

        /**
         * Sets the value of {@link AliasConfiguration#getAcmCertRef}
         * @param acmCertRef ARN of an AWS Certificate Manager (ACM) certificate. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder acmCertRef(java.lang.String acmCertRef) {
            this.acmCertRef = acmCertRef;
            return this;
        }

        /**
         * Sets the value of {@link AliasConfiguration#getNames}
         * @param names Domain names on the certificate. This parameter is required.
         *              Both main domain name and Subject Alternative Names.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder names(java.util.List<java.lang.String> names) {
            this.names = names;
            return this;
        }

        /**
         * Sets the value of {@link AliasConfiguration#getSecurityPolicy}
         * @param securityPolicy The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections.
         *                       CloudFront serves your objects only to browsers or devices that support at
         *                       least the SSL version that you specify.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder securityPolicy(software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol securityPolicy) {
            this.securityPolicy = securityPolicy;
            return this;
        }

        /**
         * Sets the value of {@link AliasConfiguration#getSslMethod}
         * @param sslMethod How CloudFront should serve HTTPS requests.
         *                  See the notes on SSLMethod if you wish to use other SSL termination types.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder sslMethod(software.amazon.awscdk.services.cloudfront.SSLMethod sslMethod) {
            this.sslMethod = sslMethod;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AliasConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @Override
        public AliasConfiguration build() {
            return new Jsii$Proxy(acmCertRef, names, securityPolicy, sslMethod);
        }
    }

    /**
     * An implementation for {@link AliasConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AliasConfiguration {
        private final java.lang.String acmCertRef;
        private final java.util.List<java.lang.String> names;
        private final software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol securityPolicy;
        private final software.amazon.awscdk.services.cloudfront.SSLMethod sslMethod;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.acmCertRef = this.jsiiGet("acmCertRef", java.lang.String.class);
            this.names = this.jsiiGet("names", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.securityPolicy = this.jsiiGet("securityPolicy", software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol.class);
            this.sslMethod = this.jsiiGet("sslMethod", software.amazon.awscdk.services.cloudfront.SSLMethod.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(final java.lang.String acmCertRef, final java.util.List<java.lang.String> names, final software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol securityPolicy, final software.amazon.awscdk.services.cloudfront.SSLMethod sslMethod) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.acmCertRef = java.util.Objects.requireNonNull(acmCertRef, "acmCertRef is required");
            this.names = java.util.Objects.requireNonNull(names, "names is required");
            this.securityPolicy = securityPolicy;
            this.sslMethod = sslMethod;
        }

        @Override
        public java.lang.String getAcmCertRef() {
            return this.acmCertRef;
        }

        @Override
        public java.util.List<java.lang.String> getNames() {
            return this.names;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.SecurityPolicyProtocol getSecurityPolicy() {
            return this.securityPolicy;
        }

        @Override
        public software.amazon.awscdk.services.cloudfront.SSLMethod getSslMethod() {
            return this.sslMethod;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("acmCertRef", om.valueToTree(this.getAcmCertRef()));
            data.set("names", om.valueToTree(this.getNames()));
            if (this.getSecurityPolicy() != null) {
                data.set("securityPolicy", om.valueToTree(this.getSecurityPolicy()));
            }
            if (this.getSslMethod() != null) {
                data.set("sslMethod", om.valueToTree(this.getSslMethod()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.AliasConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AliasConfiguration.Jsii$Proxy that = (AliasConfiguration.Jsii$Proxy) o;

            if (!acmCertRef.equals(that.acmCertRef)) return false;
            if (!names.equals(that.names)) return false;
            if (this.securityPolicy != null ? !this.securityPolicy.equals(that.securityPolicy) : that.securityPolicy != null) return false;
            return this.sslMethod != null ? this.sslMethod.equals(that.sslMethod) : that.sslMethod == null;
        }

        @Override
        public int hashCode() {
            int result = this.acmCertRef.hashCode();
            result = 31 * result + (this.names.hashCode());
            result = 31 * result + (this.securityPolicy != null ? this.securityPolicy.hashCode() : 0);
            result = 31 * result + (this.sslMethod != null ? this.sslMethod.hashCode() : 0);
            return result;
        }
    }
}
