package software.amazon.awscdk.services.cloudfront;

/**
 * The failover configuration used for Origin Groups, returned in {@link OriginBindConfig.failoverConfig}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudfront.*;
 * IOrigin origin;
 * OriginFailoverConfig originFailoverConfig = OriginFailoverConfig.builder()
 *         .failoverOrigin(origin)
 *         // the properties below are optional
 *         .statusCodes(List.of(123))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.67.0 (build 2c027f5)", date = "2022-09-16T18:50:32.943Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.cloudfront.$Module.class, fqn = "@aws-cdk/aws-cloudfront.OriginFailoverConfig")
@software.amazon.jsii.Jsii.Proxy(OriginFailoverConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginFailoverConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The origin to use as the fallback origin.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin getFailoverOrigin();

    /**
     * The HTTP status codes of the response that trigger querying the failover Origin.
     * <p>
     * Default: - 500, 502, 503 and 504
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Number> getStatusCodes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OriginFailoverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginFailoverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginFailoverConfig> {
        software.amazon.awscdk.services.cloudfront.IOrigin failoverOrigin;
        java.util.List<java.lang.Number> statusCodes;

        /**
         * Sets the value of {@link OriginFailoverConfig#getFailoverOrigin}
         * @param failoverOrigin The origin to use as the fallback origin. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder failoverOrigin(software.amazon.awscdk.services.cloudfront.IOrigin failoverOrigin) {
            this.failoverOrigin = failoverOrigin;
            return this;
        }

        /**
         * Sets the value of {@link OriginFailoverConfig#getStatusCodes}
         * @param statusCodes The HTTP status codes of the response that trigger querying the failover Origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder statusCodes(java.util.List<? extends java.lang.Number> statusCodes) {
            this.statusCodes = (java.util.List<java.lang.Number>)statusCodes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginFailoverConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginFailoverConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginFailoverConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginFailoverConfig {
        private final software.amazon.awscdk.services.cloudfront.IOrigin failoverOrigin;
        private final java.util.List<java.lang.Number> statusCodes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.failoverOrigin = software.amazon.jsii.Kernel.get(this, "failoverOrigin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class));
            this.statusCodes = software.amazon.jsii.Kernel.get(this, "statusCodes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.failoverOrigin = java.util.Objects.requireNonNull(builder.failoverOrigin, "failoverOrigin is required");
            this.statusCodes = (java.util.List<java.lang.Number>)builder.statusCodes;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOrigin getFailoverOrigin() {
            return this.failoverOrigin;
        }

        @Override
        public final java.util.List<java.lang.Number> getStatusCodes() {
            return this.statusCodes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("failoverOrigin", om.valueToTree(this.getFailoverOrigin()));
            if (this.getStatusCodes() != null) {
                data.set("statusCodes", om.valueToTree(this.getStatusCodes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-cloudfront.OriginFailoverConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginFailoverConfig.Jsii$Proxy that = (OriginFailoverConfig.Jsii$Proxy) o;

            if (!failoverOrigin.equals(that.failoverOrigin)) return false;
            return this.statusCodes != null ? this.statusCodes.equals(that.statusCodes) : that.statusCodes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.failoverOrigin.hashCode();
            result = 31 * result + (this.statusCodes != null ? this.statusCodes.hashCode() : 0);
            return result;
        }
    }
}
