/*
 * Decompiled with CFR 0.152.
 */
package com.service.bluetooth;

import android.os.Parcel;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;
import com.service.bluetooth.BluetoothManager;
import com.service.bluetooth.IBluetoothManager;
import com.service.bluetooth.WLog;
import java.io.UnsupportedEncodingException;

public final class BluetoothDevice
implements Parcelable {
    private static final String TAG = "BluetoothDevice";
    public static final int ERROR = Integer.MIN_VALUE;
    public static final String ACTION_FOUND = "chleon.android.bluetooth.device.action.FOUND";
    public static final String ACTION_DISAPPEARED = "android.bluetooth.device.action.DISAPPEARED";
    public static final String ACTION_CLASS_CHANGED = "android.bluetooth.device.action.CLASS_CHANGED";
    public static final String ACTION_ACL_CONNECTED = "android.bluetooth.device.action.ACL_CONNECTED";
    public static final String ACTION_ACL_DISCONNECT_REQUESTED = "android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED";
    public static final String ACTION_ACL_DISCONNECTED = "android.bluetooth.device.action.ACL_DISCONNECTED";
    public static final String ACTION_NAME_CHANGED = "android.bluetooth.device.action.NAME_CHANGED";
    public static final String ACTION_BOND_STATE_CHANGED = "chleon.android.bluetooth.device.action.BOND_STATE_CHANGED";
    public static final String ACTION_STATE_CHANGED = "chleon.android.bluetooth.device.action.STATE_CHANGED";
    public static final String ACTION_PLAYER_STATUS = "chleon.android.bluetooth.device.action.player.status";
    public static final String ACTION_PLAYER_META_DATE_CHANGED = "chleon.android.bluetooth.device.action.player.metadate";
    public static final String EXTRA_DEVICE = "android.bluetooth.device.extra.DEVICE";
    public static final String EXTRA_STATE = "android.bluetooth.device.extra.STATE";
    public static final String EXTRA_NAME = "android.bluetooth.device.extra.NAME";
    public static final String EXTRA_RSSI = "android.bluetooth.device.extra.RSSI";
    public static final String EXTRA_CLASS = "android.bluetooth.device.extra.CLASS";
    public static final String EXTRA_BOND_STATE = "android.bluetooth.device.extra.BOND_STATE";
    public static final String EXTRA_PREVIOUS_BOND_STATE = "android.bluetooth.device.extra.PREVIOUS_BOND_STATE";
    public static final String EXTRA_CURRENT_STATE = "android.bluetooth.device.extra.STATE";
    public static final String EXTRA_PREVIOUS_STATE = "android.bluetooth.device.extra.PREVIOUS_STATE";
    public static final String EXTRA_PLAYER_STATUS = "android.bluetooth.device.extra.PLAYER_STATUS";
    public static final int PLAYER_STATUS_PLAY = 101;
    public static final int PLAYER_STATUS_PAUSE = 102;
    public static final int PLAYER_STATUS_STOP = 103;
    public static final String EXTRA_PLAYER_TITTLE = "android.bluetooth.device.extra.PLAYER_TITTLE";
    public static final int BOND_NONE = 10;
    public static final int BOND_BONDING = 11;
    public static final int BOND_BONDED = 12;
    public static final int CONNECT_CONNECTING = 30;
    public static final int CONNECT_CONNECTED = 31;
    public static final int CONNECT_DISCONNECTED = 32;
    public static final int CONNECT_DISCONNECTING = 33;
    public static final String EXTRA_REASON = "android.bluetooth.device.extra.REASON";
    public static final String EXTRA_PAIRING_VARIANT = "android.bluetooth.device.extra.PAIRING_VARIANT";
    public static final String EXTRA_PASSKEY = "android.bluetooth.device.extra.PASSKEY";
    public static final String ACTION_UUID = "android.bleutooth.device.action.UUID";
    public static final String ACTION_NAME_FAILED = "android.bluetooth.device.action.NAME_FAILED";
    public static final String ACTION_PAIRING_REQUEST = "android.bluetooth.device.action.PAIRING_REQUEST";
    public static final String ACTION_PAIRING_CANCEL = "android.bluetooth.device.action.PAIRING_CANCEL";
    public static final String ACTION_PHONE_STATE_CHANGED = "chleon.android.intent.action.PHONE_STATE";
    public static final String EXTRA_PHONE_STATE = "android.intent.action.PHONE_STATE";
    public static final String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static final int BOND_SUCCESS = 0;
    public static final int UNBOND_REASON_AUTH_FAILED = 1;
    public static final int UNBOND_REASON_AUTH_REJECTED = 2;
    public static final int UNBOND_REASON_AUTH_CANCELED = 3;
    public static final int UNBOND_REASON_REMOTE_DEVICE_DOWN = 4;
    public static final int UNBOND_REASON_DISCOVERY_IN_PROGRESS = 5;
    public static final int UNBOND_REASON_AUTH_TIMEOUT = 6;
    public static final int UNBOND_REASON_REPEATED_ATTEMPTS = 7;
    public static final int UNBOND_REASON_REMOTE_AUTH_CANCELED = 8;
    public static final int UNBOND_REASON_REMOVED = 9;
    public static final int UNBOND_REASON_MAX_DEVICE_REACHED = 10;
    public static final int PAIRING_VARIANT_PIN = 0;
    public static final int PAIRING_VARIANT_PASSKEY = 1;
    public static final int PAIRING_VARIANT_PASSKEY_CONFIRMATION = 2;
    public static final int PAIRING_VARIANT_CONSENT = 3;
    public static final int PAIRING_VARIANT_DISPLAY_PASSKEY = 4;
    public static final int PAIRING_VARIANT_OOB_CONSENT = 5;
    public static final String EXTRA_UUID = "android.bluetooth.device.extra.UUID";
    public static final int FLAG_BOND_PHONE = 64;
    public static final int FLAG_BOND_MUSIC = 32;
    public static final int FLAG_BOND_NONE = 0;
    public static final String ACTION_SIGNAL_STRENGTH_CHANGED = "chleon.android.intent.action.SIG_STRENGTH";
    public static final String EXTRA_SIGNAL_STRENGTH = "android.intent.action.SIGNAL_STRENGTH";
    public static final int CALL_STATE_IDLE = 0;
    public static final int CALL_STATE_RINGING = 1;
    public static final int CALL_STATE_OFFHOOK = 2;
    public static final int CALL_STATE_DIALING = 3;
    public static final int NETWORK_TYPE_BT = 0;
    public static final int NETWORK_TYPE_GSM = 1;
    public static final int NETWORK_TYPE_GPRS = 2;
    public static final int NETWORK_TYPE_EGPRS = 3;
    public static final int NETWORK_TYPE_WCDMA = 4;
    public static final int NETWORK_TYPE_HSDPA = 5;
    public static final int NETWORK_TYPE_HSUPA = 6;
    public static final int NETWORK_TYPE_UNKNOWN = 7;
    public static final String ACTION_PHONEBOOK_SYNC_STATUS = "chleon.android.bluetooth.device.action.phonebook.status";
    public static final String ACTION_MESSAGES_SYNC_STATUS = "chleon.android.bluetooth.device.action.messages.status";
    public static final String EXTRA_PB_SYNC_STATE = "android.intent.action.PB_STATE";
    public static final String EXTRA_MSG_SYNC_STATE = "android.intent.action.MSG_STATE";
    private static IBluetoothManager sService;
    public static final int REPEATE_CURRENT_SONG = 2;
    public static final int REPEATE_ALL_SONGS = 3;
    private final String mAddress;
    public static final Parcelable.Creator<BluetoothDevice> CREATOR;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static IBluetoothManager getService() {
        Class<BluetoothDevice> clazz = BluetoothDevice.class;
        synchronized (BluetoothDevice.class) {
            if (sService == null) {
                sService = BluetoothManager.mService;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sService;
        }
    }

    BluetoothDevice(String address) {
        BluetoothDevice.getService();
        if (!BluetoothManager.checkBluetoothAddress(address)) {
            throw new IllegalArgumentException(address + " is not a valid Bluetooth address");
        }
        this.mAddress = address;
    }

    public boolean equals(Object o) {
        if (o instanceof BluetoothDevice) {
            return this.mAddress.equals(((BluetoothDevice)o).getAddress());
        }
        return false;
    }

    public int hashCode() {
        return this.mAddress.hashCode();
    }

    public String toString() {
        return this.mAddress;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel out, int flags) {
        out.writeString(this.mAddress);
    }

    public String getAddress() {
        return this.mAddress;
    }

    private String splitChinese(int chinese_char_len, String str, int sum) {
        int charset = chinese_char_len;
        if (charset < 2 || 3 < charset) {
            return str;
        }
        int index = sum - 1;
        if (null == str || "".equals(str)) {
            return str;
        }
        if (index <= 0) {
            return str;
        }
        byte[] bt = null;
        try {
            bt = charset == 2 ? str.getBytes() : str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.getMessage();
        }
        if (null == bt) {
            return str;
        }
        if (index > bt.length - 1) {
            index = bt.length - 1;
        }
        if (bt[index] < 0) {
            int jsq = 0;
            for (int num = index; num >= 0 && bt[num] < 0; --num) {
                ++jsq;
            }
            int m = 0;
            if (charset == 2) {
                m = jsq % 2;
                String substrx = new String(bt, 0, (index -= m) + 1);
                return substrx;
            }
            m = jsq % 3;
            index -= m;
            String substrx = null;
            try {
                substrx = new String(bt, 0, index + 1, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.getMessage();
            }
            return substrx;
        }
        String substrx = null;
        if (charset == 2) {
            substrx = new String(bt, 0, index + 1);
            return substrx;
        }
        try {
            substrx = new String(bt, 0, index + 1, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.getMessage();
        }
        return substrx;
    }

    public String getName() {
        try {
            String name = sService.getRemoteName(this.mAddress);
            return this.splitChinese(3, name, 30);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public boolean createBond() {
        try {
            return sService.createBond(this.mAddress);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean connect() {
        try {
            return sService.setDeviceConnected(this.mAddress, true);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean disconnect() {
        try {
            return sService.setDeviceConnected(this.mAddress, false);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getState() {
        try {
            return sService.getState(this.mAddress);
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public boolean cancelBondProcess() {
        try {
            return sService.cancelBondProcess(this.mAddress);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean removeBond() {
        try {
            return sService.removeBond(this.mAddress);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getBondState() {
        try {
            return sService.getBondState(this.mAddress);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return 10;
        }
    }

    public ParcelUuid[] getUuids() {
        try {
            return sService.getRemoteUuids(this.mAddress);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return null;
        }
    }

    public boolean setPin(byte[] pin) {
        try {
            return sService.setPin(this.mAddress, pin);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean setPairingConfirmation(boolean confirm) {
        try {
            return sService.setPairingConfirmation(this.mAddress, confirm);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public boolean cancelPairingUserInput() {
        try {
            return sService.cancelPairingUserInput(this.mAddress);
        }
        catch (RemoteException e) {
            WLog.e(TAG, "", e);
            return false;
        }
    }

    public int getCallState() {
        try {
            return sService.getCallState();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public String getCallDetail() {
        try {
            return sService.getCallDetail();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getNetworkType() {
        try {
            return sService.getNetworkType();
        }
        catch (RemoteException remoteException) {
            return 7;
        }
    }

    public int getSignalStrength() {
        try {
            return sService.getSignalStrength();
        }
        catch (RemoteException remoteException) {
            return -1;
        }
    }

    public static byte[] convertPinToBytes(String pin) {
        byte[] pinBytes;
        if (pin == null) {
            return null;
        }
        try {
            pinBytes = pin.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            WLog.e(TAG, "UTF-8 not supported?!?");
            return null;
        }
        if (pinBytes.length <= 0 || pinBytes.length > 16) {
            return null;
        }
        return pinBytes;
    }

    public boolean setBondFlags(int bondFlag) {
        return false;
    }

    public int getBondFlags() {
        return 0;
    }

    public void resume() throws IllegalStateException {
        try {
            sService.musicResume();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void stop() throws IllegalStateException {
        try {
            sService.musicStop();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void pause() throws IllegalStateException {
        try {
            sService.musicPause();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void playNextTrack() throws IllegalStateException {
        try {
            sService.playNextTrack();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void playPreviousTrack() throws IllegalStateException {
        try {
            sService.playPreviousTrack();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getCurrentPosition() {
        try {
            return sService.getCurrentPosition();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public int getDuration() {
        try {
            return sService.getDuration();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public boolean isPlaying() {
        try {
            return sService.isPlaying();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public String getArtist() throws IllegalStateException {
        try {
            return sService.getArtist();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getAlbum() throws IllegalStateException {
        try {
            return sService.getAlbum();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getGenre() throws IllegalStateException {
        try {
            return sService.getGenre();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public String getComposer() throws IllegalStateException {
        try {
            return sService.getComposer();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public int getTrack() throws IllegalStateException {
        try {
            return sService.getTrack();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public String getTittle() throws IllegalStateException {
        try {
            return sService.getTittle();
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public boolean setRepeateMode(int mode) {
        try {
            return sService.setRepeateMode(mode);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    int getRepeateMode() {
        try {
            return sService.getRepeateMode();
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public boolean setMuteState(boolean state) {
        try {
            return sService.setMuteState(state);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void call(String number) {
        try {
            sService.call(number);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void callLastNumber() {
        try {
            sService.callLastNumber();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void recieveIncomingCall() {
        try {
            sService.recieveIncomingCall();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void disconnectCall() {
        try {
            sService.disconnectCall();
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public boolean rejectCall() {
        try {
            return sService.rejectCall();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean muteCall(boolean state) {
        try {
            return sService.muteCall(state);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isSupportPhoneBook() {
        try {
            return sService.isSupportPhoneBook(this.mAddress);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public boolean isPhoneBookSynced() {
        try {
            return sService.isPhoneBookSynced(this.mAddress);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public int getPhoneBookSyncedStatus() {
        try {
            return sService.getPhoneBookSyncedStatus(this.mAddress);
        }
        catch (RemoteException remoteException) {
            return -2;
        }
    }

    public void getPhoneBookByManual() {
        try {
            sService.getPhoneBookByManual(this.mAddress);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public int getPhoneBookSyncProgress() {
        try {
            return sService.getPhoneBookSyncProgress(this.mAddress);
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public boolean startPlayer() {
        try {
            return sService.playerStart(this.mAddress);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    static {
        CREATOR = new Parcelable.Creator<BluetoothDevice>(){

            public BluetoothDevice createFromParcel(Parcel in) {
                return new BluetoothDevice(in.readString());
            }

            public BluetoothDevice[] newArray(int size) {
                return new BluetoothDevice[size];
            }
        };
    }
}

