/*
 * Decompiled with CFR 0.152.
 */
package com.service.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;

public class BluetoothContact
implements Parcelable {
    public String name;
    public EnumMap<NumberType, List<String>> numberList = new EnumMap(NumberType.class);
    public static final Parcelable.Creator<BluetoothContact> CREATOR = new Parcelable.Creator<BluetoothContact>(){

        public BluetoothContact createFromParcel(Parcel source) {
            return new BluetoothContact(source);
        }

        public BluetoothContact[] newArray(int size) {
            return new BluetoothContact[size];
        }
    };

    public BluetoothContact() {
    }

    public BluetoothContact(Parcel source) {
        this.name = source.readString();
        source.readMap(this.numberList, BluetoothContact.class.getClassLoader());
    }

    public void addNumber(NumberType type, String number) {
        List<String> numbers = this.numberList.get((Object)type);
        if (numbers == null) {
            numbers = new ArrayList<String>();
            this.numberList.put(type, numbers);
        }
        numbers.add(number);
    }

    public List<String> getCellNumbers() {
        return this.numberList.get((Object)NumberType.NUMBER_TYPE_CELL);
    }

    public List<String> getWorkNumbers() {
        return this.numberList.get((Object)NumberType.NUMBER_TYPE_WORK);
    }

    public List<String> getHomeNumbers() {
        return this.numberList.get((Object)NumberType.NUMBER_TYPE_HOME);
    }

    public List<String> getOtherNumbers() {
        return this.numberList.get((Object)NumberType.NUMBER_TYPE_OTHER);
    }

    public List<String> getNumbersByType(NumberType numberType) {
        return this.numberList.get((Object)numberType);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        String content = this.name == null ? "" : this.name;
        dest.writeString(content);
        dest.writeMap(this.numberList);
    }

    public static enum NumberType {
        NUMBER_TYPE_HOME,
        NUMBER_TYPE_MSG,
        NUMBER_TYPE_WORK,
        NUMBER_TYPE_PREF,
        NUMBER_TYPE_FAX,
        NUMBER_TYPE_CELL,
        NUMBER_TYPE_VIDEO,
        NUMBER_TYPE_PAGER,
        NUMBER_TYPE_BBS,
        NUMBER_TYPE_MODEM,
        NUMBER_TYPE_CAR,
        NUMBER_TYPE_ISDN,
        NUMBER_TYPE_PCS,
        NUMBER_TYPE_VOICE,
        NUMBER_TYPE_OTHER;

    }
}

