/*
 * Decompiled with CFR 0.152.
 */
package sing.refreshlayout.internal;

import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.ColorRes;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import sing.refreshlayout.api.RefreshInternal;
import sing.refreshlayout.api.RefreshKernel;
import sing.refreshlayout.api.RefreshLayout;
import sing.refreshlayout.constant.SpinnerStyle;
import sing.refreshlayout.internal.ArrowDrawable;
import sing.refreshlayout.internal.InternalAbstract;
import sing.refreshlayout.internal.ProgressDrawable;
import sing.refreshlayout.util.DensityUtil;
import sing.refreshlayout.util.SmartUtil;

public abstract class InternalClassics<T extends InternalClassics>
extends InternalAbstract
implements RefreshInternal {
    public static final byte ID_TEXT_TITLE = 1;
    public static final byte ID_IMAGE_ARROW = 2;
    public static final byte ID_IMAGE_PROGRESS = 3;
    protected TextView mTitleText;
    protected ImageView mArrowView;
    protected ImageView mProgressView;
    protected LinearLayout mCenterLayout;
    protected RefreshKernel mRefreshKernel;
    protected ArrowDrawable mArrowDrawable;
    protected ProgressDrawable mProgressDrawable;
    protected Integer mAccentColor;
    protected Integer mPrimaryColor;
    protected int mBackgroundColor;
    protected int mFinishDuration = 500;
    protected int mPaddingTop = 20;
    protected int mPaddingBottom = 20;

    public InternalClassics(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mSpinnerStyle = SpinnerStyle.Translate;
        this.mArrowView = new ImageView(context);
        this.mProgressView = new ImageView(context);
        this.mTitleText = new TextView(context);
        this.mTitleText.setTextColor(-10066330);
        this.mCenterLayout = new LinearLayout(context);
        this.mCenterLayout.setGravity(1);
        this.mCenterLayout.setOrientation(1);
        InternalClassics thisView = this;
        InternalClassics thisGroup = this;
        ImageView arrowView = this.mArrowView;
        TextView titleView = this.mTitleText;
        ImageView progressView = this.mProgressView;
        LinearLayout centerLayout = this.mCenterLayout;
        DensityUtil density = new DensityUtil();
        titleView.setId(1);
        arrowView.setId(2);
        progressView.setId(3);
        centerLayout.setId(16908312);
        LinearLayout.LayoutParams lpHeaderText = new LinearLayout.LayoutParams(-2, -2);
        centerLayout.addView((View)titleView, (ViewGroup.LayoutParams)lpHeaderText);
        RelativeLayout.LayoutParams lpHeaderLayout = new RelativeLayout.LayoutParams(-2, -2);
        lpHeaderLayout.addRule(13);
        thisGroup.addView((View)centerLayout, (ViewGroup.LayoutParams)lpHeaderLayout);
        RelativeLayout.LayoutParams lpArrow = new RelativeLayout.LayoutParams(density.dip2px(20.0f), density.dip2px(20.0f));
        lpArrow.addRule(15);
        lpArrow.addRule(0, 16908312);
        thisGroup.addView((View)arrowView, (ViewGroup.LayoutParams)lpArrow);
        RelativeLayout.LayoutParams lpProgress = new RelativeLayout.LayoutParams((ViewGroup.LayoutParams)lpArrow);
        lpProgress.addRule(15);
        lpProgress.addRule(0, 16908312);
        progressView.animate().setInterpolator((TimeInterpolator)new LinearInterpolator());
        thisGroup.addView((View)progressView, (ViewGroup.LayoutParams)lpProgress);
        if (thisView.getPaddingTop() == 0) {
            if (thisView.getPaddingBottom() == 0) {
                this.mPaddingTop = density.dip2px(20.0f);
                this.mPaddingBottom = density.dip2px(20.0f);
                thisView.setPadding(thisView.getPaddingLeft(), this.mPaddingTop, thisView.getPaddingRight(), this.mPaddingBottom);
            } else {
                this.mPaddingTop = density.dip2px(20.0f);
                this.mPaddingBottom = thisView.getPaddingBottom();
                thisView.setPadding(thisView.getPaddingLeft(), this.mPaddingTop, thisView.getPaddingRight(), this.mPaddingBottom);
            }
        } else if (thisView.getPaddingBottom() == 0) {
            this.mPaddingTop = thisView.getPaddingTop();
            this.mPaddingBottom = density.dip2px(20.0f);
            thisView.setPadding(thisView.getPaddingLeft(), this.mPaddingTop, thisView.getPaddingRight(), this.mPaddingBottom);
        } else {
            this.mPaddingTop = thisView.getPaddingTop();
            this.mPaddingBottom = thisView.getPaddingBottom();
        }
        if (thisView.isInEditMode()) {
            arrowView.setVisibility(8);
        } else {
            progressView.setVisibility(8);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        InternalClassics thisView = this;
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            thisView.setPadding(thisView.getPaddingLeft(), 0, thisView.getPaddingRight(), 0);
        } else {
            thisView.setPadding(thisView.getPaddingLeft(), this.mPaddingTop, thisView.getPaddingRight(), this.mPaddingBottom);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onDetachedFromWindow() {
        Drawable drawable;
        super.onDetachedFromWindow();
        if (Build.VERSION.SDK_INT >= 14) {
            ImageView arrowView = this.mArrowView;
            ImageView progressView = this.mProgressView;
            arrowView.animate().cancel();
            progressView.animate().cancel();
        }
        if ((drawable = this.mProgressView.getDrawable()) instanceof Animatable && ((Animatable)drawable).isRunning()) {
            ((Animatable)drawable).stop();
        }
    }

    protected T self() {
        return (T)this;
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        this.mRefreshKernel = kernel;
        this.mRefreshKernel.requestDrawBackgroundFor(this, this.mBackgroundColor);
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        ImageView progressView = this.mProgressView;
        if (progressView.getVisibility() != 0) {
            progressView.setVisibility(0);
            Drawable drawable = this.mProgressView.getDrawable();
            if (drawable instanceof Animatable) {
                ((Animatable)drawable).start();
            } else {
                progressView.animate().rotation(36000.0f).setDuration(100000L);
            }
        }
    }

    @Override
    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        this.onStartAnimator(refreshLayout, height, maxDragHeight);
    }

    @Override
    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        ImageView progressView = this.mProgressView;
        Drawable drawable = this.mProgressView.getDrawable();
        if (drawable instanceof Animatable) {
            if (((Animatable)drawable).isRunning()) {
                ((Animatable)drawable).stop();
            }
        } else {
            progressView.animate().rotation(0.0f).setDuration(0L);
        }
        progressView.setVisibility(8);
        return this.mFinishDuration;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (colors.length > 0) {
            InternalClassics thisView = this;
            if (!(thisView.getBackground() instanceof BitmapDrawable) && this.mPrimaryColor == null) {
                this.setPrimaryColor(colors[0]);
                this.mPrimaryColor = null;
            }
            if (this.mAccentColor == null) {
                if (colors.length > 1) {
                    this.setAccentColor(colors[1]);
                } else {
                    this.setAccentColor(colors[0] == -1 ? -10066330 : -1);
                }
                this.mAccentColor = null;
            }
        }
    }

    public T setProgressDrawable(Drawable drawable) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageDrawable(drawable);
        return this.self();
    }

    public T setProgressResource(@DrawableRes int resId) {
        this.mProgressDrawable = null;
        this.mProgressView.setImageResource(resId);
        return this.self();
    }

    public T setArrowDrawable(Drawable drawable) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageDrawable(drawable);
        return this.self();
    }

    public T setArrowResource(@DrawableRes int resId) {
        this.mArrowDrawable = null;
        this.mArrowView.setImageResource(resId);
        return this.self();
    }

    public T setSpinnerStyle(SpinnerStyle style) {
        this.mSpinnerStyle = style;
        return this.self();
    }

    public T setPrimaryColor(@ColorInt int primaryColor) {
        this.mPrimaryColor = primaryColor;
        this.mBackgroundColor = this.mPrimaryColor;
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestDrawBackgroundFor(this, this.mPrimaryColor);
        }
        return this.self();
    }

    public T setAccentColor(@ColorInt int accentColor) {
        this.mAccentColor = accentColor;
        this.mTitleText.setTextColor(accentColor);
        if (this.mArrowDrawable != null) {
            this.mArrowDrawable.setColor(accentColor);
        }
        if (this.mProgressDrawable != null) {
            this.mProgressDrawable.setColor(accentColor);
        }
        return this.self();
    }

    public T setPrimaryColorId(@ColorRes int colorId) {
        InternalClassics thisView = this;
        this.setPrimaryColor(SmartUtil.getColor(thisView.getContext(), colorId));
        return this.self();
    }

    public T setAccentColorId(@ColorRes int colorId) {
        InternalClassics thisView = this;
        this.setAccentColor(SmartUtil.getColor(thisView.getContext(), colorId));
        return this.self();
    }

    public T setFinishDuration(int delay) {
        this.mFinishDuration = delay;
        return this.self();
    }

    public T setTextSizeTitle(float size) {
        this.mTitleText.setTextSize(size);
        if (this.mRefreshKernel != null) {
            this.mRefreshKernel.requestRemeasureHeightFor(this);
        }
        return this.self();
    }

    public T setDrawableMarginRight(float dp) {
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        ViewGroup.MarginLayoutParams lpArrow = (ViewGroup.MarginLayoutParams)arrowView.getLayoutParams();
        ViewGroup.MarginLayoutParams lpProgress = (ViewGroup.MarginLayoutParams)progressView.getLayoutParams();
        lpArrow.rightMargin = lpProgress.rightMargin = DensityUtil.dp2px(dp);
        arrowView.setLayoutParams((ViewGroup.LayoutParams)lpArrow);
        progressView.setLayoutParams((ViewGroup.LayoutParams)lpProgress);
        return this.self();
    }

    public T setDrawableSize(float dp) {
        ImageView arrowView = this.mArrowView;
        ImageView progressView = this.mProgressView;
        ViewGroup.LayoutParams lpArrow = arrowView.getLayoutParams();
        ViewGroup.LayoutParams lpProgress = progressView.getLayoutParams();
        lpArrow.width = lpProgress.width = DensityUtil.dp2px(dp);
        lpArrow.height = lpProgress.height = DensityUtil.dp2px(dp);
        arrowView.setLayoutParams(lpArrow);
        progressView.setLayoutParams(lpProgress);
        return this.self();
    }

    public T setDrawableArrowSize(float dp) {
        ImageView arrowView = this.mArrowView;
        ViewGroup.LayoutParams lpArrow = arrowView.getLayoutParams();
        lpArrow.height = lpArrow.width = DensityUtil.dp2px(dp);
        arrowView.setLayoutParams(lpArrow);
        return this.self();
    }

    public T setDrawableProgressSize(float dp) {
        ImageView progressView = this.mProgressView;
        ViewGroup.LayoutParams lpProgress = progressView.getLayoutParams();
        lpProgress.height = lpProgress.width = DensityUtil.dp2px(dp);
        progressView.setLayoutParams(lpProgress);
        return this.self();
    }
}

