/*
 * Decompiled with CFR 0.152.
 */
package sing.refreshlayout.internal;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import sing.SmartRefreshLayout;
import sing.refreshlayout.api.RefreshInternal;
import sing.refreshlayout.api.RefreshKernel;
import sing.refreshlayout.api.RefreshLayout;
import sing.refreshlayout.constant.RefreshState;
import sing.refreshlayout.constant.SpinnerStyle;

public abstract class InternalAbstract
extends RelativeLayout
implements RefreshInternal {
    protected View mWrapperView;
    protected SpinnerStyle mSpinnerStyle;

    protected InternalAbstract(@NonNull View wrapper) {
        super(wrapper.getContext(), null, 0);
        this.mWrapperView = wrapper;
    }

    protected InternalAbstract(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    @NonNull
    public View getView() {
        return this.mWrapperView == null ? this : this.mWrapperView;
    }

    @Override
    public int onFinish(@NonNull RefreshLayout refreshLayout, boolean success) {
        if (this.mWrapperView instanceof RefreshInternal) {
            return ((RefreshInternal)this.mWrapperView).onFinish(refreshLayout, success);
        }
        return 0;
    }

    @Override
    @Deprecated
    public void setPrimaryColors(int ... colors) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).setPrimaryColors(colors);
        }
    }

    @Override
    @NonNull
    public SpinnerStyle getSpinnerStyle() {
        if (this.mSpinnerStyle != null) {
            return this.mSpinnerStyle;
        }
        if (this.mWrapperView instanceof RefreshInternal) {
            return ((RefreshInternal)this.mWrapperView).getSpinnerStyle();
        }
        if (this.mWrapperView != null) {
            ViewGroup.LayoutParams params = this.mWrapperView.getLayoutParams();
            if (params instanceof SmartRefreshLayout.LayoutParams) {
                this.mSpinnerStyle = ((SmartRefreshLayout.LayoutParams)params).spinnerStyle;
                if (this.mSpinnerStyle != null) {
                    return this.mSpinnerStyle;
                }
            }
            if (params != null && (params.height == 0 || params.height == -1)) {
                this.mSpinnerStyle = SpinnerStyle.Scale;
                return this.mSpinnerStyle;
            }
        }
        this.mSpinnerStyle = SpinnerStyle.Translate;
        return this.mSpinnerStyle;
    }

    @Override
    public void onInitialized(@NonNull RefreshKernel kernel, int height, int maxDragHeight) {
        ViewGroup.LayoutParams params;
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onInitialized(kernel, height, maxDragHeight);
        } else if (this.mWrapperView != null && (params = this.mWrapperView.getLayoutParams()) instanceof SmartRefreshLayout.LayoutParams) {
            kernel.requestDrawBackgroundFor(this, ((SmartRefreshLayout.LayoutParams)params).backgroundColor);
        }
    }

    @Override
    public boolean isSupportHorizontalDrag() {
        return this.mWrapperView instanceof RefreshInternal && ((RefreshInternal)this.mWrapperView).isSupportHorizontalDrag();
    }

    @Override
    public void onHorizontalDrag(float percentX, int offsetX, int offsetMax) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onHorizontalDrag(percentX, offsetX, offsetMax);
        }
    }

    @Override
    public void onMoving(boolean isDragging, float percent, int offset, int height, int maxDragHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onMoving(isDragging, percent, offset, height, maxDragHeight);
        }
    }

    @Override
    public void onReleased(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onReleased(refreshLayout, height, maxDragHeight);
        }
    }

    @Override
    public void onStartAnimator(@NonNull RefreshLayout refreshLayout, int height, int maxDragHeight) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onStartAnimator(refreshLayout, height, maxDragHeight);
        }
    }

    @Override
    public void onStateChanged(@NonNull RefreshLayout refreshLayout, @NonNull RefreshState oldState, @NonNull RefreshState newState) {
        if (this.mWrapperView instanceof RefreshInternal) {
            ((RefreshInternal)this.mWrapperView).onStateChanged(refreshLayout, oldState, newState);
        }
    }
}

