/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json.tools;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import se.natusoft.json.JSONArray;
import se.natusoft.json.JSONBoolean;
import se.natusoft.json.JSONNull;
import se.natusoft.json.JSONNumber;
import se.natusoft.json.JSONObject;
import se.natusoft.json.JSONString;
import se.natusoft.json.JSONValue;
import se.natusoft.json.tools.JSONConvertionException;

public class JavaToJSON {
    public static JSONObject convertObject(Object javaBean) throws JSONConvertionException {
        return JavaToJSON.convertObject(new JSONObject(), javaBean);
    }

    public static JSONObject convertObject(JSONObject jsonObject, Object javaBean) throws JSONConvertionException {
        JSONObject obj = jsonObject;
        if (obj == null) {
            obj = new JSONObject();
        }
        if (javaBean instanceof Dictionary) {
            Enumeration dictEnum = ((Dictionary)javaBean).keys();
            while (dictEnum.hasMoreElements()) {
                Object key = dictEnum.nextElement();
                String value = ((Dictionary)javaBean).get(key).toString();
                obj.addProperty(key.toString(), (JSONValue)new JSONString(value));
            }
        } else if (javaBean instanceof Map) {
            for (Object key : ((Map)javaBean).keySet()) {
                Object value = ((Map)javaBean).get(key);
                obj.addProperty(key.toString(), JavaToJSON.convertValue(value));
            }
        } else {
            for (Method method : javaBean.getClass().getMethods()) {
                if (method.getName().equals("getClass") || !method.getName().startsWith("is") && (!method.getName().startsWith("get") || method.getName().length() <= 3)) continue;
                Object value = null;
                String prop = null;
                if (method.getName().startsWith("get")) {
                    prop = method.getName().substring(3);
                } else if (method.getName().startsWith("is")) {
                    prop = method.getName().substring(2);
                }
                prop = prop != null ? prop.substring(0, 1).toLowerCase() + prop.substring(1) : "bug";
                try {
                    value = method.invoke(javaBean, new Object[0]);
                }
                catch (Exception e) {
                    value = e.getMessage();
                }
                obj.addProperty(prop, JavaToJSON.convertValue(value));
            }
        }
        return obj;
    }

    public static JSONValue convertValue(Object value) {
        JSONValue json = null;
        if (value == null) {
            json = new JSONNull();
        } else if (Number.class.isAssignableFrom(value.getClass()) || Byte.TYPE.isAssignableFrom(value.getClass()) || Double.TYPE.isAssignableFrom(value.getClass()) || Float.TYPE.isAssignableFrom(value.getClass()) || Integer.TYPE.isAssignableFrom(value.getClass()) || Long.TYPE.isAssignableFrom(value.getClass()) || Short.TYPE.isAssignableFrom(value.getClass())) {
            json = new JSONNumber((Number)value);
        } else if (value instanceof String) {
            json = new JSONString((String)value);
        } else if (Boolean.TYPE.isAssignableFrom(value.getClass()) || Boolean.class.isAssignableFrom(value.getClass())) {
            json = new JSONBoolean((Boolean)value);
        } else if (value instanceof Date) {
            json = new JSONNumber(((Date)value).getTime());
        } else if (value.getClass().isArray()) {
            JSONArray array = new JSONArray();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object aValue = Array.get(value, i);
                array.addValue(JavaToJSON.convertValue(aValue));
            }
            json = array;
        } else if (value instanceof List) {
            JSONArray array = new JSONArray();
            for (Object cValue : (List)value) {
                array.addValue(JavaToJSON.convertValue(cValue));
            }
            json = array;
        } else {
            json = value.getClass().isEnum() ? new JSONString(((Enum)value).name()) : JavaToJSON.convertObject(value);
        }
        return json;
    }
}

