/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json.tools;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import se.natusoft.json.JSONArray;
import se.natusoft.json.JSONBoolean;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONNull;
import se.natusoft.json.JSONNumber;
import se.natusoft.json.JSONObject;
import se.natusoft.json.JSONString;
import se.natusoft.json.JSONValue;
import se.natusoft.json.tools.BeanInstance;
import se.natusoft.json.tools.JSONConvertionException;

public class JSONToJava {
    public static <T> T convert(InputStream jsonStream, Class<T> javaClass) throws IOException, JSONConvertionException {
        JSONErrorHandler jsonErrHandler = new JSONErrorHandler(){

            @Override
            public void warning(String message) {
            }

            @Override
            public void fail(String message, Throwable cause) throws RuntimeException {
                throw new JSONConvertionException(message, cause);
            }
        };
        JSONObject obj = new JSONObject(jsonErrHandler);
        obj.readJSON(jsonStream);
        return JSONToJava.convert(obj, javaClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T convert(String json, Class<T> javaClass) throws IOException, JSONConvertionException {
        ByteArrayInputStream bais = new ByteArrayInputStream(json.getBytes());
        T t = JSONToJava.convert(bais, javaClass);
        return t;
        finally {
            try {
                bais.close();
            }
            catch (IOException ioe) {}
        }
    }

    public static <T> T convert(JSONValue json, Class<T> javaClass) throws JSONConvertionException {
        T converted = null;
        converted = json instanceof JSONObject ? (T)JSONToJava.createAndLoadModel((JSONObject)json, javaClass) : (T)JSONToJava.convertJSONValue(json, javaClass);
        return converted;
    }

    private static void load(BeanInstance bean, JSONObject jsonObject) throws JSONConvertionException {
        for (JSONString prop : jsonObject.getPropertyNames()) {
            JSONValue value = jsonObject.getProperty(prop);
            Object convertedValue = JSONToJava.convertJSONValue(value, bean.getPropertyType(prop.toString()));
            bean.setProperty(prop.toString(), convertedValue);
        }
    }

    private static <T> T createAndLoadModel(JSONObject value, Class<T> beanType) throws JSONConvertionException {
        try {
            BeanInstance bean = new BeanInstance(beanType.newInstance());
            JSONToJava.load(bean, value);
            return (T)bean.getModelInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONConvertionException(e.getMessage(), e);
        }
    }

    private static <T> T convertJSONValue(JSONValue value, Class<T> modelType) throws JSONConvertionException {
        Map resVal = null;
        if (value instanceof JSONString) {
            resVal = value.toString();
        } else if (value instanceof JSONBoolean) {
            resVal = new Boolean(((JSONBoolean)value).getAsBoolean());
        } else if (value instanceof JSONNumber) {
            resVal = ((JSONNumber)value).to(modelType);
        } else if (value instanceof JSONArray) {
            JSONArray array = (JSONArray)value;
            ArrayList<T> arrayEntries = new ArrayList<T>();
            for (JSONValue entry : array.getAsList()) {
                if (entry instanceof JSONObject) {
                    arrayEntries.add(JSONToJava.createAndLoadModel((JSONObject)entry, modelType));
                    continue;
                }
                arrayEntries.add(JSONToJava.convertJSONValue(entry, modelType));
            }
            resVal = arrayEntries;
        } else if (value instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)value;
            if (Properties.class.isAssignableFrom(modelType)) {
                Properties props = new Properties();
                for (JSONString name : jsonObject.getPropertyNames()) {
                    JSONValue jsonValue = jsonObject.getProperty(name);
                    props.setProperty(name.toString(), jsonValue.toString());
                }
                resVal = props;
            } else {
                resVal = Map.class.isAssignableFrom(modelType) ? JSONToJava.jsonObjectToMap(jsonObject) : JSONToJava.createAndLoadModel((JSONObject)value, modelType);
            }
        } else if (value instanceof JSONNull) {
            // empty if block
        }
        return (T)resVal;
    }

    private static Map jsonObjectToMap(JSONObject jsonObject) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (JSONString name : jsonObject.getPropertyNames()) {
            JSONValue jsonValue = jsonObject.getProperty(name);
            if (jsonValue instanceof JSONString) {
                map.put(name.toString(), jsonValue.toString());
                continue;
            }
            if (jsonValue instanceof JSONBoolean) {
                map.put(name.toString(), ((JSONBoolean)jsonValue).getAsBoolean());
                continue;
            }
            if (jsonValue instanceof JSONNumber) {
                map.put(name.toString(), ((JSONNumber)jsonValue).toNumber());
                continue;
            }
            if (jsonValue instanceof JSONObject) {
                map.put(name.toString(), JSONToJava.jsonObjectToMap((JSONObject)jsonValue));
                continue;
            }
            if (!(jsonValue instanceof JSONArray)) continue;
            map.put(name.toString(), JSONToJava.jsonArrayToList((JSONArray)jsonValue));
        }
        return map;
    }

    private static List jsonArrayToList(JSONArray jsonArray) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (JSONValue jsonValue : jsonArray.getAsList()) {
            if (jsonValue instanceof JSONString) {
                list.add(jsonValue.toString());
                continue;
            }
            if (jsonValue instanceof JSONBoolean) {
                list.add(((JSONBoolean)jsonValue).getAsBoolean());
                continue;
            }
            if (jsonValue instanceof JSONNumber) {
                list.add(((JSONNumber)jsonValue).toNumber());
                continue;
            }
            if (jsonValue instanceof JSONObject) {
                list.add(JSONToJava.jsonObjectToMap((JSONObject)jsonValue));
                continue;
            }
            if (!(jsonValue instanceof JSONArray)) continue;
            list.add(JSONToJava.jsonArrayToList((JSONArray)jsonValue));
        }
        return list;
    }
}

