/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json.tools;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import se.natusoft.json.tools.JSONConvertionException;

public class BeanInstance {
    private Object modelInstance = null;

    public BeanInstance(Object modelInstance) {
        this.modelInstance = modelInstance;
    }

    public Object getModelInstance() {
        return this.modelInstance;
    }

    public List<String> getSettableProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (Method method : this.modelInstance.getClass().getMethods()) {
            if (!method.getName().startsWith("set") || method.getParameterTypes().length != 1) continue;
            String prop = method.getName().substring(3);
            prop = prop.substring(0, 1).toLowerCase() + prop.substring(1);
            properties.add(prop);
        }
        return properties;
    }

    public List<String> getGettableProperties() {
        ArrayList<String> properties = new ArrayList<String>();
        for (Method method : this.modelInstance.getClass().getMethods()) {
            if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || method.getParameterTypes().length != 0) continue;
            String prop = method.getName().substring(2);
            if (method.getName().startsWith("get")) {
                prop = prop.substring(1);
            }
            prop = prop.substring(0, 1).toLowerCase() + prop.substring(1);
            properties.add(prop);
        }
        return properties;
    }

    public void setProperty(String property, Object value) throws JSONConvertionException {
        Class propertyType = null;
        try {
            propertyType = this.getPropertyType(property);
            String methodName = "set" + property.substring(0, 1).toUpperCase() + property.substring(1);
            Method setter = this.modelInstance.getClass().getMethod(methodName, propertyType);
            Object setValue = this.convertToPropType(value, propertyType);
            setter.invoke(this.modelInstance, setValue);
        }
        catch (Exception e) {
            throw new JSONConvertionException("Failed to set property '" + property + "[" + propertyType.getSimpleName() + "]' with object '" + value + "[" + value.getClass().getSimpleName() + "]' in model '" + this.modelInstance.getClass().getName() + "! Cause: " + e.getMessage(), e);
        }
    }

    public Object getProperty(String property) throws JSONConvertionException {
        try {
            String methodName = null;
            Class propertyType = this.getPropertyType(property);
            methodName = Boolean.class.isAssignableFrom(propertyType) || Boolean.TYPE.isAssignableFrom(propertyType) ? "is" : "get";
            methodName = methodName + property.substring(0, 1).toUpperCase() + property.substring(1);
            Method getter = this.modelInstance.getClass().getMethod(methodName, new Class[0]);
            return getter.invoke(this.modelInstance, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONConvertionException("Failed to get property '" + property + "' due to '" + e.getMessage() + "'!", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object convertToPropType(Object value, Class propType) throws JSONConvertionException {
        Object setValue = null;
        if (value instanceof String) {
            String strValue = (String)value;
            if (Byte.TYPE.isAssignableFrom(propType)) return Byte.valueOf(strValue);
            if (Byte.class.isAssignableFrom(propType)) {
                return Byte.valueOf(strValue);
            }
            if (Short.TYPE.isAssignableFrom(propType)) return Short.valueOf(strValue);
            if (Short.class.isAssignableFrom(propType)) {
                return Short.valueOf(strValue);
            }
            if (Integer.TYPE.isAssignableFrom(propType)) return Integer.valueOf(strValue);
            if (Integer.class.isAssignableFrom(propType)) {
                return Integer.valueOf(strValue);
            }
            if (Long.TYPE.isAssignableFrom(propType)) return Long.valueOf(strValue);
            if (Long.class.isAssignableFrom(propType)) {
                return Long.valueOf(strValue);
            }
            if (Float.TYPE.isAssignableFrom(propType)) return Float.valueOf(strValue);
            if (Float.class.isAssignableFrom(propType)) {
                return Float.valueOf(strValue);
            }
            if (Double.TYPE.isAssignableFrom(propType)) return Double.valueOf(strValue);
            if (Double.class.isAssignableFrom(propType)) {
                return Double.valueOf(strValue);
            }
            if (Boolean.TYPE.isAssignableFrom(propType)) return Boolean.valueOf(strValue);
            if (Boolean.class.isAssignableFrom(propType)) {
                return Boolean.valueOf(strValue);
            }
            if (Character.TYPE.isAssignableFrom(propType)) return Character.valueOf(strValue.charAt(0));
            if (Character.class.isAssignableFrom(propType)) {
                return Character.valueOf(strValue.charAt(0));
            }
            if (Date.class.isAssignableFrom(propType)) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                try {
                    return sdf.parse(strValue);
                }
                catch (ParseException pe) {
                    sdf = new SimpleDateFormat("yy-MM-dd HH:mm:ss");
                    try {
                        return sdf.parse(strValue);
                    }
                    catch (ParseException pe1) {
                        sdf = new SimpleDateFormat("HH:mm:ss");
                        try {
                            return sdf.parse(strValue);
                        }
                        catch (ParseException pe2) {
                            sdf = new SimpleDateFormat("yyyy-MM-dd");
                            try {
                                return sdf.parse(strValue);
                            }
                            catch (ParseException pe3) {
                                sdf = new SimpleDateFormat("yy-MM-dd");
                                try {
                                    return sdf.parse(strValue);
                                }
                                catch (ParseException pe4) {
                                    throw new JSONConvertionException("Date string in unknown format!");
                                }
                            }
                        }
                    }
                }
            }
            if (!propType.isEnum()) return value;
            for (Object enumConstObj : propType.getEnumConstants()) {
                Enum enumConst = (Enum)enumConstObj;
                if (!enumConst.name().equals(value)) continue;
                setValue = enumConst;
                break;
            }
            if (setValue != null) return setValue;
            throw new JSONConvertionException("Bad enum const value: '" + value + "'!");
        }
        if (value instanceof List) {
            if (propType.isArray()) {
                List valueList = (List)value;
                Object array = Array.newInstance(propType.getComponentType(), valueList.size());
                int i = 0;
                while (i < valueList.size()) {
                    Object entry = valueList.get(i);
                    Array.set(array, i, this.convertToPropType(entry, propType));
                    ++i;
                }
                return array;
            }
            if (!List.class.isAssignableFrom(propType)) throw new JSONConvertionException("An array have been provided in input, but model value (" + propType.getName() + ") is not an array!");
            return value;
        }
        if (!Long.TYPE.isAssignableFrom(value.getClass())) {
            if (!Long.class.isAssignableFrom(value.getClass())) return value;
        }
        if (!Date.class.isAssignableFrom(propType)) return value;
        return new Date((Long)value);
    }

    public Class getPropertyType(String property) throws JSONConvertionException {
        String methodName = "get" + property.substring(0, 1).toUpperCase() + property.substring(1);
        try {
            Class[] params = new Class[]{};
            Method getter = this.modelInstance.getClass().getMethod(methodName, params);
            return getter.getReturnType();
        }
        catch (NoSuchMethodException nsme) {
            methodName = "is" + property.substring(0, 1).toUpperCase() + property.substring(1);
            try {
                Class[] params = new Class[]{};
                Method getter = this.modelInstance.getClass().getMethod(methodName, params);
                return getter.getReturnType();
            }
            catch (NoSuchMethodException nsme2) {
                throw new JSONConvertionException("Property of name '" + property + "' does not exist!");
            }
        }
    }
}

