/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json;

import java.io.IOException;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONValue;

public class JSONString
extends JSONValue {
    private String value = "";

    public JSONString(String value) {
        this.value = value;
    }

    public JSONString(JSONErrorHandler errorHandler) {
        super(errorHandler);
    }

    static boolean isStringStart(char c) {
        return c == '\"';
    }

    void setValue(String value) {
        this.value = value;
    }

    @Override
    protected void readJSON(char c, JSONValue.JSONReader reader) throws IOException {
        StringBuilder sb = new StringBuilder();
        c = reader.skipWhitespace(c);
        reader.assertChar(c, '\"', "Expected a quote '\"' character starting a string, found '" + c + "'!");
        boolean stringEscape = true;
        c = reader.readUntil("\"", sb, stringEscape);
        this.value = sb.toString();
    }

    @Override
    protected void writeJSON(JSONValue.JSONWriter writer, boolean compact) throws IOException {
        writer.write("\"");
        writer.write(this.value.replace("\"", "\\\""));
        writer.write("\"");
    }

    public String toString() {
        return this.value;
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONString other = (JSONString)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

