/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONString;
import se.natusoft.json.JSONValue;

public class JSONObject
extends JSONValue {
    private Map<JSONString, JSONValue> properties = new HashMap<JSONString, JSONValue>();

    public JSONObject() {
    }

    public JSONObject(JSONErrorHandler errorHandler) {
        super(errorHandler);
    }

    static boolean isObjectStart(char c) {
        return c == '{';
    }

    static boolean isObjectEnd(char c) {
        return c == '}';
    }

    public Set<JSONString> getPropertyNames() {
        return this.properties.keySet();
    }

    public JSONValue getProperty(JSONString name) {
        return this.properties.get(name);
    }

    public JSONValue getProperty(String name) {
        return this.properties.get(new JSONString(name));
    }

    public void addProperty(JSONString name, JSONValue value) {
        this.properties.put(name, value);
    }

    public void addProperty(String name, JSONValue value) {
        this.properties.put(new JSONString(name), value);
    }

    @Override
    protected void readJSON(char c, JSONValue.JSONReader reader) throws IOException {
        c = reader.skipWhitespace(c);
        reader.assertChar(c, '{', "A JSON object must start with '{'!");
        c = reader.getChar();
        boolean done = false;
        while (!done) {
            if (!JSONObject.isObjectEnd(c = reader.skipWhitespace(c))) {
                JSONString property = JSONObject.createString(this.getErrorHandler());
                property.readJSON(c, reader);
                c = reader.getChar();
                c = reader.skipWhitespace(c);
                reader.assertChar(c, ':', "Expected a ':' after the name '" + property + "'!");
                c = reader.getChar();
                c = reader.skipWhitespace(c);
                JSONValue value = JSONValue.resolveAndParseJSONValue(c, reader, this.getErrorHandler());
                this.properties.put(property, value);
                c = reader.getChar();
                c = reader.skipWhitespace(c);
            }
            if (JSONObject.isObjectEnd(c)) {
                done = true;
                continue;
            }
            reader.assertChar(c, ",", "There must be a comma ',' after each name, value pair, or an '}' to end the object!");
            c = reader.getChar();
        }
    }

    @Override
    protected void writeJSON(JSONValue.JSONWriter writer, boolean compact) throws IOException {
        if (!compact) {
            writer.writeln("");
            writer.write(this.getIndent());
        }
        writer.write("{");
        if (!compact) {
            writer.writeln("");
        }
        int current = 0;
        int max = this.properties.size();
        for (JSONString property : this.getPropertyNames()) {
            JSONValue value = this.properties.get(property);
            value.setIndent(this.getIndent() + "    ");
            if (!compact) {
                writer.write(value.getIndent());
            }
            property.writeJSON(writer, compact);
            writer.write(": ");
            value.writeJSON(writer, compact);
            if (++current >= max) continue;
            writer.write(", ");
            if (compact) continue;
            writer.writeln("");
        }
        if (!compact) {
            writer.writeln("");
            writer.write(this.getIndent());
        }
        writer.write("}");
        if (!compact) {
            writer.writeln("");
        }
    }
}

