/*
 * Decompiled with CFR 0.152.
 */
package se.natusoft.json;

import java.io.IOException;
import se.natusoft.json.JSONErrorHandler;
import se.natusoft.json.JSONValue;

public class JSONNumber
extends JSONValue {
    private Number value;

    public JSONNumber(Number value) {
        this.value = value;
    }

    public JSONNumber(JSONErrorHandler errorHandler) {
        super(errorHandler);
    }

    static boolean isNumberStart(char c) {
        return "-0123456789".indexOf(c) >= 0;
    }

    public Number toNumber() {
        return this.value;
    }

    public double toDouble() {
        return this.value.doubleValue();
    }

    public float toFloat() {
        return this.value.floatValue();
    }

    public int toInt() {
        return this.value.intValue();
    }

    public long toLong() {
        return this.value.longValue();
    }

    public short toShort() {
        return this.value.shortValue();
    }

    public byte toByte() {
        return this.value.byteValue();
    }

    public String toString() {
        return "" + this.value;
    }

    public Object to(Class type) {
        Number result = null;
        if (type.isArray()) {
            type = type.getComponentType();
        }
        if (type == Double.TYPE || type == Double.class) {
            result = this.value;
        } else if (type == Float.TYPE || type == Float.class) {
            result = new Float(this.toFloat());
        } else if (type == Integer.TYPE || type == Integer.class) {
            result = new Integer(this.toInt());
        } else if (type == Long.TYPE || type == Long.class) {
            result = new Long(this.toLong());
        } else if (type == Short.TYPE || type == Short.class) {
            result = new Short(this.toShort());
        } else if (type == Byte.TYPE || type == Byte.class) {
            result = new Byte(this.toByte());
        } else {
            this.fail("Type '" + type.getName() + "' is not an accepted number type! Only double,float, int, long and short is suppprted!");
        }
        return result;
    }

    @Override
    protected void readJSON(char c, JSONValue.JSONReader reader) throws IOException {
        c = reader.skipWhitespace(c);
        reader.assertChar(c, "-0123456789", "Character '" + c + "' is an invalid start of a number! Valid start characters are: -0123456789");
        StringBuilder sb = new StringBuilder();
        sb.append(c);
        boolean read = false;
        while (!read) {
            c = reader.getChar();
            if (reader.checkValidChar(c, "0123456789.eE+-")) {
                sb.append(c);
                continue;
            }
            read = true;
            reader.ungetChar(c);
        }
        String sval = sb.toString();
        try {
            this.value = Byte.valueOf(sval);
        }
        catch (NumberFormatException nfe1) {
            try {
                this.value = Short.valueOf(sval);
            }
            catch (NumberFormatException nfe2) {
                try {
                    this.value = Integer.valueOf(sval);
                }
                catch (NumberFormatException nfe3) {
                    try {
                        this.value = Long.valueOf(sval);
                    }
                    catch (NumberFormatException nfe4) {
                        try {
                            this.value = Float.valueOf(sval);
                        }
                        catch (NumberFormatException nfe5) {
                            try {
                                this.value = Double.valueOf(sval);
                            }
                            catch (NumberFormatException nfe6) {
                                this.fail("Bad numeric value '" + sb.toString() + "'!", nfe6);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void writeJSON(JSONValue.JSONWriter writer, boolean compact) throws IOException {
        writer.write(this.value.toString());
    }
}

