/*
 * Decompiled with CFR 0.152.
 */
package saschpe.android.parser.pls;

import android.util.Log;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import saschpe.android.parser.pls.Playlist;
import saschpe.android.parser.pls.Playlist$Track;

public final class PlaylistParser {
    private static final String TAG = PlaylistParser.class.getSimpleName();
    private static final Pattern HEADER_PATTERN = Pattern.compile("\\s*\\[playlist\\]\\s*");
    private static final Pattern FOOTER_NUMBER_OF_ENTRIES_PATTERN = Pattern.compile("\\s*NumberOfEntries=(.*)", 2);
    private static final Pattern FOOTER_VERSION_PATTERN = Pattern.compile("\\s*Version=(.*)", 2);
    private static final Pattern FILE_PATTERN = Pattern.compile("\\s*File(\\d+)=(.*)", 2);
    private static final Pattern TITLE_PATTERN = Pattern.compile("\\s*Title(\\d+)=(.*)", 2);
    private static final Pattern LENGTH_PATTERN = Pattern.compile("\\s*Length(\\d+)=(.*)", 2);

    private PlaylistParser() {
    }

    public static Playlist parse(InputStream closeable) {
        ArrayList arrayList = new ArrayList();
        int n = -1;
        int n2 = -1;
        closeable = new BufferedReader(new InputStreamReader((InputStream)closeable));
        try {
            Object object;
            while ((object = ((BufferedReader)closeable).readLine()) != null) {
                Matcher matcher = FILE_PATTERN.matcher((CharSequence)object);
                if (matcher.matches()) {
                    int n3 = PlaylistParser.getTrackIndexAndAddIfMissing(arrayList, matcher);
                    ((Playlist$Track)arrayList.get((int)n3)).file = matcher.group(2).trim();
                    continue;
                }
                Matcher matcher2 = TITLE_PATTERN.matcher((CharSequence)object);
                if (matcher2.matches()) {
                    int n4 = PlaylistParser.getTrackIndexAndAddIfMissing(arrayList, matcher2);
                    ((Playlist$Track)arrayList.get((int)n4)).title = matcher2.group(2).trim();
                    continue;
                }
                matcher = LENGTH_PATTERN.matcher((CharSequence)object);
                if (matcher.matches()) {
                    int n5 = PlaylistParser.getTrackIndexAndAddIfMissing(arrayList, matcher);
                    ((Playlist$Track)arrayList.get((int)n5)).length = Long.valueOf(matcher.group(2).trim());
                    continue;
                }
                matcher2 = FOOTER_NUMBER_OF_ENTRIES_PATTERN.matcher((CharSequence)object);
                if (matcher2.matches()) {
                    n2 = Integer.valueOf(matcher2.group(1).trim());
                    continue;
                }
                if (!((Matcher)(object = FOOTER_VERSION_PATTERN.matcher((CharSequence)object))).matches()) continue;
                n = Integer.valueOf(((Matcher)object).group(1).trim());
            }
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)("Failed to parse playlist file: " + iOException));
        }
        if (arrayList.size() != n2) {
            Log.w((String)TAG, (String)"Parsed track count doesn't match proclaimed NumberOfEntries");
        }
        return new Playlist(arrayList, n);
    }

    public static Playlist parse(String object, String string) {
        try {
            return PlaylistParser.parse(new ByteArrayInputStream(((String)object).getBytes(string)));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            object = unsupportedEncodingException;
            unsupportedEncodingException.printStackTrace();
            return null;
        }
    }

    public static Playlist parse(String string) {
        return PlaylistParser.parse(string, "UTF-8");
    }

    private static int getTrackIndexAndAddIfMissing(List list, Matcher matcher) {
        int n = Integer.valueOf(matcher.group(1)) - 1;
        try {
            list.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            list.add(n, new Playlist$Track());
        }
        return n;
    }
}

