/*
 * Decompiled with CFR 0.152.
 */
package saschpe.android.customtabs;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import java.util.List;
import saschpe.android.customtabs.a;
import saschpe.android.customtabs.b;

public final class CustomTabsHelper {
    private CustomTabsSession a;
    private CustomTabsClient b;
    private CustomTabsServiceConnection c;
    private ConnectionCallback d;

    public static void openCustomTab(Context context, CustomTabsIntent customTabsIntent, Uri uri, CustomTabFallback fallback) {
        String string = saschpe.android.customtabs.a.a(context);
        if (string == null) {
            if (fallback != null) {
                fallback.openUri(context, uri);
            }
        } else {
            if (Build.VERSION.SDK_INT >= 22) {
                customTabsIntent.intent.putExtra("android.intent.extra.REFERRER", (Parcelable)Uri.parse((String)("2//" + context.getPackageName())));
            }
            customTabsIntent.intent.setPackage(string);
            customTabsIntent.launchUrl(context, uri);
        }
    }

    public static void addKeepAliveExtra(Context context, Intent intent) {
        Intent intent2 = new Intent().setClassName(context.getPackageName(), b.class.getCanonicalName());
        intent.putExtra("android.support.customtabs.extra.KEEP_ALIVE", (Parcelable)intent2);
    }

    public void unbindCustomTabsService(Activity activity) {
        if (this.c == null) {
            return;
        }
        activity.unbindService((ServiceConnection)this.c);
        this.b = null;
        this.a = null;
    }

    public CustomTabsSession getSession() {
        if (this.b == null) {
            this.a = null;
        } else if (this.a == null) {
            this.a = this.b.newSession(null);
        }
        return this.a;
    }

    public void setConnectionCallback(ConnectionCallback connectionCallback) {
        this.d = connectionCallback;
    }

    public void bindCustomTabsService(Activity activity) {
        if (this.b != null) {
            return;
        }
        String string = saschpe.android.customtabs.a.a((Context)activity);
        if (string == null) {
            return;
        }
        this.c = new CustomTabsServiceConnection(){

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient client) {
                CustomTabsHelper.this.b = client;
                CustomTabsHelper.this.b.warmup(0L);
                if (CustomTabsHelper.this.d != null) {
                    CustomTabsHelper.this.d.onCustomTabsConnected();
                }
                CustomTabsHelper.this.getSession();
            }

            public void onServiceDisconnected(ComponentName name) {
                CustomTabsHelper.this.b = null;
                if (CustomTabsHelper.this.d != null) {
                    CustomTabsHelper.this.d.onCustomTabsDisconnected();
                }
            }

            public void onBindingDied(ComponentName name) {
                CustomTabsHelper.this.b = null;
                if (CustomTabsHelper.this.d != null) {
                    CustomTabsHelper.this.d.onCustomTabsDisconnected();
                }
            }
        };
        CustomTabsClient.bindCustomTabsService((Context)activity, (String)string, (CustomTabsServiceConnection)this.c);
    }

    public boolean mayLaunchUrl(Uri uri, Bundle extras, List<Bundle> otherLikelyBundles) {
        if (this.b == null) {
            return false;
        }
        CustomTabsSession customTabsSession = this.getSession();
        return customTabsSession != null && customTabsSession.mayLaunchUrl(uri, extras, otherLikelyBundles);
    }

    public static interface CustomTabFallback {
        public void openUri(Context var1, Uri var2);
    }

    public static interface ConnectionCallback {
        public void onCustomTabsConnected();

        public void onCustomTabsDisconnected();
    }
}

