/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter.sessions;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import ru.qatools.gridrouter.config.Version;
import ru.qatools.gridrouter.sessions.AvailableBrowsersChecker;
import ru.qatools.gridrouter.sessions.StatsCounter;
import ru.qatools.gridrouter.sessions.WaitAvailableBrowserTimeoutException;

public class WaitAvailableBrowsersChecker
implements AvailableBrowsersChecker {
    private static final Logger LOGGER = LoggerFactory.getLogger(WaitAvailableBrowsersChecker.class);
    @Value(value="${grid.router.queue.interval.seconds}")
    protected int queueWaitInterval;
    @Autowired
    protected StatsCounter statsCounter;
    @Value(value="${grid.router.queue.timeout.seconds}")
    protected int queueTimeout;

    public WaitAvailableBrowsersChecker() {
    }

    public WaitAvailableBrowsersChecker(int queueTimeout, int queueWaitInterval, StatsCounter statsCounter) {
        this.queueTimeout = queueTimeout;
        this.queueWaitInterval = queueWaitInterval;
        this.statsCounter = statsCounter;
    }

    @Override
    public void ensureFreeBrowsersAvailable(String user, String remoteHost, String browser, Version version) {
        int waitAttempt = 0;
        String requestId = UUID.randomUUID().toString();
        ZonedDateTime waitingStarted = ZonedDateTime.now();
        Duration maxWait = Duration.ofSeconds(this.queueTimeout);
        while (maxWait.compareTo(Duration.between(waitingStarted, ZonedDateTime.now())) > 0 && this.countSessions(user, browser, version) >= version.getPermittedCount()) {
            try {
                this.onWait(user, browser, version, requestId, waitAttempt);
                Thread.sleep(TimeUnit.SECONDS.toMillis(this.queueWaitInterval));
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to sleep thread", (Throwable)e);
            }
            if (maxWait.compareTo(Duration.between(waitingStarted, ZonedDateTime.now())) >= 0) continue;
            this.onWaitTimeout(user, browser, version, requestId, waitAttempt);
        }
        this.onWaitFinished(user, browser, version, requestId, waitAttempt);
    }

    protected void onWaitTimeout(String user, String browser, Version version, String requestId, int waitAttempt) {
        throw new WaitAvailableBrowserTimeoutException(String.format("Waiting for available browser of %s %s timed out for %s after %s attempts", browser, version.getNumber(), user, waitAttempt));
    }

    protected void onWait(String user, String browser, Version version, String requestId, int waitAttempt) {
        LOGGER.info("[SESSION_WAIT_AVAILABLE_BROWSER] [{}] [{}] [{}] [{}] [{}]", new Object[]{user, browser, version.getNumber(), version.getPermittedCount(), ++waitAttempt});
    }

    protected void onWaitFinished(String user, String browser, Version version, String requestId, int waitAttempt) {
        LOGGER.info("[SESSION_WAIT_FINISHED] [{}] [{}] [{}] [{}] [{}]", new Object[]{user, browser, version.getNumber(), version.getPermittedCount(), ++waitAttempt});
    }

    protected int countSessions(String user, String browser, Version actualVersion) {
        return this.statsCounter.getSessionsCountForUserAndBrowser(user, browser, actualVersion.getNumber());
    }
}

