/*
 * Decompiled with CFR 0.152.
 */
package ru.qatools.gridrouter.sessions;

import java.time.Duration;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ru.qatools.gridrouter.sessions.BrowserVersion;
import ru.qatools.gridrouter.sessions.BrowsersCountMap;
import ru.qatools.gridrouter.sessions.StatsCounter;

public class MemoryStatsCounter
implements StatsCounter {
    private final Map<String, Temporal> session2instant = new HashMap<String, Temporal>();
    private final Map<String, String> session2user = new HashMap<String, String>();
    private final Map<String, BrowserVersion> session2browserVersion = new HashMap<String, BrowserVersion>();
    private final Map<String, BrowsersCountMap> user2browserCount = new HashMap<String, BrowsersCountMap>();

    @Override
    public synchronized void startSession(String sessionId, String user, String browser, String version, String route) {
        if (this.session2instant.put(sessionId, ZonedDateTime.now()) == null) {
            this.session2user.put(sessionId, user);
            this.session2browserVersion.put(sessionId, new BrowserVersion(browser, version));
            this.user2browserCount.putIfAbsent(user, new BrowsersCountMap());
            this.user2browserCount.get(user).increment(browser, version);
        }
    }

    @Override
    public void updateSession(String sessionId, String route) {
        this.session2instant.replace(sessionId, ZonedDateTime.now());
    }

    @Override
    public synchronized void deleteSession(String sessionId, String route) {
        if (this.session2instant.remove(sessionId) != null) {
            String user = this.session2user.remove(sessionId);
            BrowserVersion browser = this.session2browserVersion.remove(sessionId);
            this.user2browserCount.get(user).decrement(browser);
        }
    }

    @Override
    public void expireSessionsOlderThan(Duration duration) {
        List sessions2delete = this.session2instant.entrySet().stream().filter(e -> duration.compareTo(Duration.between((Temporal)e.getValue(), ZonedDateTime.now())) < 0).map(Map.Entry::getKey).collect(Collectors.toList());
        sessions2delete.stream().forEach(this::deleteSession);
    }

    @Override
    public Set<String> getActiveSessions() {
        return this.session2instant.keySet();
    }

    @Override
    public synchronized BrowsersCountMap getStats(String user) {
        return this.user2browserCount.getOrDefault(user, new BrowsersCountMap());
    }

    @Override
    public int getSessionsCountForUser(String user) {
        return this.user2browserCount.getOrDefault(user, new BrowsersCountMap()).values().parallelStream().flatMapToInt(version -> version.values().stream().mapToInt(Integer::intValue)).sum();
    }

    @Override
    public int getSessionsCountForUserAndBrowser(String user, String browser, String version) {
        return this.user2browserCount.getOrDefault(user, new BrowsersCountMap()).entrySet().parallelStream().filter(entry -> ((String)entry.getKey()).equals(browser)).flatMapToInt(entry -> ((Map)entry.getValue()).entrySet().parallelStream().filter(ver -> ((String)ver.getKey()).equals(version)).mapToInt(Map.Entry::getValue)).sum();
    }
}

